/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.classification.internal.value;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.opennms.netmgt.flows.classification.internal.value.IntegerValue;
import org.opennms.netmgt.flows.classification.internal.value.RangedValue;
import org.opennms.netmgt.flows.classification.internal.value.StringValue;

public class PortValue {
    private final Set<Integer> ports = new HashSet<Integer>();

    public PortValue(String input) {
        StringValue portValue = new StringValue(input);
        if (portValue.hasWildcard()) {
            throw new IllegalArgumentException("Wildcards not supported");
        }
        List<StringValue> portValues = portValue.splitBy(",");
        List<StringValue> rangedPortValues = portValues.stream().filter(v -> v.isRanged()).collect(Collectors.toList());
        rangedPortValues.forEach(v -> portValues.remove(v));
        this.ports.addAll(portValues.stream().map(v -> new IntegerValue((StringValue)v).getValue()).collect(Collectors.toList()));
        Set rangedPorts = rangedPortValues.stream().flatMap(v -> {
            RangedValue rangedValue = new RangedValue((StringValue)v);
            return IntStream.range(rangedValue.getStart(), rangedValue.getEnd() + 1).boxed();
        }).collect(Collectors.toSet());
        this.ports.addAll(rangedPorts);
    }

    public Set<Integer> getPorts() {
        return this.ports;
    }

    public boolean matches(int port) {
        return this.getPorts().contains(port);
    }
}

