/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.classification.internal.classifier;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opennms.netmgt.flows.classification.ClassificationRequest;
import org.opennms.netmgt.flows.classification.FilterService;
import org.opennms.netmgt.flows.classification.internal.classifier.Classifier;
import org.opennms.netmgt.flows.classification.internal.matcher.DstAddressMatcher;
import org.opennms.netmgt.flows.classification.internal.matcher.DstPortMatcher;
import org.opennms.netmgt.flows.classification.internal.matcher.FilterMatcher;
import org.opennms.netmgt.flows.classification.internal.matcher.Matcher;
import org.opennms.netmgt.flows.classification.internal.matcher.ProtocolMatcher;
import org.opennms.netmgt.flows.classification.internal.matcher.SrcAddressMatcher;
import org.opennms.netmgt.flows.classification.internal.matcher.SrcPortMatcher;
import org.opennms.netmgt.flows.classification.persistence.api.RuleDefinition;
import org.opennms.netmgt.flows.classification.persistence.api.RulePositionComparator;

public class CombinedClassifier
implements Classifier {
    private final List<Matcher> matchers;
    private final RuleDefinition ruleDefinition;
    private final RulePositionComparator rulePositionComparator = new RulePositionComparator();

    public CombinedClassifier(RuleDefinition ruleDefinition, FilterService filterService) {
        Objects.requireNonNull(ruleDefinition);
        ArrayList<Matcher> matchers = new ArrayList<Matcher>();
        if (ruleDefinition.hasProtocolDefinition()) {
            matchers.add(new ProtocolMatcher(ruleDefinition.getProtocol()));
        }
        if (ruleDefinition.hasSrcPortDefinition()) {
            matchers.add(new SrcPortMatcher(ruleDefinition.getSrcPort()));
        }
        if (ruleDefinition.hasSrcAddressDefinition()) {
            matchers.add(new SrcAddressMatcher(ruleDefinition.getSrcAddress()));
        }
        if (ruleDefinition.hasDstAddressDefinition()) {
            matchers.add(new DstAddressMatcher(ruleDefinition.getDstAddress()));
        }
        if (ruleDefinition.hasDstPortDefinition()) {
            matchers.add(new DstPortMatcher(ruleDefinition.getDstPort()));
        }
        if (ruleDefinition.hasExportFilterDefinition()) {
            matchers.add(new FilterMatcher(ruleDefinition.getExporterFilter(), filterService));
        }
        this.ruleDefinition = ruleDefinition;
        this.matchers = matchers;
    }

    @Override
    public String classify(ClassificationRequest request) {
        boolean matches = true;
        for (Matcher m : this.matchers) {
            if (matches = matches && m.matches(request)) continue;
            return null;
        }
        return this.ruleDefinition.getName();
    }

    @Override
    public int compareTo(Classifier o) {
        return this.rulePositionComparator.compare(this.ruleDefinition, ((CombinedClassifier)o).ruleDefinition);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CombinedClassifier that = (CombinedClassifier)o;
        return Objects.equals(this.ruleDefinition, that.ruleDefinition);
    }

    public int hashCode() {
        return Objects.hash(this.ruleDefinition);
    }
}

