/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.rpc.utils.mate;

import ch.hsr.geohash.GeoHash;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opennms.core.rpc.utils.mate.ContextKey;
import org.opennms.core.rpc.utils.mate.EmptyScope;
import org.opennms.core.rpc.utils.mate.EntityScopeProvider;
import org.opennms.core.rpc.utils.mate.FallbackScope;
import org.opennms.core.rpc.utils.mate.MapScope;
import org.opennms.core.rpc.utils.mate.ObjectScope;
import org.opennms.core.rpc.utils.mate.Scope;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.dao.api.SnmpInterfaceDao;
import org.opennms.netmgt.model.OnmsAssetRecord;
import org.opennms.netmgt.model.OnmsGeolocation;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMetaData;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.springframework.beans.factory.annotation.Autowired;

public class EntityScopeProviderImpl
implements EntityScopeProvider {
    @Autowired
    private NodeDao nodeDao;
    @Autowired
    private IpInterfaceDao ipInterfaceDao;
    @Autowired
    private SnmpInterfaceDao snmpInterfaceDao;
    @Autowired
    private MonitoredServiceDao monitoredServiceDao;
    @Autowired
    private SessionUtils sessionUtils;

    @Override
    public Scope getScopeForNode(Integer nodeId) {
        if (nodeId == null) {
            return EmptyScope.EMPTY;
        }
        return (Scope)this.sessionUtils.withReadOnlyTransaction(() -> {
            OnmsNode node = (OnmsNode)this.nodeDao.get((Serializable)nodeId);
            if (node == null) {
                return EmptyScope.EMPTY;
            }
            ArrayList<Scope> scopes = new ArrayList<Scope>();
            scopes.add(EntityScopeProviderImpl.transform(node.getMetaData()));
            ObjectScope<OnmsNode> nodeScope = new ObjectScope<OnmsNode>(node).map("node", "criteria", this::getNodeCriteria).map("node", "label", n -> Optional.ofNullable(n.getLabel())).map("node", "foreign-source", n -> Optional.ofNullable(n.getForeignSource())).map("node", "foreign-id", n -> Optional.ofNullable(n.getForeignId())).map("node", "netbios-domain", n -> Optional.ofNullable(n.getNetBiosDomain())).map("node", "netbios-name", n -> Optional.ofNullable(n.getNetBiosName())).map("node", "os", n -> Optional.ofNullable(n.getOperatingSystem())).map("node", "sys-name", n -> Optional.ofNullable(n.getSysName())).map("node", "sys-location", n -> Optional.ofNullable(n.getSysLocation())).map("node", "sys-contact", n -> Optional.ofNullable(n.getSysContact())).map("node", "sys-description", n -> Optional.ofNullable(n.getSysDescription())).map("node", "sys-object-id", n -> Optional.ofNullable(n.getSysObjectId())).map("node", "location", n -> Optional.ofNullable(n.getLocation().getLocationName())).map("node", "area", n -> Optional.ofNullable(n.getLocation().getMonitoringArea())).map("node", "geohash", this::getNodeGeoHash);
            scopes.add(nodeScope);
            if (node.getAssetRecord() != null) {
                ObjectScope<OnmsAssetRecord> assetScope = new ObjectScope<OnmsAssetRecord>(node.getAssetRecord()).map("asset", "category", a -> Optional.ofNullable(a.getCategory())).map("asset", "vendor", a -> Optional.ofNullable(a.getVendor())).map("asset", "manufacturer", a -> Optional.ofNullable(a.getManufacturer())).map("asset", "vendor", a -> Optional.ofNullable(a.getVendor())).map("asset", "model-number", a -> Optional.ofNullable(a.getModelNumber())).map("asset", "serial-number", a -> Optional.ofNullable(a.getSerialNumber())).map("asset", "description", a -> Optional.ofNullable(a.getDescription())).map("asset", "circuit-id", a -> Optional.ofNullable(a.getCircuitId())).map("asset", "asset-number", a -> Optional.ofNullable(a.getAssetNumber())).map("asset", "operating-system", a -> Optional.ofNullable(a.getOperatingSystem())).map("asset", "rack", a -> Optional.ofNullable(a.getRack())).map("asset", "slot", a -> Optional.ofNullable(a.getSlot())).map("asset", "port", a -> Optional.ofNullable(a.getPort())).map("asset", "region", a -> Optional.ofNullable(a.getRegion())).map("asset", "division", a -> Optional.ofNullable(a.getDivision())).map("asset", "department", a -> Optional.ofNullable(a.getDepartment())).map("asset", "building", a -> Optional.ofNullable(a.getBuilding())).map("asset", "floor", a -> Optional.ofNullable(a.getFloor())).map("asset", "room", a -> Optional.ofNullable(a.getRoom())).map("asset", "vendor-phone", a -> Optional.ofNullable(a.getVendorPhone())).map("asset", "vendor-fax", a -> Optional.ofNullable(a.getVendorFax())).map("asset", "vendor-asset-number", a -> Optional.ofNullable(a.getVendorAssetNumber())).map("asset", "username", a -> Optional.ofNullable(a.getUsername())).map("asset", "password", a -> Optional.ofNullable(a.getPassword())).map("asset", "enable", a -> Optional.ofNullable(a.getEnable())).map("asset", "connection", a -> Optional.ofNullable(a.getConnection())).map("asset", "autoenable", a -> Optional.ofNullable(a.getAutoenable())).map("asset", "last-modified-by", a -> Optional.ofNullable(a.getLastModifiedBy())).map("asset", "last-modified-date", a -> Optional.ofNullable(a.getLastModifiedDate()).map(Date::toString)).map("asset", "date-installed", a -> Optional.ofNullable(a.getDateInstalled())).map("asset", "lease", a -> Optional.ofNullable(a.getLease())).map("asset", "lease-expires", a -> Optional.ofNullable(a.getLeaseExpires())).map("asset", "support-phone", a -> Optional.ofNullable(a.getSupportPhone())).map("asset", "maintcontract", a -> Optional.ofNullable(a.getMaintcontract())).map("asset", "maint-contract-expiration", a -> Optional.ofNullable(a.getMaintContractExpiration())).map("asset", "display-category", a -> Optional.ofNullable(a.getDisplayCategory())).map("asset", "notify-category", a -> Optional.ofNullable(a.getNotifyCategory())).map("asset", "poller-category", a -> Optional.ofNullable(a.getPollerCategory())).map("asset", "threshold-category", a -> Optional.ofNullable(a.getThresholdCategory())).map("asset", "comment", a -> Optional.ofNullable(a.getComment())).map("asset", "cpu", a -> Optional.ofNullable(a.getCpu())).map("asset", "ram", a -> Optional.ofNullable(a.getRam())).map("asset", "storagectrl", a -> Optional.ofNullable(a.getStoragectrl())).map("asset", "hdd1", a -> Optional.ofNullable(a.getHdd1())).map("asset", "hdd2", a -> Optional.ofNullable(a.getHdd2())).map("asset", "hdd3", a -> Optional.ofNullable(a.getHdd3())).map("asset", "hdd4", a -> Optional.ofNullable(a.getHdd4())).map("asset", "hdd5", a -> Optional.ofNullable(a.getHdd5())).map("asset", "hdd6", a -> Optional.ofNullable(a.getHdd6())).map("asset", "numpowersupplies", a -> Optional.ofNullable(a.getNumpowersupplies())).map("asset", "inputpower", a -> Optional.ofNullable(a.getInputpower())).map("asset", "additionalhardware", a -> Optional.ofNullable(a.getAdditionalhardware())).map("asset", "admin", a -> Optional.ofNullable(a.getAdmin())).map("asset", "snmpcommunity", a -> Optional.ofNullable(a.getSnmpcommunity())).map("asset", "rackunitheight", a -> Optional.ofNullable(a.getRackunitheight())).map("asset", "managed-object-type", a -> Optional.ofNullable(a.getManagedObjectType())).map("asset", "managed-object-instance", a -> Optional.ofNullable(a.getManagedObjectInstance())).map("asset", "geolocation", a -> Optional.ofNullable(a.getGeolocation()).map(Object::toString));
                scopes.add(assetScope);
            }
            return new FallbackScope(scopes);
        });
    }

    private Optional<String> getNodeCriteria(OnmsNode node) {
        Objects.requireNonNull(node, "Node can not be null");
        if (node.getForeignSource() != null) {
            return Optional.of(node.getForeignSource() + ":" + node.getForeignId());
        }
        return Optional.of(Integer.toString(node.getId()));
    }

    private Optional<String> getNodeGeoHash(OnmsNode node) {
        double latitude = Double.NaN;
        double longitude = Double.NaN;
        OnmsAssetRecord assetRecord = node.getAssetRecord();
        if (assetRecord == null) {
            return Optional.empty();
        }
        OnmsGeolocation geolocation = assetRecord.getGeolocation();
        if (geolocation == null) {
            return Optional.empty();
        }
        if (geolocation.getLatitude() != null) {
            latitude = geolocation.getLatitude();
        }
        if (geolocation.getLongitude() != null) {
            longitude = geolocation.getLongitude();
        }
        if (!Double.isFinite(latitude) || !Double.isFinite(longitude)) {
            return Optional.empty();
        }
        return Optional.of(GeoHash.withCharacterPrecision((double)latitude, (double)longitude, (int)12).toBase32());
    }

    @Override
    public Scope getScopeForInterface(Integer nodeId, String ipAddress) {
        if (nodeId == null || Strings.isNullOrEmpty((String)ipAddress)) {
            return EmptyScope.EMPTY;
        }
        return (Scope)this.sessionUtils.withReadOnlyTransaction(() -> {
            OnmsIpInterface ipInterface = this.ipInterfaceDao.findByNodeIdAndIpAddress(nodeId, ipAddress);
            if (ipInterface == null) {
                return EmptyScope.EMPTY;
            }
            return new FallbackScope(EntityScopeProviderImpl.transform(ipInterface.getMetaData()), EntityScopeProviderImpl.mapIpInterfaceKeys(ipInterface).map("interface", "if-alias", i -> Optional.ofNullable(i.getSnmpInterface()).map(OnmsSnmpInterface::getIfAlias)).map("interface", "if-description", i -> Optional.ofNullable(i.getSnmpInterface()).map(OnmsSnmpInterface::getIfDescr)).map("interface", "phy-addr", i -> Optional.ofNullable(i.getSnmpInterface()).map(OnmsSnmpInterface::getPhysAddr)));
        });
    }

    private static ObjectScope<OnmsIpInterface> mapIpInterfaceKeys(OnmsIpInterface ipInterface) {
        return new ObjectScope<OnmsIpInterface>(ipInterface).map("interface", "hostname", i -> Optional.ofNullable(i.getIpHostName())).map("interface", "address", i -> Optional.ofNullable(i.getIpAddress()).map(InetAddressUtils::toIpAddrString)).map("interface", "netmask", i -> Optional.ofNullable(i.getNetMask()).map(InetAddressUtils::toIpAddrString)).map("interface", "if-index", i -> Optional.ofNullable(i.getIfIndex()).map(Object::toString));
    }

    @Override
    public Scope getScopeForInterfaceByIfIndex(Integer nodeId, int ifIndex) {
        if (nodeId == null) {
            return EmptyScope.EMPTY;
        }
        return (Scope)this.sessionUtils.withReadOnlyTransaction(() -> {
            OnmsSnmpInterface snmpInterface = this.snmpInterfaceDao.findByNodeIdAndIfIndex(nodeId, Integer.valueOf(ifIndex));
            if (snmpInterface == null) {
                return EmptyScope.EMPTY;
            }
            ArrayList<Scope> scopes = new ArrayList<Scope>();
            scopes.add(new ObjectScope<OnmsSnmpInterface>(snmpInterface).map("interface", "if-alias", i -> Optional.ofNullable(i.getIfAlias())).map("interface", "if-description", i -> Optional.ofNullable(i.getIfDescr())).map("interface", "phy-addr", i -> Optional.ofNullable(i.getPhysAddr())));
            Optional.ofNullable(snmpInterface.getPrimaryIpInterface()).ifPresent(ipInterface -> {
                scopes.add(EntityScopeProviderImpl.transform(ipInterface.getMetaData()));
                scopes.add(EntityScopeProviderImpl.mapIpInterfaceKeys(ipInterface));
            });
            return new FallbackScope(scopes);
        });
    }

    @Override
    public Scope getScopeForService(Integer nodeId, InetAddress ipAddress, String serviceName) {
        if (nodeId == null || ipAddress == null || Strings.isNullOrEmpty((String)serviceName)) {
            return EmptyScope.EMPTY;
        }
        return (Scope)this.sessionUtils.withReadOnlyTransaction(() -> {
            OnmsMonitoredService monitoredService = this.monitoredServiceDao.get(nodeId, ipAddress, serviceName);
            if (monitoredService == null) {
                return EmptyScope.EMPTY;
            }
            return new FallbackScope(EntityScopeProviderImpl.transform(monitoredService.getMetaData()), new ObjectScope<OnmsMonitoredService>(monitoredService).map("service", "name", s -> Optional.of(s.getServiceName())));
        });
    }

    private static MapScope transform(Collection<OnmsMetaData> metaData) {
        Map<ContextKey, String> map = metaData.stream().collect(Collectors.toMap(e -> new ContextKey(e.getContext(), e.getKey()), OnmsMetaData::getValue));
        return new MapScope(map);
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.nodeDao = Objects.requireNonNull(nodeDao);
    }

    public void setIpInterfaceDao(IpInterfaceDao ipInterfaceDao) {
        this.ipInterfaceDao = Objects.requireNonNull(ipInterfaceDao);
    }

    public void setMonitoredServiceDao(MonitoredServiceDao monitoredServiceDao) {
        this.monitoredServiceDao = Objects.requireNonNull(monitoredServiceDao);
    }

    public void setSessionUtils(SessionUtils sessionUtils) {
        this.sessionUtils = Objects.requireNonNull(sessionUtils);
    }
}

