/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.graphite.adapter;

import com.codahale.metrics.MetricRegistry;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import javax.script.ScriptException;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionAgentFactory;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.dao.api.InterfaceToNodeCache;
import org.opennms.netmgt.telemetry.api.adapter.TelemetryMessageLog;
import org.opennms.netmgt.telemetry.api.adapter.TelemetryMessageLogEntry;
import org.opennms.netmgt.telemetry.config.api.AdapterDefinition;
import org.opennms.netmgt.telemetry.protocols.collection.AbstractScriptedCollectionAdapter;
import org.opennms.netmgt.telemetry.protocols.collection.CollectionSetWithAgent;
import org.opennms.netmgt.telemetry.protocols.collection.ScriptedCollectionSetBuilder;
import org.opennms.netmgt.telemetry.protocols.graphite.adapter.GraphiteMetric;

public class GraphiteAdapter
extends AbstractScriptedCollectionAdapter {
    private CollectionAgentFactory collectionAgentFactory;
    private InterfaceToNodeCache interfaceToNodeCache;

    public GraphiteAdapter(AdapterDefinition adapterConfig, MetricRegistry metricRegistry) {
        super(adapterConfig, metricRegistry);
    }

    public Stream<CollectionSetWithAgent> handleCollectionMessage(TelemetryMessageLogEntry message, TelemetryMessageLog messageLog) {
        String messageText = new String(message.getByteArray());
        this.LOG.trace("plaintext message: {}", (Object)messageText);
        String[] lines = messageText.split("\n");
        CollectionAgent agent = null;
        try {
            InetAddress inetAddress = InetAddressUtils.addr((String)messageLog.getSourceAddress());
            Optional nodeId = this.interfaceToNodeCache.getFirstNodeId(messageLog.getLocation(), inetAddress);
            if (nodeId.isPresent()) {
                agent = this.collectionAgentFactory.createCollectionAgent(Integer.toString((Integer)nodeId.get()), inetAddress);
            }
        }
        catch (RuntimeException e) {
            this.LOG.warn("Unable to determine source address from message log.", (Throwable)e);
            return Stream.empty();
        }
        if (agent == null) {
            this.LOG.warn("Unable to determine collection agent from location={} and address={}", (Object)messageLog.getLocation(), (Object)messageLog.getSourceAddress());
            return Stream.empty();
        }
        ScriptedCollectionSetBuilder builder = this.getCollectionBuilder();
        if (builder == null) {
            this.LOG.error("Error compiling script '{}'. See logs for details.", (Object)this.getScript());
            return Stream.empty();
        }
        ArrayList<CollectionSetWithAgent> collectionSets = new ArrayList<CollectionSetWithAgent>();
        for (String line : lines) {
            String[] entry = line.split(" ", 3);
            if (entry.length != 3) {
                this.LOG.warn("Unparseable graphite plaintext message: {}", (Object)line);
                continue;
            }
            try {
                GraphiteMetric metric = new GraphiteMetric(entry[0], entry[1], Long.valueOf(entry[2], 10));
                CollectionSet collectionSet = builder.build(agent, (Object)metric, Long.valueOf(metric.getTimestamp()));
                collectionSets.add(new CollectionSetWithAgent(agent, collectionSet));
            }
            catch (NumberFormatException | ScriptException e) {
                this.LOG.warn("Dropping metric, unable to create collection set: {}", Arrays.asList(entry), (Object)e);
            }
        }
        return collectionSets.stream();
    }

    public void setCollectionAgentFactory(CollectionAgentFactory collectionAgentFactory) {
        this.collectionAgentFactory = collectionAgentFactory;
    }

    public void setInterfaceToNodeCache(InterfaceToNodeCache interfaceToNodeCache) {
        this.interfaceToNodeCache = interfaceToNodeCache;
    }
}

