/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.daemon;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.core.rpc.utils.mate.EntityScopeProvider;
import org.opennms.core.rpc.utils.mate.FallbackScope;
import org.opennms.core.rpc.utils.mate.Interpolator;
import org.opennms.core.rpc.utils.mate.Scope;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.ServiceRef;
import org.opennms.netmgt.dao.api.ServiceTracker;
import org.opennms.netmgt.telemetry.api.receiver.Connector;
import org.opennms.netmgt.telemetry.api.registry.TelemetryRegistry;
import org.opennms.netmgt.telemetry.config.api.ConnectorDefinition;
import org.opennms.netmgt.telemetry.config.model.ConnectorConfig;
import org.opennms.netmgt.telemetry.config.model.PackageConfig;
import org.opennms.netmgt.telemetry.config.model.Parameter;
import org.opennms.netmgt.telemetry.config.model.TelemetrydConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ConnectorManager {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectorManager.class);
    @Autowired
    private TelemetryRegistry telemetryRegistry;
    @Autowired
    private EntityScopeProvider entityScopeProvider;
    @Autowired
    private ServiceTracker serviceTracker;
    private final Map<ConnectorKey, Connector> connectorsByKey = new LinkedHashMap<ConnectorKey, Connector>();
    private final List<Closeable> serviceTrackerSessions = new LinkedList<Closeable>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startStreamingFor(ConnectorConfig connectorConfig, PackageConfig packageConfig, ServiceRef serviceRef) {
        Map<ConnectorKey, Connector> map = this.connectorsByKey;
        synchronized (map) {
            ConnectorKey key = ConnectorManager.toKey(connectorConfig, packageConfig, serviceRef);
            if (this.connectorsByKey.containsKey(key)) {
                LOG.debug("Connector already exists. Ignoring.");
            }
            List<Map<String, String>> interpolatedMapList = this.getGroupedParams(packageConfig, serviceRef);
            LOG.debug("Starting connector for: {}", (Object)key);
            Connector connector = this.telemetryRegistry.getConnector((ConnectorDefinition)connectorConfig);
            this.connectorsByKey.put(key, connector);
            connector.stream(serviceRef.getNodeId(), serviceRef.getIpAddress(), interpolatedMapList);
        }
    }

    List<Map<String, String>> getGroupedParams(PackageConfig packageConfig, ServiceRef serviceRef) {
        ArrayList<Map<String, String>> interpolatedMapList = new ArrayList<Map<String, String>>();
        Map<String, Map<String, String>> parmMapByGroup = packageConfig.getParameters().stream().peek(parameter -> {
            if (parameter.getGroup() == null) {
                parameter.setGroup("");
            }
        }).collect(Collectors.groupingBy(Parameter::getGroup, Collectors.toMap(Parameter::getKey, Parameter::getValue)));
        parmMapByGroup.forEach((group, parmeterMap) -> interpolatedMapList.add(this.getInterpolated((Map<String, String>)parmeterMap, serviceRef)));
        return interpolatedMapList;
    }

    private Map<String, String> getInterpolated(Map<String, String> parameterMap, ServiceRef serviceRef) {
        return Interpolator.interpolateStrings(parameterMap, (Scope)new FallbackScope(new Scope[]{this.entityScopeProvider.getScopeForNode(Integer.valueOf(serviceRef.getNodeId())), this.entityScopeProvider.getScopeForInterface(Integer.valueOf(serviceRef.getNodeId()), InetAddressUtils.str((InetAddress)serviceRef.getIpAddress())), this.entityScopeProvider.getScopeForService(Integer.valueOf(serviceRef.getNodeId()), serviceRef.getIpAddress(), serviceRef.getServiceName())}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopStreamingFor(ConnectorConfig connectorConfig, PackageConfig packageConfig, ServiceRef serviceRef) {
        Map<ConnectorKey, Connector> map = this.connectorsByKey;
        synchronized (map) {
            ConnectorKey key = ConnectorManager.toKey(connectorConfig, packageConfig, serviceRef);
            Connector connector = this.connectorsByKey.remove(key);
            if (connector != null) {
                try {
                    LOG.debug("Closing connector for: {}", (Object)key);
                    connector.close();
                }
                catch (IOException e) {
                    LOG.warn("Error closing connector: {}", (Object)key, (Object)e);
                }
            }
        }
    }

    public void start(TelemetrydConfig config) {
        for (final ConnectorConfig connectorConfig : config.getConnectors()) {
            if (connectorConfig.getPackages().isEmpty()) {
                LOG.warn("No packages defined for connector named: {}. No connections will be attempted.", (Object)connectorConfig.getName());
                continue;
            }
            LOG.info("Watching for services named '{}' for connector: {}", (Object)connectorConfig.getServiceName(), (Object)connectorConfig.getName());
            for (final PackageConfig packageConfig : connectorConfig.getPackages()) {
                Closeable session = this.serviceTracker.trackServiceMatchingFilterRule(connectorConfig.getServiceName(), packageConfig.getFilterRule(), new ServiceTracker.ServiceListener(){

                    public void onServiceMatched(ServiceRef serviceRef) {
                        ConnectorManager.this.startStreamingFor(connectorConfig, packageConfig, serviceRef);
                    }

                    public void onServiceStoppedMatching(ServiceRef serviceRef) {
                        ConnectorManager.this.stopStreamingFor(connectorConfig, packageConfig, serviceRef);
                    }
                });
                this.serviceTrackerSessions.add(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.serviceTrackerSessions.forEach(s -> {
            try {
                s.close();
            }
            catch (Exception e) {
                LOG.warn("Failed to close filter watch session. Resources may not be properly recovered.", (Throwable)e);
            }
        });
        this.serviceTrackerSessions.clear();
        Map<ConnectorKey, Connector> map = this.connectorsByKey;
        synchronized (map) {
            this.connectorsByKey.forEach((key, connector) -> {
                try {
                    connector.close();
                }
                catch (IOException e) {
                    LOG.warn("Error closing connector: {}. Resources may not be properly recovered.", key, (Object)e);
                }
            });
        }
    }

    private static ConnectorKey toKey(ConnectorConfig connectorConfig, PackageConfig packageConfig, ServiceRef serviceRef) {
        return new ConnectorKey(connectorConfig.getName(), packageConfig.getName(), serviceRef.getNodeId(), serviceRef.getIpAddress());
    }

    @VisibleForTesting
    public void setEntityScopeProvider(EntityScopeProvider entityScopeProvider) {
        this.entityScopeProvider = entityScopeProvider;
    }

    private static class ConnectorKey {
        private final String connectorName;
        private final String packageName;
        private final int nodeId;
        private final InetAddress interfaceAddress;

        public ConnectorKey(String connectorName, String packageName, int nodeId, InetAddress interfaceAddress) {
            this.connectorName = connectorName;
            this.packageName = packageName;
            this.nodeId = nodeId;
            this.interfaceAddress = interfaceAddress;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConnectorKey)) {
                return false;
            }
            ConnectorKey that = (ConnectorKey)o;
            return this.nodeId == that.nodeId && Objects.equals(this.connectorName, that.connectorName) && Objects.equals(this.packageName, that.packageName) && Objects.equals(this.interfaceAddress, that.interfaceAddress);
        }

        public int hashCode() {
            return Objects.hash(this.connectorName, this.packageName, this.nodeId, this.interfaceAddress);
        }

        public String toString() {
            return "ConnectorKey{connectorName='" + this.connectorName + '\'' + ", packageName='" + this.packageName + '\'' + ", nodeId=" + this.nodeId + ", interfaceAddress=" + this.interfaceAddress + '}';
        }
    }
}

