/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.sink.camel.server;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import io.opentracing.Scope;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapExtractAdapter;
import io.opentracing.util.GlobalTracer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.opennms.core.ipc.sink.api.SinkModule;
import org.opennms.core.ipc.sink.camel.server.CamelMessageConsumerManager;
import org.opennms.core.tracing.api.TracerRegistry;
import org.opennms.core.tracing.util.TracingInfoCarrier;

public class CamelSinkServerProcessor
implements Processor {
    private final CamelMessageConsumerManager consumerManager;
    private final SinkModule<?, org.opennms.core.ipc.sink.api.Message> module;
    private final TracerRegistry tracerRegistry;
    private Histogram messageSize;
    private Timer dispatchTime;

    public CamelSinkServerProcessor(CamelMessageConsumerManager consumerManager, SinkModule<?, org.opennms.core.ipc.sink.api.Message> module, TracerRegistry tracerRegistry, MetricRegistry metricRegistry) {
        this.consumerManager = Objects.requireNonNull(consumerManager);
        this.module = Objects.requireNonNull(module);
        this.tracerRegistry = tracerRegistry;
        this.messageSize = metricRegistry.histogram(MetricRegistry.name((String)module.getId(), (String[])new String[]{"messageSize"}));
        this.dispatchTime = metricRegistry.timer(MetricRegistry.name((String)module.getId(), (String[])new String[]{"dispatchTime"}));
    }

    public void process(Exchange exchange) {
        byte[] messageBytes = (byte[])exchange.getIn().getBody(byte[].class);
        HashMap<String, String> tracingInfo = new HashMap<String, String>();
        Tracer.SpanBuilder spanBuilder = this.buildSpanFromHeaders(exchange.getIn(), tracingInfo);
        this.messageSize.update(messageBytes.length);
        try (Scope scope = spanBuilder.startActive(true);
             Timer.Context context = this.dispatchTime.time();){
            scope.span().setTag("messageSize", (Number)messageBytes.length);
            scope.span().setTag("thread", Thread.currentThread().getName());
            if (exchange.getIn().getHeader("JmsQueueName") instanceof String) {
                String topic = (String)exchange.getIn().getHeader("JmsQueueName", String.class);
                scope.span().setTag("topic", topic);
            }
            org.opennms.core.ipc.sink.api.Message message = this.module.unmarshal(messageBytes);
            this.consumerManager.dispatch(this.module, message);
        }
    }

    private Tracer.SpanBuilder buildSpanFromHeaders(Message message, Map<String, String> tracingInfo) {
        String tracingInfoObj = (String)message.getHeader("SinkTracingInfo", String.class);
        if (tracingInfoObj != null) {
            tracingInfo.putAll(TracingInfoCarrier.unmarshalTracinginfo((String)tracingInfoObj));
        }
        Tracer tracer = this.tracerRegistry != null ? this.tracerRegistry.getTracer() : GlobalTracer.get();
        SpanContext context = tracer.extract(Format.Builtin.TEXT_MAP, (Object)new TextMapExtractAdapter(tracingInfo));
        Tracer.SpanBuilder spanBuilder = context != null ? tracer.buildSpan(this.module.getId()).asChildOf(context) : tracer.buildSpan(this.module.getId());
        return spanBuilder;
    }
}

