/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.persistence;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.swrve.ratelimitedlogger.RateLimitedLog;
import java.io.IOException;
import java.time.Duration;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.opennms.netmgt.flows.api.EnrichedFlow;
import org.opennms.netmgt.flows.api.EnrichedFlowForwarder;
import org.opennms.netmgt.flows.persistence.FlowDocumentBuilder;
import org.opennms.netmgt.flows.persistence.model.FlowDocument;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaFlowForwarder
implements EnrichedFlowForwarder {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaFlowForwarder.class);
    public static final String KAFKA_CLIENT_PID = "org.opennms.features.flows.persistence.kafka";
    private final ConfigurationAdmin configAdmin;
    private KafkaProducer<String, byte[]> producer;
    private String topicName;
    private static final RateLimitedLog RATE_LIMITED_LOG = RateLimitedLog.withRateLimit((Logger)LOG).maxRate(1).every(Duration.ofSeconds(60L)).build();
    private Properties producerConfig;
    private final Meter forwarded;
    private final Meter persisted;
    private final Counter skipped;
    private final Counter failed;

    public KafkaFlowForwarder(ConfigurationAdmin configAdmin, MetricRegistry metricRegistry) {
        this.configAdmin = configAdmin;
        this.forwarded = metricRegistry.meter("forwarded");
        this.persisted = metricRegistry.meter("persisted");
        this.skipped = metricRegistry.counter("skipped");
        this.failed = metricRegistry.counter("failed");
    }

    public void forward(EnrichedFlow enrichedFlow) {
        this.forwarded.mark();
        if (this.producer == null) {
            this.skipped.inc();
            RATE_LIMITED_LOG.warn("Kafka Producer is not configured for flow forwarding.");
            return;
        }
        try {
            FlowDocument flowDocument = FlowDocumentBuilder.buildFlowDocument(enrichedFlow);
            ProducerRecord record = new ProducerRecord(this.topicName, (Object)flowDocument.toByteArray());
            this.producer.send(record, (recordMetadata, e) -> {
                if (e != null) {
                    this.failed.inc();
                    RATE_LIMITED_LOG.warn("Failed to send flow document to kafka: {}.", (Object)record, (Object)e);
                } else if (LOG.isTraceEnabled()) {
                    this.persisted.mark();
                    LOG.trace("Persisted flow document {} to kafka.", (Object)flowDocument);
                }
            });
        }
        catch (Exception e2) {
            LOG.error("Exception while sending flow to kafka.", (Throwable)e2);
        }
    }

    public void init() throws IOException {
        this.producerConfig = new Properties();
        Dictionary properties = this.configAdmin.getConfiguration(KAFKA_CLIENT_PID).getProperties();
        if (properties != null) {
            Enumeration keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                this.producerConfig.put(key, properties.get(key));
            }
        }
        if (this.producerConfig.getProperty("bootstrap.servers") != null) {
            this.producerConfig.put("key.serializer", StringSerializer.class.getCanonicalName());
            this.producerConfig.put("value.serializer", ByteArraySerializer.class.getCanonicalName());
            this.producer = KafkaFlowForwarder.runWithGivenClassLoader(() -> new KafkaProducer(this.producerConfig), KafkaProducer.class.getClassLoader());
            LOG.info("Kafka Producer initialized with config {}", (Object)this.producerConfig);
        }
    }

    public void destroy() {
        if (this.producer != null) {
            LOG.info("Closed Kafka Producer");
            this.producer.close();
            this.producer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T runWithGivenClassLoader(Supplier<T> supplier, ClassLoader classLoader) {
        Objects.requireNonNull(supplier);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            T t = supplier.get();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }
}

