/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.collection;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.Objects;
import org.opennms.netmgt.telemetry.api.adapter.Adapter;
import org.opennms.netmgt.telemetry.api.adapter.TelemetryMessageLog;
import org.opennms.netmgt.telemetry.api.adapter.TelemetryMessageLogEntry;
import org.opennms.netmgt.telemetry.config.api.AdapterDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAdapter
implements Adapter {
    protected final Logger LOG = LoggerFactory.getLogger(AbstractAdapter.class);
    protected final Timer logParsingTimer;
    protected final Histogram packetsPerLogHistogram;
    protected final AdapterDefinition adapterConfig;

    public AbstractAdapter(AdapterDefinition adapterConfig, MetricRegistry metricRegistry) {
        this.adapterConfig = Objects.requireNonNull(adapterConfig);
        Objects.requireNonNull(metricRegistry);
        this.logParsingTimer = metricRegistry.timer(MetricRegistry.name((String)"adapters", (String[])new String[]{adapterConfig.getFullName(), "logParsing"}));
        this.packetsPerLogHistogram = metricRegistry.histogram(MetricRegistry.name((String)"adapters", (String[])new String[]{adapterConfig.getFullName(), "packetsPerLog"}));
    }

    public abstract void handleMessage(TelemetryMessageLogEntry var1, TelemetryMessageLog var2);

    public void handleMessageLog(TelemetryMessageLog messageLog) {
        try (Timer.Context ctx = this.logParsingTimer.time();){
            for (TelemetryMessageLogEntry message : messageLog.getMessageList()) {
                this.handleMessage(message, messageLog);
            }
            this.packetsPerLogHistogram.update(messageLog.getMessageList().size());
        }
    }

    public void destroy() {
    }
}

