/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.common.kafka;

import org.opennms.core.utils.SystemInfoUtils;

public class KafkaTopicProvider {
    private static final String TOPIC_NAME_AT_LOCATION = "%s.%s.%s";
    private static final String TOPIC_NAME_WITHOUT_LOCATION = "%s.%s";
    private static final String TOPIC_NAME_WITH_MODULE = "%s.%s.%s";
    private static final String TOPIC_NAME_WITH_MODULE_AND_LOCATION = "%s.%s.%s.%s";
    private final boolean singleTopic;

    public KafkaTopicProvider(boolean singleTopic) {
        this.singleTopic = singleTopic;
    }

    public KafkaTopicProvider() {
        this.singleTopic = Boolean.getBoolean(String.format("%s%s", "org.opennms.core.ipc.rpc.kafka.", "single-topic"));
    }

    public String getRequestTopicAtLocation(String location, String module) {
        if (this.singleTopic) {
            return String.format("%s.%s.%s", SystemInfoUtils.getInstanceId(), location, "rpc-request");
        }
        return String.format(TOPIC_NAME_WITH_MODULE_AND_LOCATION, SystemInfoUtils.getInstanceId(), location, "rpc-request", module);
    }

    public String getResponseTopic(String module) {
        if (this.singleTopic) {
            return String.format(TOPIC_NAME_WITHOUT_LOCATION, SystemInfoUtils.getInstanceId(), "rpc-response");
        }
        return String.format("%s.%s.%s", SystemInfoUtils.getInstanceId(), "rpc-response", module);
    }
}

