/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.imp.Reply;
import com.atomikos.icatch.imp.Result;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

class PrepareResult
extends Result {
    protected Hashtable readonlytable_ = new Hashtable();
    protected Hashtable indoubts_ = new Hashtable();
    protected Hashtable heuristics_ = new Hashtable();
    protected boolean analyzed_ = false;
    protected Vector msgvector_ = new Vector();

    public PrepareResult(int count) {
        super(count);
    }

    @Override
    protected synchronized void calculateResultFromAllReplies() throws IllegalStateException, InterruptedException {
        if (this.analyzed_) {
            return;
        }
        boolean allReadOnly = true;
        boolean allYes = true;
        boolean heurmixed = false;
        boolean heurhazards = false;
        boolean heurcommits = false;
        Stack<Reply> replies = this.getReplies();
        Enumeration enumm = replies.elements();
        while (enumm.hasMoreElements()) {
            boolean yes = false;
            boolean readonly = false;
            Reply reply = (Reply)enumm.nextElement();
            if (reply.hasFailed()) {
                yes = false;
                readonly = false;
                Exception err = reply.getException();
                if (err instanceof HeurMixedException) {
                    heurmixed = true;
                    HeurMixedException hm = (HeurMixedException)((Object)err);
                    this.addMessages(hm.getHeuristicMessages());
                } else if (err instanceof HeurCommitException) {
                    heurcommits = true;
                    HeurCommitException hc = (HeurCommitException)((Object)err);
                    this.addMessages(hc.getHeuristicMessages());
                    heurmixed = heurmixed || heurhazards;
                } else if (err instanceof HeurHazardException) {
                    heurhazards = true;
                    heurmixed = heurmixed || heurcommits;
                    HeurHazardException hr = (HeurHazardException)((Object)err);
                    this.indoubts_.put(reply.getParticipant(), new Boolean(true));
                    this.addMessages(hr.getHeuristicMessages());
                }
            } else {
                readonly = reply.getResponse() == null;
                Boolean answer = new Boolean(false);
                if (!readonly) {
                    answer = (Boolean)reply.getResponse();
                }
                boolean bl = yes = readonly || answer != false;
                if (readonly) {
                    this.readonlytable_.put(reply.getParticipant(), new Boolean(true));
                } else {
                    this.indoubts_.put(reply.getParticipant(), new Boolean(true));
                }
            }
            allYes = allYes && yes;
            allReadOnly = allReadOnly && readonly;
        }
        if (heurmixed) {
            this.result_ = 2;
        } else if (heurcommits) {
            this.result_ = 4;
        } else if (heurhazards) {
            this.result_ = 1;
        } else if (allReadOnly) {
            this.result_ = 5;
        } else if (allYes) {
            this.result_ = 0;
        }
        this.analyzed_ = true;
    }

    public boolean allYes() throws InterruptedException {
        this.calculateResultFromAllReplies();
        return this.result_ == 0 || this.result_ == 5;
    }

    public boolean allReadOnly() throws InterruptedException {
        this.calculateResultFromAllReplies();
        return this.result_ == 5;
    }

    public Hashtable getReadOnlyTable() throws InterruptedException {
        this.calculateResultFromAllReplies();
        return this.readonlytable_;
    }

    public Hashtable getIndoubtTable() throws InterruptedException {
        this.calculateResultFromAllReplies();
        return this.indoubts_;
    }
}

