/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.core;

import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionAgentService;
import org.opennms.netmgt.collection.core.DefaultCollectionAgentService;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.model.ResourceTypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;

public class DefaultCollectionAgent
implements CollectionAgent {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCollectionAgent.class);
    private long m_sysUpTime = -1L;
    private final int m_nodeId;
    private final InetAddress m_inetAddress;
    private String m_foreignSource = null;
    private String m_foreignId = null;
    private String m_locationName = null;
    private String m_nodeLabel = null;
    private ResourcePath m_storageResourcePath = null;
    protected CollectionAgentService m_agentService;
    private transient Map<String, Object> m_properties;

    public static CollectionAgent create(Integer ifaceId, IpInterfaceDao ifaceDao, PlatformTransactionManager transMgr) {
        return new DefaultCollectionAgent(DefaultCollectionAgentService.create(ifaceId, ifaceDao, transMgr));
    }

    public static CollectionAgent create(Integer ifaceId, IpInterfaceDao ifaceDao, PlatformTransactionManager transMgr, String location) {
        return new DefaultCollectionAgent(DefaultCollectionAgentService.create(ifaceId, ifaceDao, transMgr), location);
    }

    private DefaultCollectionAgent(CollectionAgentService agentService) {
        this(agentService, null);
    }

    protected DefaultCollectionAgent(CollectionAgentService agentService, String location) {
        this.m_agentService = agentService;
        this.m_storageResourcePath = agentService.getStorageResourcePath();
        this.m_locationName = location;
        this.m_inetAddress = this.m_agentService.getInetAddress();
        this.m_nodeId = this.m_agentService.getNodeId();
    }

    public final InetAddress getAddress() {
        return this.m_inetAddress;
    }

    public final Set<String> getAttributeNames() {
        return this.m_properties != null ? this.m_properties.keySet() : Collections.emptySet();
    }

    public final synchronized <V> V getAttribute(String property) {
        Object rc = null;
        if (this.m_properties != null) {
            rc = this.m_properties.get(property);
        }
        Object retval = rc;
        return (V)retval;
    }

    public final synchronized Object setAttribute(String property, Object value) {
        if (this.m_properties == null) {
            this.m_properties = new HashMap<String, Object>();
        }
        return this.m_properties.put(property, value);
    }

    public final Boolean isStoreByForeignSource() {
        return ResourceTypeUtils.isStoreByForeignSource();
    }

    public final String getHostAddress() {
        return InetAddressUtils.str((InetAddress)this.getAddress());
    }

    public final int getNodeId() {
        return this.m_nodeId;
    }

    public final String getNodeLabel() {
        if (this.m_nodeLabel == null) {
            this.m_nodeLabel = this.m_agentService.getNodeLabel();
        }
        return this.m_nodeLabel;
    }

    public final String getForeignSource() {
        if (this.m_foreignSource == null) {
            this.m_foreignSource = this.m_agentService.getForeignSource();
        }
        return this.m_foreignSource;
    }

    public final String getForeignId() {
        if (this.m_foreignId == null) {
            this.m_foreignId = this.m_agentService.getForeignId();
        }
        return this.m_foreignId;
    }

    public final String getLocationName() {
        if (this.m_locationName == null) {
            this.m_locationName = this.m_agentService.getLocationName();
        }
        return this.m_locationName;
    }

    public final ResourcePath getStorageResourcePath() {
        return this.m_storageResourcePath;
    }

    protected void logCompletion() {
        LOG.debug("initialize: initialization completed: nodeid = {}, address = {}", (Object)this.getNodeId(), (Object)this.getHostAddress());
    }

    protected void logCollectionParms() {
        LOG.debug("initialize: db retrieval info: nodeid = {}, address = {}", (Object)this.getNodeId(), (Object)this.getHostAddress());
    }

    public String toString() {
        return "Agent[nodeid = " + this.getNodeId() + " ipaddr= " + this.getHostAddress() + ']';
    }

    public final long getSavedSysUpTime() {
        return this.m_sysUpTime;
    }

    public final void setSavedSysUpTime(long sysUpTime) {
        this.m_sysUpTime = sysUpTime;
    }
}

