/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.persistence.rrd;

import java.io.File;
import java.io.FileNotFoundException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.opennms.core.utils.StringUtils;
import org.opennms.netmgt.collection.api.AttributeType;
import org.opennms.netmgt.collection.api.ByNameComparator;
import org.opennms.netmgt.collection.api.CollectionAttributeType;
import org.opennms.netmgt.collection.api.NumericCollectionAttributeType;
import org.opennms.netmgt.collection.api.PersistException;
import org.opennms.netmgt.collection.api.PersistOperationBuilder;
import org.opennms.netmgt.collection.api.ResourceIdentifier;
import org.opennms.netmgt.collection.api.TimeKeeper;
import org.opennms.netmgt.collection.support.DefaultTimeKeeper;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.rrd.RrdAttributeType;
import org.opennms.netmgt.rrd.RrdDataSource;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdMetaDataUtils;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class RrdPersistOperationBuilder
implements PersistOperationBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(RrdPersistOperationBuilder.class);
    private final RrdStrategy<?, ?> m_rrdStrategy;
    private final RrdRepository m_repository;
    private final String m_rrdName;
    private final ResourceIdentifier m_resource;
    private final Map<CollectionAttributeType, Number> m_declarations;
    private final Map<String, String> m_metaData = new LinkedHashMap<String, String>();
    private TimeKeeper m_timeKeeper = new DefaultTimeKeeper();
    public static final int MAX_DS_NAME_LENGTH = 19;

    public RrdPersistOperationBuilder(RrdStrategy<?, ?> rrdStrategy, RrdRepository repository, ResourceIdentifier resource, String rrdName, boolean dontReorderAttributes) {
        this.m_rrdStrategy = rrdStrategy;
        this.m_repository = repository;
        this.m_resource = resource;
        this.m_rrdName = rrdName;
        this.m_declarations = dontReorderAttributes ? new LinkedHashMap<CollectionAttributeType, Number>() : new TreeMap<CollectionAttributeType, Number>((Comparator<CollectionAttributeType>)new ByNameComparator());
    }

    public RrdStrategy<?, ?> getRrdStrategy() {
        return this.m_rrdStrategy;
    }

    public RrdRepository getRepository() {
        return this.m_repository;
    }

    private String getResourceDir(ResourceIdentifier resource) throws FileNotFoundException {
        return this.m_repository.getRrdBaseDir().toPath().resolve(ResourcePath.resourceToFilesystemPath((ResourcePath)resource.getPath())).toAbsolutePath().toString();
    }

    public void declareAttribute(CollectionAttributeType attrType) {
        this.m_declarations.put(attrType, Double.NaN);
    }

    public void setAttributeValue(CollectionAttributeType attrType, Number value) {
        this.m_declarations.put(attrType, value);
    }

    public void setAttributeMetadata(String metricIdentifier, String name) {
        if (metricIdentifier == null) {
            if (name == null) {
                LOG.warn("Cannot set attribute metadata with null key and null value");
            } else {
                LOG.warn("Cannot set attribute metadata with null key and value of: {}", (Object)name);
            }
        } else {
            this.m_metaData.put(metricIdentifier, name);
        }
    }

    public static RrdAttributeType mapType(AttributeType type) {
        if (AttributeType.COUNTER.equals((Object)type)) {
            return RrdAttributeType.COUNTER;
        }
        if (AttributeType.STRING.equals((Object)type)) {
            return null;
        }
        return RrdAttributeType.GAUGE;
    }

    public static String mapValue(Number num) {
        return RrdPersistOperationBuilder.mapValue(num, AttributeType.GAUGE);
    }

    public static String mapValue(Number num, AttributeType type) {
        if (num == null) {
            return "U";
        }
        if (!Double.isFinite(num.doubleValue())) {
            return "U";
        }
        NumberFormat nf = NumberFormat.getInstance(Locale.US);
        nf.setGroupingUsed(false);
        nf.setMinimumFractionDigits(0);
        nf.setMaximumFractionDigits(Integer.MAX_VALUE);
        if (AttributeType.COUNTER.equals((Object)type)) {
            nf.setMaximumFractionDigits(0);
        } else {
            nf.setMaximumFractionDigits(Integer.MAX_VALUE);
        }
        nf.setMinimumIntegerDigits(0);
        nf.setMaximumIntegerDigits(Integer.MAX_VALUE);
        return nf.format(num);
    }

    public void commit() throws PersistException {
        if (this.m_declarations.size() == 0) {
            return;
        }
        try {
            String ownerName = this.m_resource.getOwnerName();
            String absolutePath = this.getResourceDir(this.m_resource);
            RrdMetaDataUtils.createMetaDataFile((String)absolutePath, (String)this.m_rrdName, this.m_metaData);
            List<RrdDataSource> dataSources = this.getDataSources();
            if (dataSources != null && dataSources.size() > 0) {
                RrdPersistOperationBuilder.createRRD(this.m_rrdStrategy, ownerName, absolutePath, this.m_rrdName, this.getRepository().getStep(), dataSources, this.getRepository().getRraList());
                RrdPersistOperationBuilder.updateRRD(this.m_rrdStrategy, ownerName, absolutePath, this.m_rrdName, this.m_timeKeeper.getCurrentTime(), this.getValues());
            }
        }
        catch (FileNotFoundException e) {
            LoggerFactory.getLogger(this.getClass()).warn("Could not get resource directory: " + e.getMessage(), (Throwable)e);
            return;
        }
        catch (RrdException e) {
            throw new PersistException((Throwable)e);
        }
    }

    private String getValues() {
        boolean first = true;
        StringBuilder values = new StringBuilder();
        for (CollectionAttributeType attrDef : this.m_declarations.keySet()) {
            Number value = this.m_declarations.get(attrDef);
            if (!first) {
                values.append(':');
            } else {
                first = false;
            }
            values.append(RrdPersistOperationBuilder.mapValue(value, attrDef.getType()));
        }
        return values.toString();
    }

    private List<RrdDataSource> getDataSources() {
        ArrayList<RrdDataSource> dataSources = new ArrayList<RrdDataSource>(this.m_declarations.size());
        for (CollectionAttributeType attrDef : this.m_declarations.keySet()) {
            RrdAttributeType type;
            String minval = "U";
            String maxval = "U";
            if (attrDef instanceof NumericCollectionAttributeType) {
                minval = ((NumericCollectionAttributeType)attrDef).getMinval() != null ? ((NumericCollectionAttributeType)attrDef).getMinval() : "U";
                String string = maxval = ((NumericCollectionAttributeType)attrDef).getMaxval() != null ? ((NumericCollectionAttributeType)attrDef).getMaxval() : "U";
            }
            if ((type = RrdPersistOperationBuilder.mapType(attrDef.getType())) == null) continue;
            if (attrDef.getName().length() > 19) {
                LOG.warn("Mib object name/alias '{}' exceeds 19 char maximum for RRD data source names, truncating.", (Object)attrDef.getName());
            }
            RrdDataSource rrdDataSource = new RrdDataSource(StringUtils.truncate((String)attrDef.getName(), (int)19), type, this.getRepository().getHeartBeat(), minval, maxval);
            dataSources.add(rrdDataSource);
        }
        return dataSources;
    }

    private static boolean createRRD(RrdStrategy<?, ?> rrdStrategy, String creator, String directory, String rrdName, int step, List<RrdDataSource> dataSources, List<String> rraList) throws RrdException {
        Object def = null;
        try {
            RrdStrategy<Object, Object> strategy = RrdPersistOperationBuilder.toGenericType(rrdStrategy);
            def = strategy.createDefinition(creator, directory, rrdName, step, dataSources, rraList);
            strategy.createFile(def);
            return true;
        }
        catch (Throwable e) {
            String path = directory + File.separator + rrdName + rrdStrategy.getDefaultFileExtension();
            LOG.error("createRRD: An error occurred creating rrdfile {}", (Object)path, (Object)e);
            throw new RrdException("An error occurred creating rrdfile " + path + ": " + e, e);
        }
    }

    private static void updateRRD(RrdStrategy<?, ?> rrdStrategy, String owner, String repositoryDir, String rrdName, long timestamp, String val) throws RrdException {
        String rrdFile = repositoryDir + File.separator + rrdName + rrdStrategy.getDefaultFileExtension();
        long time = (timestamp + 500L) / 1000L;
        String updateVal = Long.toString(time) + ":" + val;
        LOG.info("updateRRD: updating RRD file {} with values '{}'", (Object)rrdFile, (Object)updateVal);
        RrdStrategy<Object, Object> strategy = RrdPersistOperationBuilder.toGenericType(rrdStrategy);
        Object rrd = null;
        try {
            rrd = strategy.openFile(rrdFile);
            strategy.updateFile(rrd, owner, updateVal);
        }
        catch (Throwable e) {
            LOG.error("updateRRD: Error updating RRD file {} with values '{}'", new Object[]{rrdFile, updateVal, e});
            throw new RrdException("Error updating RRD file " + rrdFile + " with values '" + updateVal + "': " + e, e);
        }
        finally {
            try {
                if (rrd != null) {
                    strategy.closeFile(rrd);
                }
            }
            catch (Throwable e) {
                LOG.error("updateRRD: Exception closing RRD file {}", (Object)rrdFile, (Object)e);
                throw new RrdException("Exception closing RRD file " + rrdFile + ": " + e, e);
            }
        }
        LOG.debug("updateRRD: RRD update command completed.");
    }

    private static RrdStrategy<Object, Object> toGenericType(RrdStrategy<?, ?> rrdStrategy) {
        Assert.notNull(rrdStrategy);
        return rrdStrategy;
    }

    public String getName() {
        return this.m_rrdName;
    }

    public TimeKeeper getTimeKeeper() {
        return this.m_timeKeeper;
    }

    public void setTimeKeeper(TimeKeeper timeKeeper) {
        this.m_timeKeeper = timeKeeper;
    }
}

