/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.mapper.v2;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.mapstruct.AfterMapping;
import org.mapstruct.InheritInverseConfiguration;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.opennms.netmgt.config.api.EventConfDao;
import org.opennms.netmgt.model.AckType;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsEventParameter;
import org.opennms.netmgt.model.TroubleTicketState;
import org.opennms.web.rest.mapper.v2.EventMapper;
import org.opennms.web.rest.model.v2.AlarmDTO;
import org.opennms.web.rest.model.v2.AlarmSummaryDTO;
import org.opennms.web.rest.model.v2.EventParameterDTO;
import org.springframework.beans.factory.annotation.Autowired;

@Mapper(componentModel="spring", uses={EventMapper.class})
public abstract class AlarmMapper {
    private String ticketUrlTemplate = System.getProperty("opennms.alarmTroubleTicketLinkTemplate");
    @Autowired
    private EventConfDao eventConfDao;

    @Mappings(value={@Mapping(source="distPoller.location", target="location"), @Mapping(source="ipAddr", target="ipAddress"), @Mapping(source="alarmType", target="type"), @Mapping(ignore=true, target="relatedAlarms"), @Mapping(source="counter", target="count"), @Mapping(source="severityLabel", target="severity"), @Mapping(source="logMsg", target="logMessage"), @Mapping(source="operInstruct", target="operatorInstructions"), @Mapping(source="TTicketId", target="troubleTicket"), @Mapping(source="TTicketState", target="troubleTicketState"), @Mapping(source="alarmAckUser", target="ackUser"), @Mapping(source="alarmAckTime", target="ackTime"), @Mapping(source="suppressedUser", target="suppressedBy")})
    public abstract AlarmDTO alarmToAlarmDTO(OnmsAlarm var1);

    @InheritInverseConfiguration
    public abstract OnmsAlarm alarmDTOToAlarm(AlarmDTO var1);

    public Integer ackTypeToInteger(AckType ack) {
        return ack.getId();
    }

    @AfterMapping
    protected void fillAlarm(OnmsAlarm alarm, @MappingTarget AlarmDTO alarmDTO) {
        List eventParms = alarm.getEventParameters();
        if (eventParms != null) {
            alarmDTO.setParameters(eventParms.stream().map(this::eventParameterToEventParameterDTO).collect(Collectors.toList()));
        }
        if (alarm.getTTicketId() != null && !alarm.getTTicketId().isEmpty() && this.ticketUrlTemplate != null) {
            alarmDTO.setTroubleTicketLink(this.getTicketUrl(alarm.getTTicketId()));
        }
        if (alarm.isSituation()) {
            alarmDTO.setRelatedAlarms(alarm.getRelatedAlarms().stream().map(this::alarmToAlarmSummaryDTO).sorted(Comparator.comparing(AlarmSummaryDTO::getId)).collect(Collectors.toList()));
        }
    }

    protected Integer mapTicketStateToInt(TroubleTicketState state) {
        if (state == null) {
            return null;
        }
        return state.getValue();
    }

    protected TroubleTicketState mapIntToTicketState(Integer value) {
        return Arrays.stream(TroubleTicketState.values()).filter(s -> Objects.equals(value, s.getValue())).findFirst().orElse(null);
    }

    public abstract EventParameterDTO eventParameterToEventParameterDTO(OnmsEventParameter var1);

    @Mappings(value={@Mapping(source="id", target="id"), @Mapping(source="type", target="type"), @Mapping(source="severity", target="severity"), @Mapping(source="reductionKey", target="reductionKey"), @Mapping(source="description", target="description"), @Mapping(source="lastEvent.eventUei", target="uei"), @Mapping(source="nodeLabel", target="nodeLabel"), @Mapping(source="logMsg", target="logMessage")})
    public abstract AlarmSummaryDTO alarmToAlarmSummaryDTO(OnmsAlarm var1);

    public void setTicketUrlTemplate(String ticketUrlTemplate) {
        this.ticketUrlTemplate = ticketUrlTemplate;
    }

    private String getTicketUrl(String ticketId) {
        Objects.requireNonNull(this.ticketUrlTemplate);
        Objects.requireNonNull(ticketId);
        return this.ticketUrlTemplate.replaceAll("\\$\\{id\\}", ticketId);
    }

    @AfterMapping
    protected void mapEventLabel(@MappingTarget AlarmSummaryDTO summaryDTO) {
        summaryDTO.setLabel(this.eventConfDao.getEventLabel(summaryDTO.getUei()));
    }

    public void setEventConfDao(EventConfDao eventConfDao) {
        this.eventConfDao = eventConfDao;
    }
}

