/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote.support;

import java.util.LinkedHashMap;
import java.util.Map;
import org.opennms.netmgt.collection.api.AttributeGroup;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.api.TimeKeeper;
import org.opennms.netmgt.model.ResourcePath;

public class DistributedLatencyCollectionResource
implements CollectionResource {
    private final String m_locationMonitorId;
    private final String m_ipAddress;
    private final Map<AttributeGroupType, AttributeGroup> m_attributeGroups = new LinkedHashMap<AttributeGroupType, AttributeGroup>();

    public DistributedLatencyCollectionResource(String locationMonitorId, String ipAddress) {
        this.m_locationMonitorId = locationMonitorId;
        this.m_ipAddress = ipAddress;
    }

    public String getInstance() {
        return String.format("%s[%s]", this.m_locationMonitorId, this.m_ipAddress);
    }

    public String getInterfaceLabel() {
        return this.m_locationMonitorId;
    }

    public String getResourceTypeName() {
        return "if";
    }

    public boolean rescanNeeded() {
        return false;
    }

    public boolean shouldPersist(ServiceParameters params) {
        return true;
    }

    public void addAttribute(CollectionAttribute attr) {
        AttributeGroup group = this.getGroup(attr.getAttributeType().getGroupType());
        group.addAttribute(attr);
    }

    public final AttributeGroup getGroup(AttributeGroupType groupType) {
        AttributeGroup group = this.m_attributeGroups.get(groupType);
        if (group == null) {
            group = new AttributeGroup((CollectionResource)this, groupType);
            this.m_attributeGroups.put(groupType, group);
        }
        return group;
    }

    public void visit(CollectionSetVisitor visitor) {
        visitor.visitResource((CollectionResource)this);
        for (AttributeGroup group : this.m_attributeGroups.values()) {
            group.visit(visitor);
        }
        visitor.completeResource((CollectionResource)this);
    }

    public String getOwnerName() {
        return this.m_locationMonitorId;
    }

    public ResourcePath getPath() {
        return ResourcePath.get((String[])new String[]{"distributed", this.m_locationMonitorId, this.m_ipAddress});
    }

    public String toString() {
        return String.format("%s[%s]", this.m_locationMonitorId, this.m_ipAddress);
    }

    public ResourcePath getParent() {
        return ResourcePath.get((String[])new String[]{this.m_ipAddress});
    }

    public TimeKeeper getTimeKeeper() {
        return null;
    }

    public String getLocationMonitorId() {
        return this.m_locationMonitorId;
    }

    public String getIpAddress() {
        return this.m_ipAddress;
    }
}

