/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote;

import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.model.ScanReport;
import org.opennms.netmgt.model.ScanReportLog;
import org.opennms.netmgt.model.ScanReportPollResult;
import org.opennms.netmgt.poller.PollStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanReportTest {
    private static final Logger LOG = LoggerFactory.getLogger(ScanReportTest.class);

    @Test
    public void testSerialization() throws Exception {
        ScanReport report = new ScanReport();
        report.addProperty("customer-account-number", "12345");
        report.addProperty("customer-name", "Zombo.com");
        report.addProperty("reference-id", "ABZ135");
        report.addProperty("time-zone", "-5:00");
        report.setLocale("en-US");
        report.setLocation("RDU");
        report.setTimestamp(new Date());
        report.setLog(new ScanReportLog(report.getId(), "Hey, a log!"));
        for (int i = 0; i < 5; ++i) {
            PollStatus status = PollStatus.get((int)1, (String)"Anything is possible", (Double)4.5);
            status.setProperty("whatever", (Number)2.0);
            report.addPollResult(new ScanReportPollResult("Foo", Integer.valueOf(1), "zombonode", Integer.valueOf(1), "1.2.3.4", status));
        }
        String reportString = JaxbUtils.marshal((Object)report);
        LOG.debug("Report string: \n " + reportString);
        Assert.assertTrue((boolean)reportString.contains("<key>customer-account-number</key>"));
        Assert.assertTrue((boolean)reportString.contains("<value>12345</value>"));
        Assert.assertTrue((boolean)reportString.contains("<key>customer-name</key>"));
        Assert.assertTrue((boolean)reportString.contains("<value>Zombo.com</value>"));
        Assert.assertTrue((boolean)reportString.contains("response-time=\"4.5\""));
        Assert.assertFalse((boolean)reportString.contains("a log!"));
    }
}

