/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.easymock.IArgumentMatcher;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.collection.api.PersisterFactory;
import org.opennms.netmgt.collection.api.TimeKeeper;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.monitoringLocations.LocationDef;
import org.opennms.netmgt.config.poller.Filter;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.Parameter;
import org.opennms.netmgt.config.poller.Rrd;
import org.opennms.netmgt.config.poller.Service;
import org.opennms.netmgt.dao.api.LocationMonitorDao;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.dao.api.MonitoringLocationDao;
import org.opennms.netmgt.dao.api.ScanReportDao;
import org.opennms.netmgt.dao.mock.MockEventIpcManager;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.mock.MockPersisterFactory;
import org.opennms.netmgt.model.NetworkBuilder;
import org.opennms.netmgt.model.OnmsApplication;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsLocationMonitor;
import org.opennms.netmgt.model.OnmsLocationSpecificStatus;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.ScanReport;
import org.opennms.netmgt.model.ScanReportPollResult;
import org.opennms.netmgt.model.ServiceSelector;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventUtils;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.remote.PolledService;
import org.opennms.netmgt.poller.remote.PollerConfiguration;
import org.opennms.netmgt.poller.remote.support.DefaultPollerBackEnd;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.test.mock.EasyMockUtils;

public class PollerBackEndTest
extends TestCase {
    private static final String LOCATION_MONITOR_ID = UUID.randomUUID().toString();
    private static final String APPLICATION_NAME = "AwesomeApp";
    private EasyMockUtils m_mocks = new EasyMockUtils();
    static final int DISCONNECTED_TIMEOUT = 300000;
    private DefaultPollerBackEnd m_backEnd = new DefaultPollerBackEnd();
    private MonitoringLocationDao m_monitoringLocationDao;
    private LocationMonitorDao m_locMonDao;
    private ScanReportDao m_scanReportDao;
    private MonitoredServiceDao m_monSvcDao;
    private PollerConfig m_pollerConfig;
    private TimeKeeper m_timeKeeper;
    private MockEventIpcManager m_eventIpcManager;
    private LocationDef m_locationDefinition;
    private Package m_package;
    private ServiceSelector m_serviceSelector;
    private OnmsLocationMonitor m_locationMonitor;
    private Service m_httpSvcConfig;
    private Service m_dnsSvcConfig;
    private OnmsMonitoredService m_httpService;
    private OnmsMonitoredService m_dnsService;
    private OnmsMonitoredService[] m_monServices;
    private OnmsLocationSpecificStatus m_httpCurrentStatus;
    private OnmsLocationSpecificStatus m_dnsCurrentStatus;
    private Date m_startTime;
    private HashMap<String, String> m_pollerDetails;

    protected void runTest() throws Throwable {
        super.runTest();
        this.m_mocks.verifyAll();
    }

    private void addParameter(Service service, String key, String value) {
        Parameter param = new Parameter();
        param.setKey(key);
        param.setValue(value);
        service.addParameter(param);
    }

    private Service addService(Package pkg, String serviceName, int serviceInterval, String ... parms) {
        PollerBackEndTest.assertTrue((parms.length % 2 == 0 ? 1 : 0) != 0);
        Service service = new Service();
        service.setName(serviceName);
        service.setInterval(Long.valueOf(serviceInterval));
        for (int i = 0; i < parms.length - 1; i += 2) {
            String key = parms[i];
            String value = parms[i + 1];
            this.addParameter(service, key, value);
        }
        pkg.addService(service);
        return service;
    }

    private void anticipateDisconnectedEvent() {
        this.anticipateEvent(PollerBackEndTest.createDisconnectedEvent());
    }

    private void anticipateEvent(Event e) {
        this.m_eventIpcManager.getEventAnticipator().anticipateEvent(e);
    }

    private void anticipateMonitorStarted() {
        this.anticipateEvent(PollerBackEndTest.createMonitorStartedEvent());
    }

    private void anticipateMonitorRegisteredEvent() {
        this.anticipateEvent(PollerBackEndTest.createMonitorRegisteredEvent());
    }

    private void anticipateMonitorStoppedEvent() {
        this.anticipateEvent(PollerBackEndTest.createMonitorStoppedEvent());
    }

    private static Event createDisconnectedEvent() {
        EventBuilder eventBuilder = new EventBuilder("uei.opennms.org/remote/locationMonitorDisconnected", "PollerBackEnd").addParam("locationMonitorId", LOCATION_MONITOR_ID);
        Event e = eventBuilder.getEvent();
        return e;
    }

    private static Event createMonitorRegisteredEvent() {
        EventBuilder eventBuilder = new EventBuilder("uei.opennms.org/remote/locationMonitorRegistered", "PollerBackEnd").addParam("locationMonitorId", LOCATION_MONITOR_ID);
        Event e = eventBuilder.getEvent();
        return e;
    }

    private static Event createMonitorStartedEvent() {
        EventBuilder eventBuilder = new EventBuilder("uei.opennms.org/remote/locationMonitorStarted", "PollerBackEnd").addParam("locationMonitorId", LOCATION_MONITOR_ID);
        Event e = eventBuilder.getEvent();
        return e;
    }

    private static Event createMonitorStoppedEvent() {
        EventBuilder eventBuilder = new EventBuilder("uei.opennms.org/remote/locationMonitorStopped", "PollerBackEnd").addParam("locationMonitorId", LOCATION_MONITOR_ID);
        return eventBuilder.getEvent();
    }

    private static Package createPackage(String pkgName, String filterRule) {
        Package pkg = new Package();
        pkg.setName(pkgName);
        pkg.setFilter(new Filter());
        pkg.getFilter().setContent(filterRule);
        return pkg;
    }

    private static Event createReconnectedEvent() {
        EventBuilder eventBuilder = new EventBuilder("uei.opennms.org/remote/locationMonitorReconnected", "PollerBackEnd");
        eventBuilder.addParam("locationMonitorId", LOCATION_MONITOR_ID);
        return eventBuilder.getEvent();
    }

    private static Event eq(Event e) {
        EasyMock.reportMatcher((IArgumentMatcher)new EventEquals(e));
        return null;
    }

    private void expectLocationMonitorStarted() {
        final Date now = new Date();
        EasyMock.expect((Object)this.m_timeKeeper.getCurrentDate()).andReturn((Object)now);
        EasyMock.expect((Object)this.m_locMonDao.get((Serializable)((Object)this.m_locationMonitor.getId()))).andReturn((Object)this.m_locationMonitor);
        this.m_locMonDao.update((Object)this.m_locationMonitor);
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<Object>(){

            public Object answer() throws Throwable {
                OnmsLocationMonitor mon = (OnmsLocationMonitor)EasyMock.getCurrentArguments()[0];
                TestCase.assertEquals((Object)OnmsLocationMonitor.MonitorStatus.STARTED, (Object)mon.getStatus());
                TestCase.assertEquals((Object)now, (Object)mon.getLastUpdated());
                TestCase.assertEquals((Object)PollerBackEndTest.this.m_pollerDetails, (Object)mon.getProperties());
                return null;
            }
        });
    }

    private void expectLocationMonitorStatusChanged(OnmsLocationMonitor.MonitorStatus oldStatus, final OnmsLocationMonitor.MonitorStatus expectedStatus) {
        final Date now = new Date();
        if (oldStatus != null) {
            switch (oldStatus) {
                case DISCONNECTED: 
                case STARTED: {
                    EasyMock.expect((Object)this.m_timeKeeper.getCurrentTime()).andReturn((Object)now.getTime()).anyTimes();
                }
            }
        }
        EasyMock.expect((Object)this.m_timeKeeper.getCurrentDate()).andReturn((Object)now).anyTimes();
        EasyMock.expect((Object)this.m_locMonDao.get((Serializable)((Object)this.m_locationMonitor.getId()))).andReturn((Object)this.m_locationMonitor);
        this.m_locMonDao.update((Object)this.m_locationMonitor);
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<Object>(){

            public Object answer() throws Throwable {
                OnmsLocationMonitor mon = (OnmsLocationMonitor)EasyMock.getCurrentArguments()[0];
                TestCase.assertEquals((String)"unexpected new monitor state", (Object)expectedStatus, (Object)mon.getStatus());
                TestCase.assertEquals((Object)now, (Object)mon.getLastUpdated());
                return null;
            }
        });
    }

    protected void setUp() throws Exception {
        System.setProperty("opennms.home", "src/test/test-configurations/PollerBackEndTest-home");
        this.m_monitoringLocationDao = (MonitoringLocationDao)this.m_mocks.createMock(MonitoringLocationDao.class);
        this.m_locMonDao = (LocationMonitorDao)this.m_mocks.createMock(LocationMonitorDao.class);
        this.m_scanReportDao = (ScanReportDao)this.m_mocks.createMock(ScanReportDao.class);
        this.m_monSvcDao = (MonitoredServiceDao)this.m_mocks.createMock(MonitoredServiceDao.class);
        this.m_pollerConfig = (PollerConfig)this.m_mocks.createMock(PollerConfig.class);
        this.m_timeKeeper = (TimeKeeper)this.m_mocks.createMock(TimeKeeper.class);
        this.m_eventIpcManager = new MockEventIpcManager();
        this.m_backEnd = new DefaultPollerBackEnd();
        this.m_backEnd.setMonitoringLocationDao(this.m_monitoringLocationDao);
        this.m_backEnd.setLocationMonitorDao(this.m_locMonDao);
        this.m_backEnd.setScanReportDao(this.m_scanReportDao);
        this.m_backEnd.setMonitoredServiceDao(this.m_monSvcDao);
        this.m_backEnd.setPollerConfig(this.m_pollerConfig);
        this.m_backEnd.setTimeKeeper(this.m_timeKeeper);
        this.m_backEnd.setEventIpcManager((EventIpcManager)this.m_eventIpcManager);
        this.m_backEnd.setDisconnectedTimeout(300000);
        this.m_backEnd.setPersisterFactory((PersisterFactory)new MockPersisterFactory());
        this.m_startTime = new Date(System.currentTimeMillis() - 600000L);
        EasyMock.expect((Object)this.m_timeKeeper.getCurrentDate()).andReturn((Object)this.m_startTime);
        EasyMock.replay((Object[])new Object[]{this.m_timeKeeper});
        this.m_backEnd.afterPropertiesSet();
        EasyMock.verify((Object[])new Object[]{this.m_timeKeeper});
        EasyMock.reset((Object[])new Object[]{this.m_timeKeeper});
        this.m_locationDefinition = new LocationDef();
        this.m_locationDefinition.setMonitoringArea("Oakland");
        this.m_locationDefinition.setLocationName("OAK");
        this.m_locationDefinition.setPollingPackageNames(Collections.singletonList("OAKPackage"));
        this.m_package = PollerBackEndTest.createPackage("OAKPackage", "ipaddr = '192.168.1.1'");
        this.m_serviceSelector = new ServiceSelector(this.m_package.getFilter().getContent(), Arrays.asList("HTTP", "DNS"));
        this.m_httpSvcConfig = this.addService(this.m_package, "HTTP", 1234, "url", "http://www.opennms.org");
        this.m_dnsSvcConfig = this.addService(this.m_package, "DNS", 5678, "hostname", "www.opennms.org");
        this.m_locationMonitor = new OnmsLocationMonitor();
        this.m_locationMonitor.setId(LOCATION_MONITOR_ID);
        this.m_locationMonitor.setLocation(this.m_locationDefinition.getLocationName());
        OnmsApplication application = new OnmsApplication();
        application.setName(APPLICATION_NAME);
        NetworkBuilder builder = new NetworkBuilder();
        builder.addNode("testNode").setId(Integer.valueOf(1));
        builder.addInterface("192.168.1.1").setId(1);
        this.m_httpService = builder.addService(new OnmsServiceType("HTTP"));
        this.m_httpService.setId(Integer.valueOf(1));
        this.m_httpService.setApplications(Collections.singleton(application));
        this.m_dnsService = builder.addService(new OnmsServiceType("DNS"));
        this.m_dnsService.setId(Integer.valueOf(2));
        this.m_dnsService.setApplications(Collections.singleton(application));
        this.m_monServices = new OnmsMonitoredService[]{this.m_httpService, this.m_dnsService};
        long now = System.currentTimeMillis();
        PollStatus httpResult = PollStatus.available((Double)1000.0);
        httpResult.setTimestamp(new Date(now - 300000L));
        this.m_httpCurrentStatus = new OnmsLocationSpecificStatus(this.m_locationMonitor, this.m_httpService, httpResult);
        this.m_httpCurrentStatus.setId(Integer.valueOf(1));
        PollStatus dnsResult = PollStatus.unavailable((String)"Non responsive");
        dnsResult.setTimestamp(new Date(now - 300000L));
        this.m_dnsCurrentStatus = new OnmsLocationSpecificStatus(this.m_locationMonitor, this.m_dnsService, dnsResult);
        this.m_dnsCurrentStatus.setId(Integer.valueOf(2));
        this.m_pollerDetails = new HashMap();
        this.m_pollerDetails.put("os.name", "WonkaOS");
        this.m_pollerDetails.put("os.version", "1.2.3");
    }

    public void testGetMonitoringLocations() {
        List<LocationDef> locations = Collections.singletonList(this.m_locationDefinition);
        EasyMock.expect((Object)this.m_monitoringLocationDao.findAll()).andReturn(locations);
        this.m_mocks.replayAll();
        Collection returned = this.m_backEnd.getMonitoringLocations();
        PollerBackEndTest.assertEquals(locations, (Object)returned);
    }

    public void testGetPollerConfiguration() {
        EasyMock.expect((Object)this.m_locMonDao.get((Serializable)((Object)this.m_locationMonitor.getId()))).andReturn((Object)this.m_locationMonitor);
        EasyMock.expect((Object)this.m_monitoringLocationDao.get((Serializable)((Object)this.m_locationDefinition.getLocationName()))).andReturn((Object)this.m_locationDefinition);
        EasyMock.expect((Object)this.m_pollerConfig.getPackage(this.m_package.getName())).andReturn((Object)this.m_package);
        EasyMock.expect((Object)this.m_pollerConfig.getServiceSelectorForPackage(this.m_package)).andReturn((Object)this.m_serviceSelector);
        EasyMock.expect((Object)this.m_pollerConfig.getServiceInPackage("HTTP", this.m_package)).andReturn((Object)this.m_httpSvcConfig);
        EasyMock.expect((Object)this.m_pollerConfig.getServiceInPackage("DNS", this.m_package)).andReturn((Object)this.m_dnsSvcConfig);
        EasyMock.expect((Object)this.m_monSvcDao.findMatchingServices(this.m_serviceSelector)).andReturn(Arrays.asList(this.m_monServices));
        this.m_mocks.replayAll();
        PollerConfiguration config = this.m_backEnd.getPollerConfiguration(this.m_locationMonitor.getId());
        PollerBackEndTest.assertNotNull((Object)config);
        PollerBackEndTest.assertEquals((Object)this.m_startTime, (Object)config.getConfigurationTimestamp());
        PollerBackEndTest.assertNotNull((Object)config.getPolledServices());
        PollerBackEndTest.assertEquals((int)2, (int)config.getPolledServices().length);
        TreeMap<String, PolledService> services = new TreeMap<String, PolledService>();
        for (PolledService ps : config.getPolledServices()) {
            services.put(ps.getSvcName(), ps);
        }
        PollerBackEndTest.assertTrue((boolean)services.keySet().contains(this.m_dnsService.getServiceName()));
        PollerBackEndTest.assertTrue((boolean)services.keySet().contains(this.m_httpService.getServiceName()));
        PollerBackEndTest.assertEquals((long)5678L, (long)((PolledService)services.get("DNS")).getPollModel().getPollInterval());
        PollerBackEndTest.assertTrue((boolean)((PolledService)services.get("DNS")).getMonitorConfiguration().containsKey("hostname"));
    }

    public void testGetPollerConfigurationForDeletedMonitor() {
        EasyMock.expect((Object)this.m_locMonDao.get((Serializable)((Object)this.m_locationMonitor.getId()))).andReturn(null);
        this.m_mocks.replayAll();
        PollerConfiguration config = this.m_backEnd.getPollerConfiguration(this.m_locationMonitor.getId());
        PollerBackEndTest.assertNotNull((Object)config);
        PollerBackEndTest.assertTrue((boolean)this.m_startTime.after(config.getConfigurationTimestamp()));
        PollerBackEndTest.assertNotNull((Object)config.getPolledServices());
        PollerBackEndTest.assertEquals((int)0, (int)config.getPolledServices().length);
    }

    public void testGetServiceMonitorLocators() {
        ArrayList locators = new ArrayList();
        EasyMock.expect((Object)this.m_pollerConfig.getServiceMonitorLocators(DistributionContext.REMOTE_MONITOR)).andReturn(locators);
        this.m_mocks.replayAll();
        Collection results = this.m_backEnd.getServiceMonitorLocators(DistributionContext.REMOTE_MONITOR);
        PollerBackEndTest.assertEquals((int)0, (int)results.size());
    }

    public void testPollerCheckingInFromDisconnected() {
        this.verifyPollerCheckingIn(OnmsLocationMonitor.MonitorStatus.DISCONNECTED, OnmsLocationMonitor.MonitorStatus.STARTED, OnmsLocationMonitor.MonitorStatus.STARTED, PollerBackEndTest.createReconnectedEvent());
    }

    public void testPollerCheckingInFromPaused() {
        this.verifyPollerCheckingIn(OnmsLocationMonitor.MonitorStatus.PAUSED, OnmsLocationMonitor.MonitorStatus.PAUSED, OnmsLocationMonitor.MonitorStatus.PAUSED);
    }

    public void testPollerCheckingInFromStarted() {
        this.verifyPollerCheckingIn(OnmsLocationMonitor.MonitorStatus.STARTED, OnmsLocationMonitor.MonitorStatus.STARTED, OnmsLocationMonitor.MonitorStatus.STARTED);
    }

    public void testPollerCheckingInFromConfigChanged() {
        this.verifyPollerCheckingIn(OnmsLocationMonitor.MonitorStatus.CONFIG_CHANGED, OnmsLocationMonitor.MonitorStatus.STARTED, OnmsLocationMonitor.MonitorStatus.CONFIG_CHANGED);
    }

    public void testPollerStarting() {
        this.anticipateMonitorStarted();
        this.expectLocationMonitorStarted();
        this.m_mocks.replayAll();
        this.m_backEnd.pollerStarting(LOCATION_MONITOR_ID, this.m_pollerDetails);
    }

    public void testPollerStopping() {
        this.anticipateMonitorStoppedEvent();
        this.expectLocationMonitorStatusChanged(null, OnmsLocationMonitor.MonitorStatus.STOPPED);
        this.m_mocks.replayAll();
        this.m_backEnd.pollerStopping(LOCATION_MONITOR_ID);
    }

    public void testPollerStoppingWithBadLocationMonitorId() {
        EasyMock.expect((Object)this.m_locMonDao.get((Serializable)((Object)LOCATION_MONITOR_ID))).andReturn(null);
        this.m_mocks.replayAll();
        this.m_backEnd.pollerStopping(LOCATION_MONITOR_ID);
    }

    public void testRegisterLocationMonitor() {
        EasyMock.expect((Object)this.m_monitoringLocationDao.get((Serializable)((Object)this.m_locationDefinition.getLocationName()))).andReturn((Object)this.m_locationDefinition);
        this.m_locMonDao.save(EasyMock.isA(OnmsLocationMonitor.class));
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<Object>(){

            public Object answer() throws Throwable {
                OnmsLocationMonitor mon = (OnmsLocationMonitor)EasyMock.getCurrentArguments()[0];
                mon.setId(LOCATION_MONITOR_ID);
                TestCase.assertEquals((Object)OnmsLocationMonitor.MonitorStatus.REGISTERED, (Object)mon.getStatus());
                return null;
            }
        });
        this.anticipateMonitorRegisteredEvent();
        this.m_mocks.replayAll();
        String locationMonitorId = this.m_backEnd.registerLocationMonitor(this.m_locationDefinition.getLocationName());
        PollerBackEndTest.assertEquals((String)LOCATION_MONITOR_ID, (String)locationMonitorId);
    }

    public void testReportResultWithBadLocationMonitorId() {
        EasyMock.expect((Object)this.m_locMonDao.get((Serializable)((Object)LOCATION_MONITOR_ID))).andReturn(null);
        this.m_mocks.replayAll();
        this.m_backEnd.reportResult(LOCATION_MONITOR_ID, 1, PollStatus.up());
    }

    public void testReportResultWithBadServiceId() {
        EasyMock.expect((Object)this.m_locMonDao.get((Serializable)((Object)LOCATION_MONITOR_ID))).andReturn((Object)new OnmsLocationMonitor());
        EasyMock.expect((Object)this.m_monSvcDao.get((Serializable)Integer.valueOf(1))).andReturn(null);
        this.m_mocks.replayAll();
        this.m_backEnd.reportResult(LOCATION_MONITOR_ID, 1, PollStatus.up());
    }

    public void testReportResultWithNullPollResult() {
        EasyMock.expect((Object)this.m_locMonDao.get((Serializable)((Object)LOCATION_MONITOR_ID))).andThrow((Throwable)new RuntimeException("crazy location monitor exception"));
        this.m_mocks.replayAll();
        this.m_backEnd.reportResult(LOCATION_MONITOR_ID, 1, null);
    }

    public void testGetApplicationsForLocation() {
        EasyMock.expect((Object)this.m_monitoringLocationDao.get((Serializable)((Object)this.m_locationDefinition.getLocationName()))).andReturn((Object)this.m_locationDefinition);
        EasyMock.expect((Object)this.m_pollerConfig.getPackage(this.m_package.getName())).andReturn((Object)this.m_package);
        EasyMock.expect((Object)this.m_pollerConfig.getServiceSelectorForPackage(this.m_package)).andReturn((Object)this.m_serviceSelector);
        EasyMock.expect((Object)this.m_monSvcDao.findMatchingServices(this.m_serviceSelector)).andReturn(Arrays.asList(this.m_monServices));
        EasyMock.expect((Object)this.m_pollerConfig.getServiceInPackage("HTTP", this.m_package)).andReturn((Object)this.m_httpSvcConfig).anyTimes();
        EasyMock.expect((Object)this.m_pollerConfig.getServiceInPackage("DNS", this.m_package)).andReturn((Object)this.m_dnsSvcConfig).anyTimes();
        this.m_mocks.replayAll();
        Set apps = this.m_backEnd.getApplicationsForLocation(this.m_locationDefinition.getLocationName());
        PollerBackEndTest.assertEquals(Collections.singleton(APPLICATION_NAME), (Object)apps);
    }

    public void testStatusChangeFromDownToUp() {
        EasyMock.expect((Object)this.m_locMonDao.get((Serializable)((Object)LOCATION_MONITOR_ID))).andReturn((Object)this.m_locationMonitor);
        EasyMock.expect((Object)this.m_monSvcDao.get((Serializable)Integer.valueOf(2))).andReturn((Object)this.m_dnsService);
        EasyMock.expect((Object)this.m_locMonDao.getMostRecentStatusChange(this.m_locationMonitor, this.m_dnsService)).andReturn((Object)this.m_dnsCurrentStatus);
        EasyMock.expect((Object)this.m_monitoringLocationDao.get((Serializable)((Object)this.m_locationDefinition.getLocationName()))).andReturn((Object)this.m_locationDefinition);
        EasyMock.expect((Object)this.m_pollerConfig.getPackage(this.m_package.getName())).andReturn((Object)this.m_package);
        EasyMock.expect((Object)this.m_pollerConfig.getServiceInPackage("DNS", this.m_package)).andReturn((Object)this.m_dnsSvcConfig).times(3);
        EasyMock.expect((Object)this.m_pollerConfig.parameters(this.m_dnsSvcConfig)).andReturn((Object)this.m_dnsSvcConfig.getParameters()).times(6);
        PollStatus newStatus = PollStatus.available((Double)1234.0);
        OnmsLocationSpecificStatus expectedStatus = new OnmsLocationSpecificStatus(this.m_locationMonitor, this.m_dnsService, newStatus);
        EventBuilder eventBuilder = new EventBuilder("uei.opennms.org/remote/nodes/nodeRegainedService", "PollerBackEnd").setMonitoredService(this.m_dnsService).addParam("locationMonitorId", LOCATION_MONITOR_ID);
        this.m_eventIpcManager.getEventAnticipator().anticipateEvent(eventBuilder.getEvent());
        this.m_locMonDao.saveStatusChange((OnmsLocationSpecificStatus)EasyMock.isA(OnmsLocationSpecificStatus.class));
        EasyMock.expectLastCall().andAnswer((IAnswer)new StatusChecker(expectedStatus));
        this.m_mocks.replayAll();
        this.m_backEnd.saveResponseTimeData(this.m_locationMonitor.getId(), this.m_dnsService, 1234.0, this.m_package);
        this.m_backEnd.reportResult(LOCATION_MONITOR_ID, 2, newStatus);
    }

    public void testStatusChangeFromUpToDown() {
        EasyMock.expect((Object)this.m_locMonDao.get((Serializable)((Object)LOCATION_MONITOR_ID))).andReturn((Object)this.m_locationMonitor);
        EasyMock.expect((Object)this.m_monSvcDao.get((Serializable)Integer.valueOf(1))).andReturn((Object)this.m_httpService);
        EasyMock.expect((Object)this.m_locMonDao.getMostRecentStatusChange(this.m_locationMonitor, this.m_httpService)).andReturn((Object)this.m_httpCurrentStatus);
        EventBuilder eventBuilder = new EventBuilder("uei.opennms.org/remote/nodes/nodeLostService", "PollerBackEnd").setMonitoredService(this.m_httpService).addParam("locationMonitorId", LOCATION_MONITOR_ID);
        this.m_eventIpcManager.getEventAnticipator().anticipateEvent(eventBuilder.getEvent());
        PollStatus newStatus = PollStatus.unavailable((String)"Test Down");
        OnmsLocationSpecificStatus expectedStatus = new OnmsLocationSpecificStatus(this.m_locationMonitor, this.m_httpService, newStatus);
        this.m_locMonDao.saveStatusChange((OnmsLocationSpecificStatus)EasyMock.isA(OnmsLocationSpecificStatus.class));
        EasyMock.expectLastCall().andAnswer((IAnswer)new StatusChecker(expectedStatus));
        this.m_mocks.replayAll();
        this.m_backEnd.reportResult(LOCATION_MONITOR_ID, 1, newStatus);
    }

    public void testStatusDownWhenDown() {
        EasyMock.expect((Object)this.m_locMonDao.get((Serializable)((Object)LOCATION_MONITOR_ID))).andReturn((Object)this.m_locationMonitor);
        EasyMock.expect((Object)this.m_monSvcDao.get((Serializable)Integer.valueOf(2))).andReturn((Object)this.m_dnsService);
        EasyMock.expect((Object)this.m_locMonDao.getMostRecentStatusChange(this.m_locationMonitor, this.m_dnsService)).andReturn((Object)this.m_dnsCurrentStatus);
        PollStatus newStatus = PollStatus.unavailable((String)"Still Down");
        this.m_mocks.replayAll();
        this.m_backEnd.reportResult(LOCATION_MONITOR_ID, 2, newStatus);
    }

    public void testStatusDownWhenNoneKnown() {
        EasyMock.expect((Object)this.m_locMonDao.get((Serializable)((Object)LOCATION_MONITOR_ID))).andReturn((Object)this.m_locationMonitor);
        EasyMock.expect((Object)this.m_monSvcDao.get((Serializable)Integer.valueOf(2))).andReturn((Object)this.m_dnsService);
        EasyMock.expect((Object)this.m_locMonDao.getMostRecentStatusChange(this.m_locationMonitor, this.m_dnsService)).andReturn(null);
        PollStatus newStatus = PollStatus.unavailable((String)"where'd he go?");
        OnmsLocationSpecificStatus expectedStatus = new OnmsLocationSpecificStatus(this.m_locationMonitor, this.m_dnsService, newStatus);
        this.m_locMonDao.saveStatusChange((OnmsLocationSpecificStatus)EasyMock.isA(OnmsLocationSpecificStatus.class));
        EasyMock.expectLastCall().andAnswer((IAnswer)new StatusChecker(expectedStatus));
        EventBuilder eventBuilder = new EventBuilder("uei.opennms.org/remote/nodes/nodeLostService", "PollerBackEnd").setMonitoredService(this.m_dnsService).addParam("locationMonitorId", LOCATION_MONITOR_ID);
        this.m_eventIpcManager.getEventAnticipator().anticipateEvent(eventBuilder.getEvent());
        this.m_mocks.replayAll();
        this.m_backEnd.reportResult(LOCATION_MONITOR_ID, 2, newStatus);
    }

    public void testStatusUpWhenNoneKnown() {
        EasyMock.expect((Object)this.m_locMonDao.get((Serializable)((Object)LOCATION_MONITOR_ID))).andReturn((Object)this.m_locationMonitor);
        EasyMock.expect((Object)this.m_monSvcDao.get((Serializable)Integer.valueOf(2))).andReturn((Object)this.m_dnsService);
        EasyMock.expect((Object)this.m_locMonDao.getMostRecentStatusChange(this.m_locationMonitor, this.m_dnsService)).andReturn(null);
        EasyMock.expect((Object)this.m_monitoringLocationDao.get((Serializable)((Object)this.m_locationDefinition.getLocationName()))).andReturn((Object)this.m_locationDefinition);
        EasyMock.expect((Object)this.m_pollerConfig.getPackage(this.m_package.getName())).andReturn((Object)this.m_package);
        EasyMock.expect((Object)this.m_pollerConfig.getServiceInPackage("DNS", this.m_package)).andReturn((Object)this.m_dnsSvcConfig).times(3);
        EasyMock.expect((Object)this.m_pollerConfig.parameters(this.m_dnsSvcConfig)).andReturn((Object)this.m_dnsSvcConfig.getParameters()).times(6);
        PollStatus newStatus = PollStatus.available((Double)1234.0);
        OnmsLocationSpecificStatus expectedStatus = new OnmsLocationSpecificStatus(this.m_locationMonitor, this.m_dnsService, newStatus);
        this.m_locMonDao.saveStatusChange((OnmsLocationSpecificStatus)EasyMock.isA(OnmsLocationSpecificStatus.class));
        EasyMock.expectLastCall().andAnswer((IAnswer)new StatusChecker(expectedStatus));
        this.m_mocks.replayAll();
        this.m_backEnd.saveResponseTimeData(this.m_locationMonitor.getId(), this.m_dnsService, 1234.0, this.m_package);
        this.m_backEnd.reportResult(LOCATION_MONITOR_ID, 2, newStatus);
    }

    public void testStatusUpWhenUp() {
        EasyMock.expect((Object)this.m_locMonDao.get((Serializable)((Object)LOCATION_MONITOR_ID))).andReturn((Object)this.m_locationMonitor);
        EasyMock.expect((Object)this.m_monSvcDao.get((Serializable)Integer.valueOf(1))).andReturn((Object)this.m_httpService);
        EasyMock.expect((Object)this.m_pollerConfig.getServiceInPackage("HTTP", this.m_package)).andReturn((Object)this.m_httpSvcConfig).times(3);
        EasyMock.expect((Object)this.m_pollerConfig.parameters(this.m_httpSvcConfig)).andReturn((Object)this.m_httpSvcConfig.getParameters()).times(6);
        EasyMock.expect((Object)this.m_locMonDao.getMostRecentStatusChange(this.m_locationMonitor, this.m_httpService)).andReturn((Object)this.m_httpCurrentStatus);
        PollStatus newStatus = PollStatus.available((Double)1776.0);
        EasyMock.expect((Object)this.m_monitoringLocationDao.get((Serializable)((Object)this.m_locationDefinition.getLocationName()))).andReturn((Object)this.m_locationDefinition);
        EasyMock.expect((Object)this.m_pollerConfig.getPackage(this.m_package.getName())).andReturn((Object)this.m_package);
        this.m_mocks.replayAll();
        this.m_backEnd.saveResponseTimeData(this.m_locationMonitor.getId(), this.m_httpService, 1776.0, this.m_package);
        this.m_backEnd.reportResult(LOCATION_MONITOR_ID, 1, newStatus);
    }

    public void testTimeOutOnCheckin() {
        final Date now = new Date();
        this.m_locationMonitor.setStatus(OnmsLocationMonitor.MonitorStatus.STARTED);
        this.m_locationMonitor.setLastUpdated(new Date(now.getTime() - 300000L - 100L));
        EasyMock.expect((Object)this.m_locMonDao.findMatching((Criteria)EasyMock.anyObject(Criteria.class))).andReturn(Collections.singletonList(this.m_locationMonitor));
        EasyMock.expect((Object)this.m_timeKeeper.getCurrentDate()).andReturn((Object)now);
        this.anticipateDisconnectedEvent();
        this.m_locMonDao.update((Object)this.m_locationMonitor);
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<Object>(){

            public Object answer() throws Throwable {
                OnmsLocationMonitor mon = (OnmsLocationMonitor)EasyMock.getCurrentArguments()[0];
                TestCase.assertEquals((Object)OnmsLocationMonitor.MonitorStatus.DISCONNECTED, (Object)mon.getStatus());
                TestCase.assertTrue((boolean)mon.getLastUpdated().before(new Date(now.getTime() - 300000L)));
                return null;
            }
        });
        this.m_mocks.replayAll();
        this.m_backEnd.checkForDisconnectedMonitors();
    }

    public void testUnsuccessfulScanReportMessage() {
        EasyMock.expect((Object)this.m_scanReportDao.save(EasyMock.anyObject(ScanReport.class))).andReturn((Object)"");
        this.m_mocks.replayAll();
        ArrayList<ScanReportPollResult> scanReportPollResults = new ArrayList<ScanReportPollResult>();
        scanReportPollResults.add(new ScanReportPollResult("ICMP", Integer.valueOf(1), "Test Node", Integer.valueOf(1), "127.0.0.1", PollStatus.available((Double)20.0)));
        scanReportPollResults.add(new ScanReportPollResult("HTTP", Integer.valueOf(2), "Test Node", Integer.valueOf(1), "127.0.0.1", PollStatus.unavailable((String)"Weasels ate my HTTP server")));
        scanReportPollResults.add(new ScanReportPollResult("SNMP", Integer.valueOf(3), "Test Node", Integer.valueOf(1), "127.0.0.1", PollStatus.available((Double)400.0)));
        scanReportPollResults.add(new ScanReportPollResult("POP3", Integer.valueOf(3), "Test Node", Integer.valueOf(1), "127.0.0.1", PollStatus.available((Double)300.0)));
        scanReportPollResults.add(new ScanReportPollResult("IMAP", Integer.valueOf(4), "Test Node", Integer.valueOf(1), "127.0.0.1", PollStatus.unavailable((String)"Kiwis infested my mail server")));
        ScanReport report = new ScanReport();
        report.setId(UUID.randomUUID().toString());
        report.setPollResults(scanReportPollResults);
        this.m_backEnd.reportSingleScan(report);
        Event unsuccessfulScanEvent = (Event)this.m_eventIpcManager.getEventAnticipator().unanticipatedEvents().iterator().next();
        PollerBackEndTest.assertTrue((String)unsuccessfulScanEvent.getParm("scanReportFailureMessage").getValue().getContent(), (boolean)unsuccessfulScanEvent.getParm("scanReportFailureMessage").getValue().getContent().contains("2 out of 5 service polls failed"));
    }

    private void verifyPollerCheckingIn(OnmsLocationMonitor.MonitorStatus oldStatus, OnmsLocationMonitor.MonitorStatus newStatus, OnmsLocationMonitor.MonitorStatus result) {
        this.verifyPollerCheckingIn(oldStatus, newStatus, result, null);
    }

    private void verifyPollerCheckingIn(OnmsLocationMonitor.MonitorStatus oldStatus, OnmsLocationMonitor.MonitorStatus newStatus, OnmsLocationMonitor.MonitorStatus result, Event e) {
        this.m_locationMonitor.setStatus(oldStatus);
        this.expectLocationMonitorStatusChanged(oldStatus, newStatus);
        if (e != null) {
            this.anticipateEvent(e);
        }
        this.m_mocks.replayAll();
        PollerBackEndTest.assertEquals((String)"Unexpected result state", (Object)result, (Object)this.m_backEnd.pollerCheckingIn(LOCATION_MONITOR_ID, this.m_startTime));
    }

    public void testSaveResponseTimeDataWithLocaleThatUsesCommasForDecimals() throws Exception {
        Properties p = new Properties();
        p.setProperty("org.opennms.netmgt.ConfigFileConstants", "ERROR");
        MockLogAppender.setupLogging((Properties)p);
        Locale.setDefault(Locale.FRENCH);
        NumberFormat nf = NumberFormat.getInstance();
        PollerBackEndTest.assertEquals((String)("ensure that the newly set default locale (" + Locale.getDefault() + ") uses ',' as the decimal marker"), (String)"1,5", (String)nf.format(1.5));
        OnmsMonitoredService svc = new OnmsMonitoredService();
        OnmsServiceType svcType = new OnmsServiceType();
        svcType.setName("HTTP");
        svc.setServiceType(svcType);
        OnmsIpInterface intf = new OnmsIpInterface();
        intf.setIpAddress(InetAddressUtils.addr((String)"1.2.3.4"));
        svc.setIpInterface(intf);
        Package pkg = new Package();
        Service pkgService = new Service();
        pkgService.setName("HTTP");
        PollerBackEndTest.addParameterToService(pkgService, "ds-name", "http");
        PollerBackEndTest.addParameterToService(pkgService, "rrd-repository", "/foo");
        pkg.addService(pkgService);
        Rrd rrd = new Rrd();
        rrd.setStep(Integer.valueOf(300));
        rrd.addRra("bogusRRA");
        pkg.setRrd(rrd);
        EasyMock.expect((Object)this.m_pollerConfig.getServiceInPackage("HTTP", pkg)).andReturn((Object)this.m_httpSvcConfig);
        EasyMock.expect((Object)this.m_pollerConfig.parameters(this.m_httpSvcConfig)).andReturn((Object)this.m_httpSvcConfig.getParameters()).atLeastOnce();
        this.m_mocks.replayAll();
        this.m_backEnd.saveResponseTimeData("Tuvalu", svc, 1.5, pkg);
    }

    private static void addParameterToService(Service pkgService, String key, String value) {
        Parameter param = new Parameter();
        param.setKey(key);
        param.setValue(value);
        pkgService.addParameter(param);
    }

    private final class StatusChecker
    implements IAnswer<Object> {
        private OnmsLocationSpecificStatus m_status;

        private StatusChecker(OnmsLocationSpecificStatus status) {
            this.m_status = status;
        }

        public Object answer() throws Throwable {
            OnmsLocationSpecificStatus status = (OnmsLocationSpecificStatus)EasyMock.getCurrentArguments()[0];
            TestCase.assertEquals((Object)this.m_status.getLocationMonitor(), (Object)status.getLocationMonitor());
            TestCase.assertEquals((Object)this.m_status.getMonitoredService(), (Object)status.getMonitoredService());
            TestCase.assertEquals((int)this.m_status.getPollResult().getStatusCode(), (int)status.getPollResult().getStatusCode());
            TestCase.assertEquals((Object)this.m_status.getPollResult().getResponseTime(), (Object)status.getPollResult().getResponseTime());
            TestCase.assertEquals((String)this.m_status.getPollResult().getReason(), (String)status.getPollResult().getReason());
            return null;
        }
    }

    public static class EventEquals
    implements IArgumentMatcher {
        private Event m_expected;

        EventEquals(Event value) {
            this.m_expected = value;
        }

        public void appendTo(StringBuffer buffer) {
            buffer.append(this.m_expected);
        }

        public boolean matches(Object argument) {
            Event actual = (Event)argument;
            if (this.m_expected == null) {
                return actual == null;
            }
            return this.m_expected.getUei().equals(actual.getUei()) && this.nullSafeEquals(this.m_expected.getSource(), actual.getSource()) && this.m_expected.getNodeid() == actual.getNodeid() && this.nullSafeEquals(this.m_expected.getInterface(), actual.getInterface()) && this.nullSafeEquals(this.m_expected.getService(), actual.getService()) && EventUtils.getLongParm((Event)this.m_expected, (String)"locationMonitorId", (long)-1L) == EventUtils.getLongParm((Event)actual, (String)"locationMonitorId", (long)-1L);
        }

        private boolean nullSafeEquals(Object a, Object b) {
            return a == null ? b == null : a.equals(b);
        }
    }
}

