/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.client.rpc;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.opennms.core.rpc.api.RpcRequest;
import org.opennms.core.rpc.api.RpcTarget;
import org.opennms.core.rpc.utils.mate.FallbackScope;
import org.opennms.core.rpc.utils.mate.Interpolator;
import org.opennms.core.rpc.utils.mate.Scope;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.PollerRequestBuilder;
import org.opennms.netmgt.poller.PollerResponse;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.opennms.netmgt.poller.ServiceMonitorAdaptor;
import org.opennms.netmgt.poller.client.rpc.LocationAwarePollerClientImpl;
import org.opennms.netmgt.poller.client.rpc.PollerRequestDTO;

public class PollerRequestBuilderImpl
implements PollerRequestBuilder {
    private MonitoredService service;
    private String systemId;
    private String className;
    private ServiceMonitor serviceMonitor;
    private LocationAwarePollerClientImpl client;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final List<ServiceMonitorAdaptor> adaptors = new LinkedList<ServiceMonitorAdaptor>();
    private Long ttlInMs;

    public PollerRequestBuilderImpl(LocationAwarePollerClientImpl client) {
        this.client = client;
    }

    public PollerRequestBuilder withService(MonitoredService service) {
        this.service = service;
        return this;
    }

    public PollerRequestBuilder withSystemId(String systemId) {
        this.systemId = systemId;
        return this;
    }

    public PollerRequestBuilder withMonitor(ServiceMonitor serviceMonitor) {
        this.serviceMonitor = serviceMonitor;
        return this;
    }

    public PollerRequestBuilder withMonitorClassName(String className) {
        this.className = className;
        this.serviceMonitor = this.client.getRegistry().getMonitorByClassName(className);
        return this;
    }

    public PollerRequestBuilder withTimeToLive(Long ttlInMs) {
        this.ttlInMs = ttlInMs;
        return this;
    }

    public PollerRequestBuilder withAttribute(String key, Object value) {
        this.attributes.put(key, value);
        return this;
    }

    public PollerRequestBuilder withAttributes(Map<String, Object> attributes) {
        this.attributes.putAll(attributes);
        return this;
    }

    public PollerRequestBuilder withAdaptor(ServiceMonitorAdaptor adaptor) {
        this.adaptors.add(adaptor);
        return this;
    }

    public CompletableFuture<PollerResponse> execute() {
        if (this.serviceMonitor == null) {
            throw new IllegalArgumentException("Monitor or monitor class name is required.");
        }
        if (this.service == null) {
            throw new IllegalArgumentException("Monitored service is required.");
        }
        Map interpolatedAttributes = Interpolator.interpolateObjects(this.attributes, (Scope)new FallbackScope(new Scope[]{this.client.getEntityScopeProvider().getScopeForNode(Integer.valueOf(this.service.getNodeId())), this.client.getEntityScopeProvider().getScopeForInterface(Integer.valueOf(this.service.getNodeId()), this.service.getIpAddr()), this.client.getEntityScopeProvider().getScopeForService(Integer.valueOf(this.service.getNodeId()), this.service.getAddress(), this.service.getSvcName())}));
        RpcTarget target = this.client.getRpcTargetHelper().target().withNodeId(Integer.valueOf(this.service.getNodeId())).withLocation(this.service.getNodeLocation()).withSystemId(this.systemId).withServiceAttributes(interpolatedAttributes).withLocationOverride(s -> this.serviceMonitor.getEffectiveLocation(s)).build();
        PollerRequestDTO request = new PollerRequestDTO();
        request.setLocation(target.getLocation());
        request.setSystemId(target.getSystemId());
        String pollerClassName = this.className != null ? this.className : this.serviceMonitor.getClass().getCanonicalName();
        request.setClassName(pollerClassName);
        request.setServiceName(this.service.getSvcName());
        request.setAddress(this.service.getAddress());
        request.setNodeId(this.service.getNodeId());
        request.setNodeLabel(this.service.getNodeLabel());
        request.setNodeLocation(this.service.getNodeLocation());
        request.setTimeToLiveMs(this.ttlInMs);
        request.addAttributes(interpolatedAttributes);
        request.addTracingInfo("nodeId", String.valueOf(this.service.getNodeId()));
        request.addTracingInfo("nodeLabel", this.service.getNodeLabel());
        request.addTracingInfo("className", pollerClassName);
        request.addTracingInfo("ipAddress", InetAddressUtils.toIpAddrString((InetAddress)this.service.getAddress()));
        Map<String, Object> parameters = request.getMonitorParameters();
        request.addAttributes(this.serviceMonitor.getRuntimeAttributes((MonitoredService)request, parameters));
        return this.client.getDelegate().execute((RpcRequest)request).thenApply(results -> {
            PollStatus pollStatus = results.getPollStatus();
            for (ServiceMonitorAdaptor adaptor : this.adaptors) {
                pollStatus = adaptor.handlePollResult(this.service, interpolatedAttributes, pollStatus);
            }
            results.setPollStatus(pollStatus);
            return results;
        });
    }
}

