/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.SocketUtils;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.nrpe.NrpeException;
import org.opennms.netmgt.poller.monitors.nrpe.NrpePacket;
import org.opennms.netmgt.poller.support.AbstractServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable
public final class NrpeMonitor
extends AbstractServiceMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(NrpeMonitor.class);
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;
    private static final boolean DEFAULT_USE_SSL = true;
    private static final String[] ADH_CIPHER_SUITES = new String[]{"TLS_DH_anon_WITH_AES_128_CBC_SHA"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        String reason = null;
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 3000);
        String command = ParameterMap.getKeyedString(parameters, (String)"command", (String)"_NRPE_CHECK");
        int port = ParameterMap.getKeyedInteger(parameters, (String)"port", (int)5666);
        int padding = ParameterMap.getKeyedInteger(parameters, (String)"padding", (int)2);
        boolean useSsl = ParameterMap.getKeyedBoolean(parameters, (String)"usessl", (boolean)true);
        InetAddress ipv4Addr = svc.getAddress();
        String hostAddress = InetAddressUtils.str((InetAddress)ipv4Addr);
        LOG.debug("poll: address = {}, port = {}, {}", new Object[]{hostAddress, port, tracker});
        int serviceStatus = 2;
        Double responseTime = null;
        tracker.reset();
        while (tracker.shouldRetry() && serviceStatus != 1) {
            Socket socket = null;
            try {
                tracker.startAttempt();
                socket = new Socket();
                socket.connect(new InetSocketAddress(ipv4Addr, port), tracker.getConnectionTimeout());
                socket.setSoTimeout(tracker.getSoTimeout());
                LOG.debug("NrpeMonitor: connected to host: {} on port: {}", (Object)ipv4Addr, (Object)port);
                reason = "Perhaps check the value of 'usessl' for this monitor against the NRPE daemon configuration";
                socket = this.wrapSocket(socket, useSsl);
                serviceStatus = 3;
                reason = "Connected successfully, but no response received";
                NrpePacket p = new NrpePacket(1, 0, command);
                byte[] b = p.buildPacket(padding);
                OutputStream o = socket.getOutputStream();
                o.write(b);
                NrpePacket response = NrpePacket.receivePacket((InputStream)socket.getInputStream(), (int)padding);
                responseTime = tracker.elapsedTimeInMillis();
                if (response.getResultCode() == 0) {
                    serviceStatus = 1;
                    reason = null;
                } else {
                    serviceStatus = 2;
                    reason = "NRPE command returned code " + response.getResultCode() + " and message: " + response.getBuffer();
                }
            }
            catch (NoRouteToHostException e) {
                reason = "No route to host exception for address " + hostAddress;
                LOG.warn("poll: {}", (Object)reason, (Object)e);
            }
            catch (InterruptedIOException e) {
                reason = "did not connect to host within " + tracker;
                LOG.debug("NrpeMonitor: did not connect to host within {}", (Object)tracker);
            }
            catch (ConnectException e) {
                reason = "Connection exception for address: " + ipv4Addr;
                if (LOG.isDebugEnabled()) {
                    e.fillInStackTrace();
                    LOG.debug("poll: {}", (Object)reason, (Object)e);
                }
            }
            catch (NrpeException e) {
                reason = "NrpeException while polling address: " + ipv4Addr;
                if (LOG.isDebugEnabled()) {
                    e.fillInStackTrace();
                    LOG.debug("poll: {}", (Object)reason, (Object)e);
                }
            }
            catch (IOException e) {
                reason = "IOException while polling address: " + ipv4Addr;
                if (LOG.isDebugEnabled()) {
                    e.fillInStackTrace();
                    LOG.debug("poll: {}", (Object)reason, (Object)e);
                }
            }
            finally {
                block36: {
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (IOException e) {
                        if (!LOG.isDebugEnabled()) break block36;
                        e.fillInStackTrace();
                        LOG.debug("poll: Error closing socket.", (Throwable)e);
                    }
                }
            }
            tracker.nextAttempt();
        }
        if (reason == null) {
            return PollStatus.get((int)serviceStatus, responseTime);
        }
        return PollStatus.get((int)serviceStatus, reason);
    }

    protected Socket wrapSocket(Socket socket, boolean useSsl) throws IOException {
        if (!useSsl) {
            return socket;
        }
        return SocketUtils.wrapSocketInSslContext((Socket)socket, null, (String[])ADH_CIPHER_SUITES);
    }
}

