/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.systemreport;

import java.io.DataInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.io.IOUtils;
import org.opennms.systemreport.OutputSuckingParser;
import org.opennms.systemreport.ResourceLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemReportResourceLocator
implements ResourceLocator {
    private static final Logger LOG = LoggerFactory.getLogger(SystemReportResourceLocator.class);
    private long m_maxProcessWait;

    public SystemReportResourceLocator(long maxProcessWait) {
        this.m_maxProcessWait = maxProcessWait;
    }

    @Override
    public String findBinary(String name) {
        ArrayList<String> pathEntries = new ArrayList<String>();
        String path = System.getenv().get("PATH");
        if (path != null) {
            for (String p : path.split(File.pathSeparator)) {
                pathEntries.add(p);
            }
            pathEntries.add("/sbin");
            pathEntries.add("/usr/sbin");
            pathEntries.add("/usr/local/sbin");
        }
        for (String dir : pathEntries) {
            File file = new File(dir, name);
            if (file.exists()) {
                return file.getPath();
            }
            file = new File(dir, name + ".exe");
            if (!file.exists()) continue;
            return file.getPath();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String slurpOutput(String commandString, boolean ignoreExitCode) {
        CommandLine command = CommandLine.parse((String)commandString);
        LOG.debug("running: {}", (Object)commandString);
        HashMap<String, String> environment = new HashMap<String, String>(System.getenv());
        environment.put("COLUMNS", "2000");
        DataInputStream input = null;
        PipedInputStream pis = null;
        OutputSuckingParser parser = null;
        String outputText = null;
        DefaultExecutor executor = new DefaultExecutor();
        PipedOutputStream output = new PipedOutputStream();
        PumpStreamHandler streamHandler = new PumpStreamHandler((OutputStream)output, (OutputStream)output);
        executor.setWatchdog(new ExecuteWatchdog(this.m_maxProcessWait));
        executor.setStreamHandler((ExecuteStreamHandler)streamHandler);
        if (ignoreExitCode) {
            executor.setExitValues(null);
        }
        try {
            LOG.trace("executing '{}'", (Object)commandString);
            pis = new PipedInputStream(output);
            input = new DataInputStream(pis);
            parser = new OutputSuckingParser(input);
            parser.start();
            int exitValue = executor.execute(command, environment);
            IOUtils.closeQuietly((OutputStream)output);
            parser.join(this.m_maxProcessWait);
            if (!ignoreExitCode && exitValue != 0) {
                LOG.debug("error running '{}': exit value was {}", (Object)commandString, (Object)exitValue);
            } else {
                outputText = parser.getOutput();
            }
            LOG.trace("finished '{}'", (Object)commandString);
        }
        catch (Exception e) {
            try {
                LOG.debug("Failed to run '{}'", (Object)commandString, (Object)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((OutputStream)output);
                IOUtils.closeQuietly(input);
                IOUtils.closeQuietly(pis);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)output);
            IOUtils.closeQuietly(input);
            IOUtils.closeQuietly((InputStream)pis);
        }
        IOUtils.closeQuietly((OutputStream)output);
        IOUtils.closeQuietly((InputStream)input);
        IOUtils.closeQuietly((InputStream)pis);
        return outputText;
    }
}

