/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.systemreport.system;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.TreeMap;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.io.IOUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.systemreport.AbstractSystemReportPlugin;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadReportPlugin
extends AbstractSystemReportPlugin {
    @Override
    public String getName() {
        return "Threads";
    }

    @Override
    public String getDescription() {
        return "Java Thread Dump";
    }

    @Override
    public int getPriority() {
        return 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TreeMap<String, Resource> getEntries() {
        TreeMap<String, Resource> map;
        block10: {
            String outputLog;
            block11: {
                FileWriter fw;
                BufferedReader bfr;
                FileReader fr;
                block9: {
                    map = new TreeMap<String, Resource>();
                    LogUtils.tracef((Object)this, (String)"starting thread dump", (Object[])new Object[0]);
                    this.triggerThreadDump();
                    LogUtils.tracef((Object)this, (String)"thread dump finished", (Object[])new Object[0]);
                    outputLog = System.getProperty("opennms.home") + File.separator + "logs" + File.separator + "daemon" + File.separator + "output.log";
                    LogUtils.debugf((Object)this, (String)("reading file " + outputLog), (Object[])new Object[0]);
                    File outputLogFile = new File(outputLog);
                    fr = null;
                    bfr = null;
                    fw = null;
                    File threadDumpFile = null;
                    String threadDump = null;
                    if (!outputLogFile.exists()) break block11;
                    try {
                        String line;
                        threadDumpFile = File.createTempFile("ThreadReportPlugin", null);
                        threadDumpFile.deleteOnExit();
                        fr = new FileReader(outputLogFile);
                        bfr = new BufferedReader(fr);
                        fw = new FileWriter(threadDumpFile);
                        StringBuffer sb = null;
                        boolean endOnCarriageReturn = false;
                        while ((line = bfr.readLine()) != null) {
                            if (line.startsWith("Full thread dump")) {
                                LogUtils.debugf((Object)this, (String)"found full thread dump", (Object[])new Object[0]);
                                sb = new StringBuffer();
                                sb.append(line).append("\n");
                                continue;
                            }
                            if (sb == null) continue;
                            if (endOnCarriageReturn && line.length() == 0) {
                                endOnCarriageReturn = false;
                                threadDump = sb.toString();
                                sb = null;
                                continue;
                            }
                            if (line.startsWith("Heap")) {
                                endOnCarriageReturn = true;
                                sb.append(line).append("\n");
                                continue;
                            }
                            sb.append(line).append("\n");
                        }
                        if (threadDump == null) {
                            LogUtils.debugf((Object)this, (String)"No thread dump was found.", (Object[])new Object[0]);
                            break block9;
                        }
                        fw.append(threadDump);
                        map.put("ThreadDump.txt", (Resource)new FileSystemResource(threadDumpFile));
                    }
                    catch (Exception e) {
                        try {
                            LogUtils.debugf((Object)this, (Throwable)e, (String)"Unable to read from '%s'", (Object[])new Object[]{outputLog});
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(fw);
                            IOUtils.closeQuietly(bfr);
                            IOUtils.closeQuietly(fr);
                            throw throwable;
                        }
                        IOUtils.closeQuietly(fw);
                        IOUtils.closeQuietly((Reader)bfr);
                        IOUtils.closeQuietly((Reader)fr);
                        break block10;
                    }
                }
                IOUtils.closeQuietly((Writer)fw);
                IOUtils.closeQuietly((Reader)bfr);
                IOUtils.closeQuietly((Reader)fr);
                break block10;
            }
            LogUtils.warnf((Object)this, (String)"could not find output.log in '%s'", (Object[])new Object[]{outputLog});
        }
        return map;
    }

    private void triggerThreadDump() {
        String kill = this.findBinary("kill");
        if (kill != null) {
            for (Integer pid : this.getOpenNMSProcesses()) {
                LogUtils.debugf((Object)this, (String)("pid = " + pid), (Object[])new Object[0]);
                CommandLine command = CommandLine.parse((String)(kill + " -3 " + pid.toString()));
                try {
                    LogUtils.tracef((Object)this, (String)"running '%s'", (Object[])new Object[]{command.toString()});
                    DefaultExecutor executor = new DefaultExecutor();
                    executor.setWatchdog(new ExecuteWatchdog(5000L));
                    int exitValue = executor.execute(command);
                    LogUtils.tracef((Object)this, (String)"finished '%s'", (Object[])new Object[]{command.toString()});
                    if (exitValue == 0) continue;
                    LogUtils.warnf((Object)this, (String)"'%s' exited non-zero: %d", (Object[])new Object[]{command.toString(), exitValue});
                }
                catch (Exception e) {
                    LogUtils.warnf((Object)this, (Throwable)e, (String)"Unable to run kill -3 on '%s': you might need to run system-report as root.", (Object[])new Object[]{pid.toString()});
                }
            }
        }
    }
}

