/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.systemreport.system;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.opennms.core.utils.LogUtils;
import org.opennms.systemreport.AbstractSystemReportPlugin;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSReportPlugin
extends AbstractSystemReportPlugin {
    private static final Map<String, String> m_oses = new LinkedHashMap<String, String>();

    public OSReportPlugin() {
        if (m_oses.size() == 0) {
            m_oses.put("/etc/SUSE-release", "SuSE");
            m_oses.put("/etc/redhat-release", "Red Hat");
            m_oses.put("/etc/fedora-release", "Fedora");
            m_oses.put("/etc/slackware-release", "Slackware");
            m_oses.put("/etc/debian_version", "Debian");
            m_oses.put("/etc/debian_release", "Debian");
            m_oses.put("/etc/mandriva-release", "Mandriva");
            m_oses.put("/etc/mandrake-release", "Mandrake");
            m_oses.put("/etc/mandrakelinux-release", "Mandrake");
            m_oses.put("/etc/yellowdog-release", "Yellow Dog");
            m_oses.put("/etc/sun-release", "Java Desktop System");
            m_oses.put("/etc/gentoo-release", "Gentoo");
            m_oses.put("/etc/UnitedLinux-release", "UnitedLinux");
        }
    }

    @Override
    public String getName() {
        return "OS";
    }

    @Override
    public String getDescription() {
        return "Kernel, OS, and Distribution";
    }

    @Override
    public int getPriority() {
        return 2;
    }

    @Override
    public TreeMap<String, Resource> getEntries() {
        TreeMap<String, Resource> map = new TreeMap<String, Resource>();
        map.put("Name", this.getResourceFromProperty("os.name"));
        map.put("Architecture", this.getResourceFromProperty("os.arch"));
        map.put("Version", this.getResourceFromProperty("os.version"));
        map.put("Distribution", (Resource)map.get("Name"));
        OperatingSystemMXBean osBean = this.getBean("java.lang:type=OperatingSystem", OperatingSystemMXBean.class);
        if (osBean == null) {
            LogUtils.infof((Object)this, (String)"falling back to local VM OperatingSystemMXBean", (Object[])new Object[0]);
            osBean = ManagementFactory.getOperatingSystemMXBean();
        }
        LogUtils.tracef((Object)this, (String)"bean = %s", (Object[])new Object[]{osBean.toString()});
        this.addGetters(osBean, map);
        File lsb = new File("/bin/lsb_release");
        File solaris = new File("/var/sadm/softinfo/INST_RELEASE");
        if (lsb.exists()) {
            String text = this.slurpCommand(new String[]{"/bin/lsb_release", "-a"});
            Map<String, String> distMap = this.splitMultilineString(": +", text);
            for (Map.Entry<String, String> entry : distMap.entrySet()) {
                map.put("Distribution " + entry.getKey(), this.getResource(entry.getValue()));
            }
        } else if (solaris.exists()) {
            String arch;
            File isainfo;
            map.put("Distribution Os", this.getResource("Solaris"));
            String solarisText = this.slurp(solaris);
            Map<String, String> distMap = this.splitMultilineString("=", solarisText);
            for (Map.Entry<String, String> entry : distMap.entrySet()) {
                map.put("Distribution " + entry.getKey().toLowerCase().replaceFirst("^.", entry.getKey().substring(0, 1).toUpperCase()), this.getResource(entry.getValue()));
            }
            if (map.containsKey("Distribution Os")) {
                map.put("Distribution", map.remove("Distribution Os"));
            }
            if ((isainfo = new File("/usr/bin/isainfo")).exists() && (arch = this.slurpCommand(new String[]{"/usr/bin/isainfo", "-n"})) != null) {
                map.put("Instruction Set", this.getResource(arch));
            }
        } else {
            for (Map.Entry<String, String> entry : m_oses.entrySet()) {
                String description = this.slurp(new File(entry.getKey()));
                if (description == null) continue;
                map.put("Distribution", this.getResource(entry.getValue()));
                map.put("Description", this.getResource(description.trim()));
            }
        }
        if (map.containsKey("Distribution Distributor ID")) {
            map.put("Distribution", map.remove("Distribution Distributor ID"));
        }
        if (map.containsKey("Distribution Descrption")) {
            map.put("Description", map.remove("Distribution Description"));
        }
        return map;
    }
}

