/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.systemreport.system;

import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.RuntimeMXBean;
import java.util.TreeMap;
import org.opennms.core.utils.LogUtils;
import org.opennms.systemreport.AbstractSystemReportPlugin;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaReportPlugin
extends AbstractSystemReportPlugin {
    @Override
    public String getName() {
        return "Java";
    }

    @Override
    public String getDescription() {
        return "Java and JVM";
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public TreeMap<String, Resource> getEntries() {
        TreeMap<String, Resource> map = new TreeMap<String, Resource>();
        map.put("Class Version", this.getResourceFromProperty("java.class.version"));
        map.put("Compiler", this.getResourceFromProperty("java.compiler"));
        map.put("Home", this.getResourceFromProperty("java.home"));
        map.put("Version", this.getResourceFromProperty("java.version"));
        map.put("Vendor", this.getResourceFromProperty("java.vendor"));
        map.put("VM Version", this.getResourceFromProperty("java.vm.version"));
        map.put("VM Name", this.getResourceFromProperty("java.vm.name"));
        MemoryMXBean memoryBean = this.getBean("java.lang:type=Memory", MemoryMXBean.class);
        if (memoryBean == null) {
            LogUtils.infof((Object)this, (String)"falling back to local VM MemoryMXBean", (Object[])new Object[0]);
            memoryBean = ManagementFactory.getMemoryMXBean();
        }
        LogUtils.tracef((Object)this, (String)"bean = %s", (Object[])new Object[]{memoryBean.toString()});
        this.addGetters(memoryBean, map);
        RuntimeMXBean runtimeBean = this.getBean("java.lang:type=Runtime", RuntimeMXBean.class);
        if (runtimeBean == null) {
            LogUtils.infof((Object)this, (String)"falling back to local VM RuntimeMXBean", (Object[])new Object[0]);
            runtimeBean = ManagementFactory.getRuntimeMXBean();
        }
        LogUtils.tracef((Object)this, (String)"bean = %s", (Object[])new Object[]{runtimeBean.toString()});
        this.addGetters(runtimeBean, map);
        ClassLoadingMXBean classBean = this.getBean("java.lang:type=ClassLoading", ClassLoadingMXBean.class);
        if (classBean == null) {
            LogUtils.infof((Object)this, (String)"falling back to local VM ClassLoadingMXBean", (Object[])new Object[0]);
            classBean = ManagementFactory.getClassLoadingMXBean();
        }
        LogUtils.tracef((Object)this, (String)"bean = %s", (Object[])new Object[]{classBean.toString()});
        this.addGetters(classBean, map);
        return map;
    }
}

