/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.systemreport.formatters;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.systemreport.SystemReportFormatter;
import org.opennms.systemreport.SystemReportPlugin;
import org.opennms.systemreport.formatters.AbstractSystemReportFormatter;
import org.opennms.systemreport.formatters.TextSystemReportFormatter;
import org.springframework.core.io.Resource;

public class ZipSystemReportFormatter
extends AbstractSystemReportFormatter
implements SystemReportFormatter {
    private File m_tempFile;
    private ZipOutputStream m_zipOutputStream;
    private Set<String> m_directories = new HashSet<String>();

    public ZipSystemReportFormatter() {
        try {
            this.m_tempFile = File.createTempFile(this.getName(), null);
            this.m_tempFile.deleteOnExit();
        }
        catch (IOException e) {
            LogUtils.errorf((Object)this, (Throwable)e, (String)"Unable to create temporary file!", (Object[])new Object[0]);
        }
    }

    public String getName() {
        return "zip";
    }

    public String getDescription() {
        return "compressed file of all resources";
    }

    public boolean canStdout() {
        return false;
    }

    public void begin() {
        super.begin();
        try {
            this.m_zipOutputStream = new ZipOutputStream(new FileOutputStream(this.m_tempFile));
            this.m_zipOutputStream.setLevel(9);
        }
        catch (Exception e) {
            LogUtils.errorf((Object)this, (Throwable)e, (String)"Unable to create zip file '%s'", (Object[])new Object[]{this.m_tempFile});
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(SystemReportPlugin plugin) {
        String name = plugin.getName() + ".txt";
        try {
            this.createDirectory("");
        }
        catch (Exception e) {
            LogUtils.errorf((Object)this, (Throwable)e, (String)"Unable to create entry '%s'", (Object[])new Object[]{name});
            return;
        }
        if (this.hasDisplayable(plugin)) {
            try {
                this.createEntry(name);
            }
            catch (Exception e) {
                LogUtils.errorf((Object)this, (Throwable)e, (String)"Unable to create entry '%s'", (Object[])new Object[]{name});
                return;
            }
            TextSystemReportFormatter formatter = new TextSystemReportFormatter();
            formatter.setOutputStream(this.m_zipOutputStream);
            formatter.begin();
            ((AbstractSystemReportFormatter)formatter).write(plugin);
            formatter.end();
        }
        byte[] buf = new byte[1024];
        for (Map.Entry<String, Resource> entry : plugin.getEntries().entrySet()) {
            Resource resource = entry.getValue();
            if (!this.isFile(resource)) continue;
            try {
                this.createDirectory(plugin.getName());
            }
            catch (Exception e) {
                LogUtils.errorf((Object)this, (Throwable)e, (String)"Unable to create directory '%s'", (Object[])new Object[]{plugin.getName()});
                return;
            }
            String entryName = String.format("%s/%s", plugin.getName(), entry.getKey());
            try {
                this.createEntry(entryName);
            }
            catch (Exception e) {
                LogUtils.errorf((Object)this, (Throwable)e, (String)"Unable to create entry '%s'", (Object[])new Object[]{entryName});
                return;
            }
            InputStream is = null;
            try {
                int len;
                is = resource.getInputStream();
                while ((len = is.read(buf)) > 0) {
                    this.m_zipOutputStream.write(buf, 0, len);
                }
            }
            catch (Exception e) {
                LogUtils.warnf((Object)this, (Throwable)e, (String)"Unable to read resource '%s'", (Object[])new Object[]{resource});
                return;
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() {
        try {
            this.m_zipOutputStream.closeEntry();
        }
        catch (IOException e) {
            LogUtils.warnf((Object)this, (Throwable)e, (String)"Unable to close last entry.", (Object[])new Object[0]);
        }
        IOUtils.closeQuietly((OutputStream)this.m_zipOutputStream);
        FileInputStream is = null;
        try {
            int len;
            byte[] buf = new byte[1024];
            is = new FileInputStream(this.m_tempFile);
            OutputStream os = this.getOutputStream();
            while ((len = ((InputStream)is).read(buf)) > 0) {
                os.write(buf, 0, len);
            }
        }
        catch (Exception e) {
            try {
                LogUtils.warnf((Object)this, (Throwable)e, (String)"Unable to read temporary zip file '%s'", (Object[])new Object[]{this.m_tempFile});
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        IOUtils.closeQuietly((InputStream)is);
    }

    private void createEntry(String name) throws IOException {
        LogUtils.infof((Object)this, (String)"adding to zip: opennms-system-report/%s", (Object[])new Object[]{name});
        this.m_zipOutputStream.putNextEntry(new ZipEntry("opennms-system-report/" + name));
    }

    private void createDirectory(String name) throws IOException {
        if (this.m_directories.contains(name)) {
            return;
        }
        this.createEntry(name + "/");
        this.m_directories.add(name);
    }
}

