/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.systemreport.formatters;

import java.util.Map;
import org.opennms.core.utils.LogUtils;
import org.opennms.systemreport.SystemReportFormatter;
import org.opennms.systemreport.SystemReportPlugin;
import org.opennms.systemreport.formatters.AbstractSystemReportFormatter;
import org.springframework.core.io.Resource;

public class TextSystemReportFormatter
extends AbstractSystemReportFormatter
implements SystemReportFormatter {
    public String getName() {
        return "text";
    }

    public String getDescription() {
        return "simple human-readable indented text";
    }

    public boolean canStdout() {
        return true;
    }

    public void write(SystemReportPlugin plugin) {
        if (!this.hasDisplayable(plugin)) {
            return;
        }
        LogUtils.debugf((Object)this, (String)"write(%s)", (Object[])new Object[]{plugin.getName()});
        try {
            String title = plugin.getName() + " (" + plugin.getDescription() + "):" + "\n";
            this.getOutputStream().write(title.getBytes());
            for (Map.Entry<String, Resource> entry : plugin.getEntries().entrySet()) {
                Resource value = entry.getValue();
                boolean displayable = this.isDisplayable(value);
                String text = displayable ? "\t" + entry.getKey() + ": " + this.getResourceText(value) + "\n" : "\t" + entry.getKey() + ": " + (value == null ? "NULL" : value.getClass().getSimpleName() + " resource is not displayable.  Try using the 'zip' format.") + "\n";
                this.getOutputStream().write(text.getBytes());
            }
        }
        catch (Exception e) {
            LogUtils.errorf((Object)this, (Throwable)e, (String)"Error writing plugin data.", (Object[])new Object[0]);
        }
    }
}

