/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.systemreport.formatters;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.opennms.core.utils.LogUtils;
import org.opennms.systemreport.SystemReportFormatter;
import org.opennms.systemreport.SystemReportPlugin;
import org.opennms.systemreport.formatters.AbstractSystemReportFormatter;
import org.springframework.core.io.Resource;

public class FullTextSystemReportFormatter
extends AbstractSystemReportFormatter
implements SystemReportFormatter {
    public String getName() {
        return "full";
    }

    public String getDescription() {
        return "human-readable text (including large resources like logs)";
    }

    public boolean canStdout() {
        return true;
    }

    public void write(SystemReportPlugin plugin) {
        OutputStream out = this.getOutputStream();
        try {
            out.write(String.format("= %s: %s =\n\n", plugin.getName(), plugin.getDescription()).getBytes());
            for (Map.Entry<String, Resource> entry : plugin.getEntries().entrySet()) {
                int bytes;
                Resource value = entry.getValue();
                out.write(String.format("== %s ==\n\n", entry.getKey()).getBytes());
                InputStream is = value.getInputStream();
                byte[] buffer = new byte[1024];
                while ((bytes = is.read(buffer)) != -1) {
                    out.write(buffer, 0, bytes);
                }
                is.close();
                out.write("\n\n".getBytes());
            }
        }
        catch (Exception e) {
            LogUtils.infof((Object)this, (Throwable)e, (String)"unable to write", (Object[])new Object[0]);
        }
    }
}

