/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.systemreport;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.opennms.core.utils.LogUtils;
import org.opennms.systemreport.OutputSuckingParser;
import org.opennms.systemreport.SystemReportPlugin;
import org.opennms.systemreport.system.PsParser;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSystemReportPlugin
implements SystemReportPlugin {
    protected static final long MAX_PROCESS_WAIT = 10000L;
    private MBeanServerConnection m_connection = null;

    @Override
    public int getPriority() {
        return 99;
    }

    @Override
    public TreeMap<String, Resource> getEntries() {
        throw new UnsupportedOperationException("You must override getEntries()!");
    }

    public String toString() {
        return String.format("%s[%d]", this.getName(), this.getPriority());
    }

    @Override
    public int compareTo(SystemReportPlugin o) {
        return new CompareToBuilder().append(this.getPriority(), o == null ? Integer.MIN_VALUE : o.getPriority()).append((Object)this.getName(), (Object)(o == null ? null : o.getName())).toComparison();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String slurp(File lsb) {
        if (lsb != null && lsb.exists()) {
            String string;
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(lsb);
                FileChannel fc = stream.getChannel();
                MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
                string = Charset.defaultCharset().decode(bb).toString().replace("[\\r\\n]*$", "");
            }
            catch (Exception e) {
                try {
                    LogUtils.debugf((Object)this, (Throwable)e, (String)"Unable to read from file '%s'", (Object[])new Object[]{lsb.getPath()});
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(stream);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)stream);
            }
            IOUtils.closeQuietly((InputStream)stream);
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String slurpCommand(String[] command) {
        Process p = null;
        InputStream is = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        StringBuffer sb = new StringBuffer();
        try {
            String line;
            p = Runtime.getRuntime().exec(command);
            is = p.getInputStream();
            isr = new InputStreamReader(is);
            br = new BufferedReader(isr);
            while (br.ready() && (line = br.readLine()) != null) {
                sb.append(line);
                if (!br.ready()) continue;
                sb.append("\n");
            }
        }
        catch (Throwable e) {
            try {
                LogUtils.debugf((Object)this, (Throwable)e, (String)"Failure attempting to run command '%s'", (Object[])new Object[]{Arrays.asList(command).toString()});
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(br);
                IOUtils.closeQuietly(isr);
                IOUtils.closeQuietly((InputStream)is);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)br);
            IOUtils.closeQuietly((Reader)isr);
            IOUtils.closeQuietly((InputStream)is);
        }
        IOUtils.closeQuietly((Reader)br);
        IOUtils.closeQuietly((Reader)isr);
        IOUtils.closeQuietly((InputStream)is);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> splitMultilineString(String regex, String text) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (text != null) {
            StringReader sr = new StringReader(text);
            BufferedReader br = new BufferedReader(sr);
            try {
                while (br.ready()) {
                    String line = br.readLine();
                    if (line == null) {
                        break;
                    }
                    String[] entry = line.split(regex, 2);
                    if (entry.length != 2) continue;
                    map.put(entry[0], entry[1]);
                }
            }
            catch (IOException e) {
                LogUtils.debugf((Object)this, (Throwable)e, (String)"an error occurred parsing the text", (Object[])new Object[0]);
            }
            finally {
                IOUtils.closeQuietly((Reader)br);
                IOUtils.closeQuietly((Reader)sr);
            }
        }
        return map;
    }

    protected Resource getResourceFromProperty(String propertyName) {
        return this.getResource(System.getProperty(propertyName));
    }

    protected Resource getResource(String text) {
        if (text == null) {
            return new ByteArrayResource(new byte[0]);
        }
        return new ByteArrayResource(text.getBytes());
    }

    protected String findBinary(String name) {
        ArrayList<String> pathEntries = new ArrayList<String>();
        String path = System.getenv().get("PATH");
        if (path != null) {
            for (String p : path.split(File.pathSeparator)) {
                pathEntries.add(p);
            }
            pathEntries.add("/sbin");
            pathEntries.add("/usr/sbin");
            pathEntries.add("/usr/local/sbin");
        }
        for (String dir : pathEntries) {
            File file = new File(dir, name);
            if (file.exists()) {
                return file.getPath();
            }
            file = new File(dir, name + ".exe");
            if (!file.exists()) continue;
            return file.getPath();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String slurpOutput(CommandLine command, boolean ignoreExitCode) {
        LogUtils.debugf((Object)this, (String)"running: %s", (Object[])new Object[]{command.toString()});
        HashMap<String, String> environment = new HashMap<String, String>(System.getenv());
        environment.put("COLUMNS", "2000");
        DataInputStream input = null;
        PipedInputStream pis = null;
        OutputSuckingParser parser = null;
        String topOutput = null;
        DefaultExecutor executor = new DefaultExecutor();
        PipedOutputStream output = new PipedOutputStream();
        PumpStreamHandler streamHandler = new PumpStreamHandler((OutputStream)output, (OutputStream)output);
        executor.setWatchdog(new ExecuteWatchdog(10000L));
        executor.setStreamHandler((ExecuteStreamHandler)streamHandler);
        try {
            LogUtils.tracef((Object)this, (String)"executing '%s'", (Object[])new Object[]{command.toString()});
            pis = new PipedInputStream(output);
            input = new DataInputStream(pis);
            parser = new OutputSuckingParser(input);
            parser.start();
            int exitValue = executor.execute(command, environment);
            IOUtils.closeQuietly((OutputStream)output);
            parser.join(10000L);
            if (!ignoreExitCode && exitValue != 0) {
                LogUtils.debugf((Object)this, (String)"error running '%s': exit value was %d", (Object[])new Object[]{command.toString(), exitValue});
            } else {
                topOutput = parser.getOutput();
            }
            LogUtils.tracef((Object)this, (String)"finished '%s'", (Object[])new Object[]{command.toString()});
        }
        catch (Exception e) {
            try {
                LogUtils.debugf((Object)this, (Throwable)e, (String)"Failed to run '%s'", (Object[])new Object[]{command.toString()});
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((OutputStream)output);
                IOUtils.closeQuietly(input);
                IOUtils.closeQuietly(pis);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)output);
            IOUtils.closeQuietly(input);
            IOUtils.closeQuietly((InputStream)pis);
        }
        IOUtils.closeQuietly((OutputStream)output);
        IOUtils.closeQuietly((InputStream)input);
        IOUtils.closeQuietly((InputStream)pis);
        return topOutput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File createTemporaryFileFromString(String text) {
        File tempFile = null;
        FileWriter fw = null;
        try {
            tempFile = File.createTempFile("topReportPlugin", null);
            tempFile.deleteOnExit();
            fw = new FileWriter(tempFile);
            fw.write(text);
            fw.close();
        }
        catch (Exception e) {
            try {
                LogUtils.debugf((Object)this, (Throwable)e, (String)"Unable to write to temporary file.", (Object[])new Object[0]);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fw);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)fw);
        }
        IOUtils.closeQuietly((Writer)fw);
        return tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<Integer> getOpenNMSProcesses() {
        HashSet<Integer> processes;
        block19: {
            PumpStreamHandler streamHandler;
            CommandLine command;
            String ps;
            DefaultExecutor executor;
            PipedOutputStream output;
            PipedInputStream pis;
            PsParser parser;
            DataInputStream input;
            block18: {
                LogUtils.debugf((Object)this, (String)"getOpenNMSProcesses()", (Object[])new Object[0]);
                processes = new HashSet<Integer>();
                String jps = this.findBinary("jps");
                LogUtils.debugf((Object)this, (String)"jps = %s", (Object[])new Object[]{jps});
                input = null;
                parser = null;
                pis = null;
                output = new PipedOutputStream();
                executor = new DefaultExecutor();
                executor.setWatchdog(new ExecuteWatchdog(5000L));
                if (jps != null) {
                    block17: {
                        CommandLine command2 = CommandLine.parse((String)(jps + " -v"));
                        PumpStreamHandler streamHandler2 = new PumpStreamHandler((OutputStream)output, (OutputStream)System.err);
                        try {
                            LogUtils.tracef((Object)this, (String)"executing '%s'", (Object[])new Object[]{command2.toString()});
                            pis = new PipedInputStream(output);
                            input = new DataInputStream(pis);
                            parser = new PsParser(input, "opennms_bootstrap.jar", "status", 0);
                            parser.start();
                            executor.setStreamHandler((ExecuteStreamHandler)streamHandler2);
                            int exitValue = executor.execute(command2);
                            IOUtils.closeQuietly((OutputStream)output);
                            parser.join();
                            processes.addAll(parser.getProcesses());
                            LogUtils.tracef((Object)this, (String)"finished '%s'", (Object[])new Object[]{command2.toString()});
                            if (exitValue == 0) break block17;
                            LogUtils.debugf((Object)this, (String)"error running '%s': exit value was %d", (Object[])new Object[]{command2.toString(), exitValue});
                        }
                        catch (Exception e) {
                            try {
                                LogUtils.debugf((Object)this, (Throwable)e, (String)"Failed to run '%s'", (Object[])new Object[]{command2.toString()});
                            }
                            catch (Throwable throwable) {
                                IOUtils.closeQuietly(input);
                                IOUtils.closeQuietly(pis);
                                IOUtils.closeQuietly((OutputStream)output);
                                throw throwable;
                            }
                            IOUtils.closeQuietly(input);
                            IOUtils.closeQuietly((InputStream)pis);
                            IOUtils.closeQuietly((OutputStream)output);
                        }
                    }
                    IOUtils.closeQuietly((InputStream)input);
                    IOUtils.closeQuietly((InputStream)pis);
                    IOUtils.closeQuietly((OutputStream)output);
                }
                LogUtils.tracef((Object)this, (String)"looking for ps", (Object[])new Object[0]);
                ps = this.findBinary("ps");
                if (ps == null) break block19;
                command = CommandLine.parse((String)(ps + " aww -o pid -o args"));
                output = new PipedOutputStream();
                streamHandler = new PumpStreamHandler((OutputStream)output, (OutputStream)System.err);
                try {
                    LogUtils.debugf((Object)this, (String)"executing '%s'", (Object[])new Object[]{command.toString()});
                    pis = new PipedInputStream(output);
                    input = new DataInputStream(pis);
                    parser = new PsParser(input, "opennms_bootstrap.jar", "status", 0);
                    parser.start();
                    executor.setStreamHandler((ExecuteStreamHandler)streamHandler);
                    int exitValue = executor.execute(command);
                    IOUtils.closeQuietly((OutputStream)output);
                    parser.join(10000L);
                    processes.addAll(parser.getProcesses());
                    LogUtils.tracef((Object)this, (String)"finished '%s'", (Object[])new Object[]{command.toString()});
                    if (exitValue == 0) break block18;
                    LogUtils.debugf((Object)this, (String)"error running '%s': exit value was %d", (Object[])new Object[]{command.toString(), exitValue});
                }
                catch (Exception e) {
                    try {
                        LogUtils.debugf((Object)this, (Throwable)e, (String)"error running '%s'", (Object[])new Object[]{command.toString()});
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(input);
                        IOUtils.closeQuietly((InputStream)pis);
                        IOUtils.closeQuietly((OutputStream)output);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)input);
                    IOUtils.closeQuietly((InputStream)pis);
                    IOUtils.closeQuietly((OutputStream)output);
                }
            }
            IOUtils.closeQuietly((InputStream)input);
            IOUtils.closeQuietly((InputStream)pis);
            IOUtils.closeQuietly((OutputStream)output);
            if (processes.size() == 0) {
                command = CommandLine.parse((String)(ps + " -ea -o pid -o args"));
                output = new PipedOutputStream();
                streamHandler = new PumpStreamHandler((OutputStream)output, (OutputStream)System.err);
                try {
                    LogUtils.debugf((Object)this, (String)"executing '%s'", (Object[])new Object[]{command.toString()});
                    pis = new PipedInputStream(output);
                    input = new DataInputStream(pis);
                    parser = new PsParser(input, "opennms_bootstrap.jar", "status", 0);
                    parser.start();
                    executor.setStreamHandler((ExecuteStreamHandler)streamHandler);
                    int exitValue = executor.execute(command);
                    IOUtils.closeQuietly((OutputStream)output);
                    parser.join(10000L);
                    processes.addAll(parser.getProcesses());
                    LogUtils.tracef((Object)this, (String)"finished '%s'", (Object[])new Object[]{command.toString()});
                    if (exitValue != 0) {
                        LogUtils.debugf((Object)this, (String)"error running '%s': exit value was %d", (Object[])new Object[]{command.toString(), exitValue});
                    }
                }
                catch (Exception e) {
                    LogUtils.debugf((Object)this, (Throwable)e, (String)"error running '%s'", (Object[])new Object[]{command.toString()});
                }
                finally {
                    IOUtils.closeQuietly((InputStream)input);
                    IOUtils.closeQuietly((InputStream)pis);
                    IOUtils.closeQuietly((OutputStream)output);
                }
            }
        }
        if (processes.size() == 0) {
            LogUtils.warnf((Object)this, (String)"Unable to find any OpenNMS processes.", (Object[])new Object[0]);
        }
        return processes;
    }

    private MBeanServerConnection getConnection() {
        ArrayList<Integer> ports = new ArrayList<Integer>();
        Integer p = Integer.getInteger("com.sun.management.jmxremote.port");
        if (p != null) {
            ports.add(p);
        }
        ports.add(18980);
        ports.add(1099);
        for (Integer port : ports) {
            LogUtils.tracef((Object)this, (String)"Trying JMX at localhost:%d/jmxrmi", (Object[])new Object[]{port});
            try {
                JMXServiceURL url = new JMXServiceURL(String.format("service:jmx:rmi:///jndi/rmi://localhost:%d/jmxrmi", port));
                JMXConnector jmxc = JMXConnectorFactory.connect(url, null);
                return jmxc.getMBeanServerConnection();
            }
            catch (Exception e) {
                LogUtils.debugf((Object)this, (Throwable)e, (String)"Unable to get JMX connection to OpenNMS on port %d.", (Object[])new Object[]{port});
            }
        }
        return null;
    }

    protected void addGetters(Object o, Map<String, Resource> map) {
        if (o != null) {
            for (Method method : o.getClass().getDeclaredMethods()) {
                Object value;
                method.setAccessible(true);
                if (!method.getName().startsWith("get") || !Modifier.isPublic(method.getModifiers())) continue;
                try {
                    value = method.invoke(o, new Object[0]);
                }
                catch (Exception e) {
                    value = e;
                }
                String key = method.getName().replaceFirst("^get", "").replaceAll("([A-Z])", " $1").replaceFirst("^ ", "").replaceAll("\\bVm\\b", "VM");
                map.put(key, this.getResource(value.toString()));
            }
        }
    }

    protected <T> List<T> getBeans(String mxBeanName, Class<T> clazz) {
        this.initializeConnection();
        ArrayList<T> beans = new ArrayList<T>();
        if (this.m_connection == null) {
            return beans;
        }
        try {
            ObjectName o = new ObjectName(mxBeanName + ",*");
            for (ObjectName name : this.m_connection.queryNames(o, null)) {
                beans.add(this.getBean(name.getCanonicalName(), clazz));
            }
        }
        catch (Exception e) {
            LogUtils.warnf((Object)this, (Throwable)e, (String)"Unable to get beans of type '%s'", (Object[])new Object[]{mxBeanName});
        }
        return beans;
    }

    protected <T> T getBean(String mxBeanName, Class<T> clazz) {
        ArrayList<Class<T>> classes = new ArrayList<Class<T>>();
        classes.add(clazz);
        return this.getBean(mxBeanName, classes);
    }

    protected <T> T getBean(String mxBeanName, List<? extends Class<T>> classes) {
        this.initializeConnection();
        if (this.m_connection == null || mxBeanName == null || classes == null || classes.size() == 0) {
            return null;
        }
        T bean = null;
        for (Class<T> c : classes) {
            try {
                bean = ManagementFactory.newPlatformMXBeanProxy(this.m_connection, mxBeanName, c);
                break;
            }
            catch (Exception e) {
                LogUtils.infof((Object)this, (Throwable)e, (String)"Unable to get management bean %s for class %s", (Object[])new Object[]{mxBeanName, c.getName()});
            }
        }
        return bean;
    }

    private void initializeConnection() {
        if (this.m_connection == null) {
            this.m_connection = this.getConnection();
        }
    }
}

