/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.systemreport.system;

import java.io.File;
import java.util.TreeMap;
import org.apache.commons.exec.CommandLine;
import org.opennms.systemreport.AbstractSystemReportPlugin;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class LsofReportPlugin
extends AbstractSystemReportPlugin {
    @Override
    public String getName() {
        return "lsof";
    }

    @Override
    public String getDescription() {
        return "Output of the 'lsof' command (full output only)";
    }

    @Override
    public int getPriority() {
        return 12;
    }

    @Override
    public TreeMap<String, Resource> getEntries() {
        File tempFile;
        TreeMap<String, Resource> map = new TreeMap<String, Resource>();
        String lsofOutput = null;
        String lsof = this.findBinary("lsof");
        if (lsof != null) {
            lsofOutput = this.slurpOutput(CommandLine.parse((String)lsof), false);
        }
        if (lsofOutput != null && (tempFile = this.createTemporaryFileFromString(lsofOutput)) != null) {
            map.put("Output", (Resource)new FileSystemResource(tempFile));
        }
        return map;
    }
}

