/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.systemreport.system;

import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.RuntimeMXBean;
import java.util.TreeMap;
import org.opennms.systemreport.AbstractSystemReportPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class JavaReportPlugin
extends AbstractSystemReportPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(JavaReportPlugin.class);

    @Override
    public String getName() {
        return "Java";
    }

    @Override
    public String getDescription() {
        return "Java and JVM information";
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public TreeMap<String, Resource> getEntries() {
        TreeMap<String, Resource> map = new TreeMap<String, Resource>();
        map.put("Class Version", this.getResourceFromProperty("java.class.version"));
        map.put("Compiler", this.getResourceFromProperty("java.compiler"));
        map.put("Home", this.getResourceFromProperty("java.home"));
        map.put("Version", this.getResourceFromProperty("java.version"));
        map.put("Vendor", this.getResourceFromProperty("java.vendor"));
        map.put("VM Version", this.getResourceFromProperty("java.vm.version"));
        map.put("VM Name", this.getResourceFromProperty("java.vm.name"));
        MemoryMXBean memoryBean = this.getBean("java.lang:type=Memory", MemoryMXBean.class);
        if (memoryBean == null) {
            LOG.info("falling back to local VM MemoryMXBean");
            memoryBean = ManagementFactory.getMemoryMXBean();
        }
        this.addGetters(memoryBean, map);
        RuntimeMXBean runtimeBean = this.getBean("java.lang:type=Runtime", RuntimeMXBean.class);
        if (runtimeBean == null) {
            LOG.info("falling back to local VM RuntimeMXBean");
            runtimeBean = ManagementFactory.getRuntimeMXBean();
        }
        this.addGetters(runtimeBean, map);
        ClassLoadingMXBean classBean = this.getBean("java.lang:type=ClassLoading", ClassLoadingMXBean.class);
        if (classBean == null) {
            LOG.info("falling back to local VM ClassLoadingMXBean");
            classBean = ManagementFactory.getClassLoadingMXBean();
        }
        this.addGetters(classBean, map);
        return map;
    }
}

