/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.systemreport.system;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.opennms.core.utils.LogUtils;

public final class PsParser
extends Thread {
    private final Set<Integer> m_processes = Collections.synchronizedSet(new HashSet());
    private DataInputStream m_input;
    private final String m_matchText;
    private final String m_skipText;
    private final int m_matchField;

    public PsParser(DataInputStream input, String matchText, String skipText, int matchField) {
        this.m_input = input;
        this.m_matchText = matchText;
        this.m_skipText = skipText;
        this.m_matchField = matchField;
    }

    @Override
    public void run() {
        InputStreamReader isr = new InputStreamReader(this.m_input);
        BufferedReader reader = new BufferedReader(isr);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).contains(this.m_matchText)) {
                    if (this.m_skipText != null && this.m_skipText.length() > 0 && line.contains(this.m_skipText)) {
                        LogUtils.debugf((Object)this, (String)"skipped match: %s", (Object[])new Object[]{line});
                        continue;
                    }
                    LogUtils.debugf((Object)this, (String)"found match: %s", (Object[])new Object[]{line});
                    String[] entries = line.split(" +");
                    this.m_processes.add(Integer.valueOf(entries[this.m_matchField]));
                }
                if (!this.isInterrupted()) continue;
                break;
            }
        }
        catch (IOException e) {
            if (!e.getMessage().contains("Write end dead")) {
                LogUtils.debugf((Object)this, (Throwable)e, (String)"An error occurred matching '%s' for field '%d' in the input stream.", (Object[])new Object[]{this.m_matchText, this.m_matchField});
            }
        }
        catch (Exception e) {
            LogUtils.debugf((Object)this, (Throwable)e, (String)"An error occurred matching '%s' for field '%d' in the input stream.", (Object[])new Object[]{this.m_matchText, this.m_matchField});
        }
    }

    public Set<Integer> getProcesses() {
        return this.m_processes;
    }
}

