/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.springframework.security;

import java.util.Date;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.model.events.EventProxyException;
import org.opennms.netmgt.xml.event.Event;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.security.Authentication;
import org.springframework.security.event.authentication.AbstractAuthenticationEvent;
import org.springframework.security.event.authentication.AbstractAuthenticationFailureEvent;
import org.springframework.security.event.authentication.AuthenticationSuccessEvent;
import org.springframework.security.event.authentication.InteractiveAuthenticationSuccessEvent;
import org.springframework.security.event.authorization.AuthorizationFailureEvent;
import org.springframework.security.event.authorization.AuthorizedEvent;
import org.springframework.security.ui.WebAuthenticationDetails;
import org.springframework.util.Assert;
import org.springframework.web.context.support.ServletRequestHandledEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityAuthenticationEventOnmsEventBuilder
implements ApplicationListener<ApplicationEvent>,
InitializingBean {
    public static final String SUCCESS_UEI = "uei.opennms.org/internal/authentication/successfulLogin";
    public static final String FAILURE_UEI = "uei.opennms.org/internal/authentication/failure";
    private EventProxy m_eventProxy;

    public void onApplicationEvent(ApplicationEvent event) {
        EventBuilder builder;
        AuthenticationSuccessEvent authEvent;
        this.log().debug("Received ApplicationEvent " + event.getClass().toString());
        if (event instanceof AuthenticationSuccessEvent) {
            authEvent = (AuthenticationSuccessEvent)event;
            builder = this.createEvent(SUCCESS_UEI, (AbstractAuthenticationEvent)authEvent);
            if (!"true".equalsIgnoreCase(System.getProperty("org.opennms.security.disableLoginSuccessEvent"))) {
                this.sendEvent(builder.getEvent());
            }
        }
        if (event instanceof AbstractAuthenticationFailureEvent) {
            authEvent = (AbstractAuthenticationFailureEvent)event;
            this.log().debug("AbstractAuthenticationFailureEvent was received, exception message - " + authEvent.getException().getMessage());
            builder = this.createEvent(FAILURE_UEI, (AbstractAuthenticationEvent)authEvent);
            builder.addParam("exceptionName", authEvent.getException().getClass().getSimpleName());
            builder.addParam("exceptionMessage", authEvent.getException().getMessage());
            this.sendEvent(builder.getEvent());
        }
        if (event instanceof AuthorizedEvent) {
            authEvent = (AuthorizedEvent)event;
            this.log().debug("AuthorizedEvent received - \n  Details - " + authEvent.getAuthentication().getDetails() + "\n  Principal - " + authEvent.getAuthentication().getPrincipal());
        }
        if (event instanceof AuthorizationFailureEvent) {
            authEvent = (AuthorizationFailureEvent)event;
            this.log().debug("AuthorizationFailureEvent received  -\n   Details - " + authEvent.getAuthentication().getDetails() + "\n  Principal - " + authEvent.getAuthentication().getPrincipal());
        }
        if (event instanceof InteractiveAuthenticationSuccessEvent) {
            authEvent = (InteractiveAuthenticationSuccessEvent)event;
            this.log().debug("InteractiveAuthenticationSuccessEvent received - \n  Details - " + authEvent.getAuthentication().getDetails() + "\n  Principal -  " + authEvent.getAuthentication().getPrincipal());
        }
        if (event instanceof ServletRequestHandledEvent) {
            authEvent = (ServletRequestHandledEvent)event;
            this.log().debug("ServletRequestHandledEvent received - " + authEvent.getDescription() + "\n  Servlet - " + authEvent.getServletName() + "\n  URL - " + authEvent.getRequestUrl());
            this.log().info(authEvent.getRequestUrl() + " requested from " + authEvent.getClientAddress() + " by user " + authEvent.getUserName());
        }
    }

    private EventBuilder createEvent(String uei, AbstractAuthenticationEvent authEvent) {
        WebAuthenticationDetails webDetails;
        EventBuilder builder = new EventBuilder(uei, "OpenNMS.WebUI");
        builder.setTime(new Date(authEvent.getTimestamp()));
        Authentication auth = authEvent.getAuthentication();
        if (auth != null && auth.getName() != null) {
            builder.addParam("user", auth.getName());
        }
        if (auth != null && auth.getDetails() != null && auth.getDetails() instanceof WebAuthenticationDetails && (webDetails = (WebAuthenticationDetails)auth.getDetails()).getRemoteAddress() != null) {
            builder.addParam("ip", webDetails.getRemoteAddress());
        }
        return builder;
    }

    private void sendEvent(Event onmsEvent) {
        try {
            this.m_eventProxy.send(onmsEvent);
        }
        catch (EventProxyException e) {
            this.log().error("Failed to send OpenNMS event to event proxy (" + this.m_eventProxy + "): " + (Object)((Object)e), (Throwable)e);
        }
    }

    public void setEventProxy(EventProxy eventProxy) {
        this.m_eventProxy = eventProxy;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.m_eventProxy, (String)"property eventProxy must be set");
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

