/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.springframework.security;

import java.util.HashMap;
import java.util.Map;

public final class Authentication {
    public static final String USER_ROLE = "ROLE_USER";
    public static final String ADMIN_ROLE = "ROLE_ADMIN";
    public static final String READONLY_ROLE = "ROLE_READONLY";
    public static final String DASHBOARD_ROLE = "ROLE_DASHBOARD";
    public static final String RTC_ROLE = "ROLE_RTC";
    public static final String PROVISION_ROLE = "ROLE_PROVISION";
    public static final String REMOTING_ROLE = "ROLE_REMOTING";
    public static final String REST_ROLE = "ROLE_REST";
    private static Map<String, String> s_oldToNewMap = new HashMap<String, String>();

    private Authentication() {
    }

    public static String getSpringSecuirtyRoleFromOldRoleName(String oldRole) {
        return s_oldToNewMap.get(oldRole);
    }

    static {
        s_oldToNewMap.put("OpenNMS RTC Daemon", RTC_ROLE);
        s_oldToNewMap.put("OpenNMS Administrator", ADMIN_ROLE);
        s_oldToNewMap.put("OpenNMS Read-Only User", READONLY_ROLE);
        s_oldToNewMap.put("OpenNMS Dashboard User", DASHBOARD_ROLE);
        s_oldToNewMap.put("OpenNMS Provision User", PROVISION_ROLE);
        s_oldToNewMap.put("OpenNMS Remote Poller User", REMOTING_ROLE);
        s_oldToNewMap.put("OpenNMS REST User", REST_ROLE);
    }
}

