/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web;

import java.net.ConnectException;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.events.EventProxyException;
import org.opennms.web.ServletInitializer;
import org.opennms.web.category.CategoryList;
import org.opennms.web.category.RTCPostSubscriber;

public class InitializerServletContextListener
implements ServletContextListener {
    private Timer rtcCheckTimer = null;

    public void contextInitialized(ServletContextEvent event) {
        try {
            ServletInitializer.init((ServletContext)event.getServletContext());
            this.log().info("Initialized servlet systems successfully");
        }
        catch (ServletException e) {
            this.log().error("Error while initializing servlet systems: " + (Object)((Object)e), (Throwable)e);
        }
        catch (Throwable e) {
            this.log().error("Error while initializing user, group, or view factory: " + e, e);
        }
        try {
            this.rtcCheckTimer = new Timer();
            this.rtcCheckTimer.schedule((TimerTask)new RTCPostSubscriberTimerTask(), new Date(), 130000L);
        }
        catch (ServletException e) {
            this.log().error("Error while initializing RTC check timer: " + (Object)((Object)e), (Throwable)e);
        }
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public void contextDestroyed(ServletContextEvent event) {
        try {
            ServletInitializer.destroy((ServletContext)event.getServletContext());
            this.log().info("Destroyed servlet systems successfully");
        }
        catch (ServletException e) {
            this.log().error("Error while destroying servlet systems: " + (Object)((Object)e), (Throwable)e);
        }
        if (this.rtcCheckTimer != null) {
            this.rtcCheckTimer.cancel();
            this.rtcCheckTimer = null;
        }
    }

    public class RTCPostSubscriberTimerTask
    extends TimerTask {
        private CategoryList m_categorylist = new CategoryList();

        public void run() {
            try {
                if (!this.m_categorylist.isDisconnected()) {
                    return;
                }
            }
            catch (Throwable e) {
                this.log().error("Error checking if OpenNMS is disconnected: " + e, e);
                return;
            }
            this.log().info("OpenNMS is disconnected -- attempting RTC POST subscription");
            try {
                RTCPostSubscriber.subscribeAll((String)"WebConsoleView");
                this.log().info("RTC POST subscription event sent successfully");
            }
            catch (EventProxyException e) {
                if (e.getCause() instanceof ConnectException) {
                    this.log().info("RTC POST failed due to ConnectException: " + e.getCause().toString());
                } else {
                    this.log().error("Error subscribing to RTC POSTs: " + (Object)((Object)e), (Throwable)e);
                }
            }
            catch (Throwable e) {
                this.log().error("Error subscribing to RTC POSTs: " + e, e);
            }
        }

        private ThreadCategory log() {
            return ThreadCategory.getInstance(this.getClass());
        }
    }
}

