/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.springframework.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.opennms.core.utils.BundleLists;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.GroupFactory;
import org.opennms.netmgt.config.GroupManager;
import org.opennms.netmgt.config.groups.Role;
import org.opennms.netmgt.config.users.Userinfo;
import org.opennms.netmgt.dao.castor.CastorUtils;
import org.opennms.web.springframework.security.Authentication;
import org.opennms.web.springframework.security.UpperCaseMd5PasswordEncoder;
import org.opennms.web.springframework.security.User;
import org.opennms.web.springframework.security.UserDao;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserDaoImpl
implements UserDao,
InitializingBean {
    private static final UpperCaseMd5PasswordEncoder PASSWORD_ENCODER = new UpperCaseMd5PasswordEncoder();
    private static final GrantedAuthority ROLE_USER = new GrantedAuthorityImpl("ROLE_USER");
    private String m_usersConfigurationFile;
    private String m_groupsConfigurationFile;
    private Map<String, User> m_users = null;
    private long m_usersLastModified;
    private String m_magicUsersConfigurationFile;
    private Map<String, User> m_magicUsers = null;
    private Map<String, GrantedAuthority[]> m_roles = null;
    private long m_magicUsersLastModified;
    private long m_groupsLastModified;
    private boolean m_useGroups;

    private Userinfo unmarshallUsers() throws DataRetrievalFailureException {
        return (Userinfo)CastorUtils.unmarshalWithTranslatedExceptions(Userinfo.class, (Resource)new FileSystemResource(this.m_usersConfigurationFile));
    }

    private void parseUsers() throws DataRetrievalFailureException {
        HashMap<String, User> users = new HashMap<String, User>();
        long lastModified = new File(this.m_usersConfigurationFile).lastModified();
        Userinfo userinfo = this.unmarshallUsers();
        List usersList = userinfo.getUsers().getUserCollection();
        for (org.opennms.netmgt.config.users.User user : usersList) {
            User newUser = new User();
            newUser.setUsername(user.getUserId());
            newUser.setPassword(user.getPassword());
            users.put(user.getUserId(), newUser);
        }
        this.log().debug("Loaded the users.xml file with " + users.size() + " users");
        this.m_usersLastModified = lastModified;
        this.m_users = users;
    }

    private Map<String, LinkedList<String>> parseGroupRoles() throws DataRetrievalFailureException {
        long lastModified = new File(this.m_groupsConfigurationFile).lastModified();
        try {
            GroupFactory.init();
        }
        catch (Exception e) {
            throw new DataRetrievalFailureException("Error reading groups configuration file '" + this.m_groupsConfigurationFile + "': " + e.getMessage(), (Throwable)e);
        }
        GroupManager gm = GroupFactory.getInstance();
        HashMap<String, LinkedList<String>> roleMap = new HashMap<String, LinkedList<String>>();
        Collection roles = gm.getRoles();
        for (Role role : roles) {
            List users;
            String groupname = role.getMembershipGroup();
            String securityRole = Authentication.getSpringSecuirtyRoleFromOldRoleName(role.getName());
            if (securityRole == null) continue;
            try {
                users = gm.getGroup(groupname).getUserCollection();
            }
            catch (Exception e) {
                throw new DataRetrievalFailureException("Error reading groups configuration file '" + this.m_groupsConfigurationFile + "': " + e.getMessage(), (Throwable)e);
            }
            for (String user : users) {
                if (roleMap.get(user) == null) {
                    roleMap.put(user, new LinkedList());
                }
                LinkedList userRoleList = (LinkedList)roleMap.get(user);
                userRoleList.add(securityRole);
            }
        }
        this.log().debug("Loaded roles from groups.xml file for " + roleMap.size() + " users");
        this.m_groupsLastModified = lastModified;
        return roleMap;
    }

    private void parseMagicUsers() throws DataRetrievalFailureException {
        String[] configuredUsers;
        HashMap<String, User> magicUsers = new HashMap<String, User>();
        HashMap<String, GrantedAuthority[]> roles = new HashMap<String, GrantedAuthority[]>();
        long lastModified = new File(this.m_magicUsersConfigurationFile).lastModified();
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(this.m_magicUsersConfigurationFile));
        }
        catch (FileNotFoundException e) {
            throw new DataRetrievalFailureException("Magic users configuration file '" + this.m_magicUsersConfigurationFile + "' not found: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new DataRetrievalFailureException("Error reading magic users configuration file '" + this.m_magicUsersConfigurationFile + "': " + e.getMessage(), (Throwable)e);
        }
        for (String user : configuredUsers = BundleLists.parseBundleList((String)properties.getProperty("users"))) {
            String username = properties.getProperty("user." + user + ".username");
            String password = properties.getProperty("user." + user + ".password");
            User newUser = new User();
            newUser.setUsername(username);
            newUser.setPassword(PASSWORD_ENCODER.encodePassword(password, null));
            magicUsers.put(username, newUser);
        }
        String[] configuredRoles = BundleLists.parseBundleList((String)properties.getProperty("roles"));
        HashMap roleMap = this.m_useGroups ? this.parseGroupRoles() : new HashMap();
        HashMap<String, Boolean> roleAddDefaultMap = new HashMap<String, Boolean>();
        for (String role : configuredRoles) {
            String rolename = properties.getProperty("role." + role + ".name");
            if (rolename == null) {
                throw new DataRetrievalFailureException("Role configuration for '" + role + "' does not have 'name' parameter.  Expecting a 'role." + role + ".name' property");
            }
            String userList = properties.getProperty("role." + role + ".users");
            if (userList == null) {
                throw new DataRetrievalFailureException("Role configuration for '" + role + "' does not have 'users' parameter.  Expecting a 'role." + role + ".users' property");
            }
            String[] authUsers = BundleLists.parseBundleList((String)userList);
            boolean notInDefaultGroup = "true".equals(properties.getProperty("role." + role + ".notInDefaultGroup"));
            String securityRole = Authentication.getSpringSecuirtyRoleFromOldRoleName(rolename);
            if (securityRole == null) {
                throw new DataRetrievalFailureException("Could not find Spring Security role mapping for old role name '" + rolename + "' for role '" + role + "'");
            }
            for (String authUser : authUsers) {
                if (roleMap.get(authUser) == null) {
                    roleMap.put(authUser, new LinkedList());
                }
                LinkedList userRoleList = (LinkedList)roleMap.get(authUser);
                userRoleList.add(securityRole);
            }
            roleAddDefaultMap.put(securityRole, !notInDefaultGroup);
        }
        for (String user : roleMap.keySet()) {
            roles.put(user, this.getAuthorityListFromRoleList((LinkedList)roleMap.get(user), roleAddDefaultMap));
        }
        this.log().debug("Loaded the magic-users.properties file with " + magicUsers.size() + " magic users, " + configuredRoles.length + " roles, and " + roles.size() + " user roles");
        this.m_magicUsersLastModified = lastModified;
        this.m_magicUsers = magicUsers;
        this.m_roles = roles;
    }

    private GrantedAuthority[] getAuthorityListFromRoleList(LinkedList<String> roleList, Map<String, Boolean> roleAddDefaultMap) {
        boolean addToDefaultGroup = false;
        for (String role : roleList) {
            if (!Boolean.TRUE.equals(roleAddDefaultMap.get(role))) continue;
            addToDefaultGroup = true;
            break;
        }
        LinkedList<Object> authorities = new LinkedList<Object>();
        if (addToDefaultGroup) {
            authorities.add(ROLE_USER);
        }
        for (String role : roleList) {
            authorities.add(new GrantedAuthorityImpl(role));
        }
        return authorities.toArray(new GrantedAuthority[authorities.size()]);
    }

    protected GrantedAuthority[] getAuthoritiesByUsername(String user) {
        if (this.m_roles.containsKey(user)) {
            return this.m_roles.get(user);
        }
        return new GrantedAuthority[]{ROLE_USER};
    }

    private boolean isUsersParseNecessary() {
        if (this.m_users == null) {
            return true;
        }
        return this.m_usersLastModified != new File(this.m_usersConfigurationFile).lastModified();
    }

    private boolean isGroupsParseNecessary() {
        return this.m_groupsLastModified != new File(this.m_groupsConfigurationFile).lastModified();
    }

    private boolean isMagicUsersParseNecessary() {
        if (this.m_magicUsers == null) {
            return true;
        }
        return this.m_magicUsersLastModified != new File(this.m_magicUsersConfigurationFile).lastModified();
    }

    public void setUsersConfigurationFile(String usersConfigurationFile) {
        this.m_usersConfigurationFile = usersConfigurationFile;
    }

    public void setGroupsConfigurationFile(String groupsConfigurationFile) {
        this.m_groupsConfigurationFile = groupsConfigurationFile;
    }

    public void setUseGroups(boolean useGroups) {
        this.m_useGroups = useGroups;
    }

    public String getUsersConfigurationFile() {
        return this.m_usersConfigurationFile;
    }

    public void setMagicUsersConfigurationFile(String magicUsersConfigurationFile) {
        this.m_magicUsersConfigurationFile = magicUsersConfigurationFile;
    }

    public String getMagicUsersConfigurationFile() {
        return this.m_magicUsersConfigurationFile;
    }

    @Override
    public User getByUsername(String username) {
        this.reloadIfNecessary();
        User user = this.m_magicUsers.containsKey(username) ? this.m_magicUsers.get(username) : this.m_users.get(username);
        if (user == null) {
            return null;
        }
        user.setAuthorities(this.getAuthoritiesByUsername(username));
        return user;
    }

    private void reloadIfNecessary() {
        if (this.isUsersParseNecessary()) {
            this.parseUsers();
        }
        if (this.isMagicUsersParseNecessary() || this.m_useGroups && this.isGroupsParseNecessary()) {
            this.parseMagicUsers();
        }
    }

    private final ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public long getMagicUsersLastModified() {
        return this.m_magicUsersLastModified;
    }

    public long getUsersLastModified() {
        return this.m_usersLastModified;
    }

    public long getGroupsLastModified() {
        return this.m_groupsLastModified;
    }

    public boolean isUseGroups() {
        return this.m_useGroups;
    }

    public void afterPropertiesSet() {
        Assert.state((this.m_usersConfigurationFile != null ? 1 : 0) != 0, (String)"usersConfigurationFile parameter must be set to the location of the users.xml configuration file");
        Assert.state((!this.m_useGroups || this.m_groupsConfigurationFile != null ? 1 : 0) != 0, (String)"groupsConfigurationFile parameter must be set to the location of the groups.xml configuration file");
        Assert.state((this.m_magicUsersConfigurationFile != null ? 1 : 0) != 0, (String)"magicUsersConfigurationFile parameter must be set to the location of the magic-users.properties configuration file");
    }
}

