/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.springframework.security;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.AuthenticationException;
import org.springframework.security.ui.AuthenticationEntryPoint;
import org.springframework.security.ui.savedrequest.SavedRequest;
import org.springframework.security.util.AntUrlPathMatcher;
import org.springframework.security.util.PortResolver;
import org.springframework.security.util.PortResolverImpl;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntPatternBasedAuthenticationEntryPointChain
implements AuthenticationEntryPoint,
InitializingBean {
    private List<String> m_patterns;
    private AuthenticationEntryPoint m_matchingEntryPoint;
    private AuthenticationEntryPoint m_nonMatchingEntryPoint;
    private AntUrlPathMatcher m_urlPathMatcher = new AntUrlPathMatcher();

    public void setPatterns(List<String> patterns) {
        this.m_patterns = patterns;
    }

    public void setMatchingEntryPoint(AuthenticationEntryPoint matchedEntryPoint) {
        this.m_matchingEntryPoint = matchedEntryPoint;
    }

    public void setNonMatchingEntryPoint(AuthenticationEntryPoint unmatchedEntryPoint) {
        this.m_nonMatchingEntryPoint = unmatchedEntryPoint;
    }

    public void setRequiresLowerCaseUrl(boolean requiresLowerCaseUrl) {
        this.m_urlPathMatcher.setRequiresLowerCaseUrl(requiresLowerCaseUrl);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_nonMatchingEntryPoint, (String)"nonMatchingEntryPoint may not be null");
        Assert.notNull((Object)this.m_matchingEntryPoint, (String)"matchingEntryPoint may not be null");
        Assert.notNull(this.m_patterns, (String)"patterns may not be null");
    }

    public void commence(ServletRequest request, ServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        String url = this.getUrl(request);
        AuthenticationEntryPoint entryPoint = this.getAppropriateEntryPoint(url);
        entryPoint.commence(request, response, authException);
    }

    private AuthenticationEntryPoint getAppropriateEntryPoint(String url) {
        for (String pattern : this.m_patterns) {
            if (!this.m_urlPathMatcher.pathMatchesUrl(this.m_urlPathMatcher.compile(pattern), url)) continue;
            return this.m_matchingEntryPoint;
        }
        return this.m_nonMatchingEntryPoint;
    }

    private String getUrl(ServletRequest request) {
        return this.getSavedRequest(request).getRequestUrl();
    }

    private SavedRequest getSavedRequest(ServletRequest request) {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpSession httpSession = httpRequest.getSession(false);
        if (httpSession == null) {
            return new SavedRequest(httpRequest, (PortResolver)new PortResolverImpl());
        }
        return (SavedRequest)httpSession.getAttribute("SPRING_SECURITY_SAVED_REQUEST_KEY");
    }
}

