/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.springframework.security;

import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.config.UserManager;
import org.opennms.netmgt.model.OnmsUser;
import org.opennms.web.springframework.security.OnmsAuthenticationToken;
import org.opennms.web.springframework.security.SpringSecurityUserDao;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.Assert;

public class HybridOpenNMSUserAuthenticationProvider
implements AuthenticationProvider,
InitializingBean {
    private UserManager m_userManager = null;
    private SpringSecurityUserDao m_userDao = null;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_userManager);
        Assert.notNull((Object)this.m_userDao);
    }

    public UserManager getUserManager() {
        return this.m_userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.m_userManager = userManager;
    }

    public SpringSecurityUserDao getUserDao() {
        return this.m_userDao;
    }

    public void setUserDao(SpringSecurityUserDao userDao) {
        this.m_userDao = userDao;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String authUsername = authentication.getPrincipal().toString();
        String authPassword = authentication.getCredentials().toString();
        OnmsUser user = this.m_userDao.getByUsername(authUsername);
        if (user == null) {
            throw new BadCredentialsException("Bad credentials");
        }
        try {
            this.checkUserPassword(authUsername, authPassword, user);
        }
        catch (AuthenticationException e) {
            try {
                this.m_userManager.reload();
            }
            catch (Exception reloadException) {
                LogUtils.debugf((Object)this, (Throwable)reloadException, (String)"Failed to reload UserManager.", (Object[])new Object[0]);
            }
            this.checkUserPassword(authUsername, authPassword, user);
        }
        if (user.getAuthorities().size() == 0) {
            user.addAuthority(SpringSecurityUserDao.ROLE_USER);
        }
        return new OnmsAuthenticationToken(user);
    }

    protected void checkUserPassword(String authUsername, String authPassword, OnmsUser user) throws AuthenticationException {
        String existingPassword = user.getPassword();
        boolean hasUser = false;
        try {
            hasUser = this.m_userManager.hasUser(user.getUsername());
        }
        catch (Exception e) {
            throw new AuthenticationServiceException("An error occurred while checking for " + authUsername + " in the UserManager", (Throwable)e);
        }
        if (hasUser ? !this.m_userManager.comparePasswords(authUsername, authPassword) : !this.m_userManager.checkSaltedPassword(authPassword, existingPassword)) {
            throw new BadCredentialsException("Bad credentials");
        }
    }

    public boolean supports(Class<?> authentication) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

