/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.springframework.security;

import java.io.IOException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.opennms.netmgt.config.GroupDao;
import org.opennms.netmgt.config.groups.Group;
import org.opennms.netmgt.model.FilterManager;
import org.opennms.web.springframework.security.AclUtils;
import org.springframework.security.core.context.SecurityContextHolder;

public class AuthFilterEnabler
implements Filter {
    private FilterManager m_filterManager;
    private GroupDao m_groupDao;

    public void setFilterManager(FilterManager filterManager) {
        this.m_filterManager = filterManager;
    }

    public void setGroupDao(GroupDao groupDao) {
        this.m_groupDao = groupDao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean shouldFilter = AclUtils.shouldFilter(SecurityContextHolder.getContext().getAuthentication().getAuthorities());
        try {
            if (shouldFilter) {
                String user = SecurityContextHolder.getContext().getAuthentication().getName();
                List groups = this.m_groupDao.findGroupsForUser(user);
                String[] groupNames = new String[groups.size()];
                for (int i = 0; i < groups.size(); ++i) {
                    groupNames[i] = ((Group)groups.get(i)).getName();
                }
                this.m_filterManager.enableAuthorizationFilter(groupNames);
            }
            chain.doFilter(request, response);
        }
        finally {
            if (shouldFilter) {
                this.m_filterManager.disableAuthorizationFilter();
            }
        }
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }
}

