/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.springframework.security;

import org.opennms.netmgt.model.OnmsUser;
import org.opennms.web.springframework.security.SpringSecurityUserDao;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.Assert;

public class OpenNMSUserDetailsService
implements UserDetailsService,
InitializingBean {
    private SpringSecurityUserDao m_userDao;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_userDao);
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        OnmsUser userDetails = this.m_userDao.getByUsername(username);
        if (userDetails == null) {
            throw new UsernameNotFoundException("Unable to locate " + username + " in the userDao");
        }
        return userDetails;
    }

    public void setUserDao(SpringSecurityUserDao userDao) {
        this.m_userDao = userDao;
    }

    public SpringSecurityUserDao getUserDao() {
        return this.m_userDao;
    }
}

