/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import org.opennms.netmgt.dao.NodeDao;
import org.springframework.security.util.AuthorityUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class AclUtils {
    public static boolean shouldFilter() {
        return System.getProperty("org.opennms.web.aclsEnabled", "false").equalsIgnoreCase("true") && !AuthorityUtils.userHasAuthority((String)"ROLE_ADMIN");
    }

    public static NodeAccessChecker getNodeAccessChecker(ServletContext sc) {
        if (!AclUtils.shouldFilter()) {
            return new NonFilteringNodeAccessChecker();
        }
        WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)sc);
        NodeDao dao = (NodeDao)ctx.getBean("nodeDao", NodeDao.class);
        return new SetBasedNodeAccessChecker(dao.getNodeIds());
    }

    private static class SetBasedNodeAccessChecker
    implements NodeAccessChecker {
        private Set<Integer> m_nodeIds;

        public SetBasedNodeAccessChecker(Collection<Integer> nodeIds) {
            this.m_nodeIds = nodeIds == null ? Collections.emptySet() : new HashSet<Integer>(nodeIds);
        }

        @Override
        public boolean isNodeAccessible(int nodeId) {
            return this.m_nodeIds.contains(nodeId);
        }
    }

    private static class NonFilteringNodeAccessChecker
    implements NodeAccessChecker {
        private NonFilteringNodeAccessChecker() {
        }

        @Override
        public boolean isNodeAccessible(int nodeId) {
            return true;
        }
    }

    public static interface NodeAccessChecker {
        public boolean isNodeAccessible(int var1);
    }
}

