/* SocketOpts.java

   COPYRIGHT 2008 KRUPCZAK.ORG, LLC.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
   USA
 
   For more information, visit:
   http://www.krupczak.org/
*/

package org.krupczak.Xmp;

import java.net.*;
import javax.net.*;
import javax.net.ssl.*;
import java.security.KeyStore;

/** 
 *  Encapsulate Socket, SSL, communication options, parameters, etc.
 *  @version $Id: SocketOpts.java 15 2008-07-17 14:20:37Z rdk $
 *  @see XmpSession
 *  @see XmpMessage
 *  @see Xmp
 **/

public class SocketOpts {

   /* class variables and methods *********************** */

   /* instance variables ******************************** */
   public SSLContext sslContext;
   public SocketFactory sslSocketFactory;
   public SocketFactory socketFactory;
   public boolean keystoreFound;

   /* constructors  ************************************* */
   public SocketOpts() 
   { 

     // initialize SSL parameters and context
     // the trust store should be per-context rather than
     // the entire java vm which could break other things
     // if we provide a JAR file for use within a larger
     // software package

     ClassLoader cl;
     java.io.InputStream kis = null;
     KeyStore ks;
     char[] password = {'c','a','r','t','o','g','r','a','p','h','e','r'}; 
     TrustManager tm[];

     cl = getClass().getClassLoader();

     try {

       // load up our Cartographer keystore for evaluating
       // our certs and create a Trust manager
       ks = KeyStore.getInstance("jks");
       
       if (cl != null) {
          kis = cl.getResourceAsStream("org/krupczak/Xmp/Cartographer.keystore");
          if (kis == null)
             kis = ClassLoader.getSystemResourceAsStream("org/krupczak/Xmp/Cartographer.keystore");
       }
       else {
          kis = ClassLoader.getSystemResourceAsStream("org/krupczak/Xmp/Cartographer.keystore");
       }

       // if we dont pull it out of our JAR, try it in some well-known
       // locations
       //if (kis == null) {
       //   kis = new java.io.FileInputStream("etc/Cartographer.keystore");
       //}

       ks.load(kis,password);
       if (kis != null) {
          kis.close();
       }
       else {
	   System.out.println("Unable to find keystore");
       }

       //java.io.FileInputStream fis = new java.io.FileInputStream("Cartographer.keystore");
       //ks.load(fis,password);
       //fis.close();

       TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
       tmf.init(ks);
       tm = tmf.getTrustManagers();
       keystoreFound = true;

     } catch (Exception e) {
        ks = null;
        tm = null;
        System.out.println("SocketOpts: Could not allocate trust manager keystore");
        System.out.println("SocketOpts: Exception "+e.getMessage());
        e.printStackTrace();

        System.setProperty("javax.net.ssl.trustStore","Cartographer.keystore");
        System.setProperty("javax.net.ssl.trustStorePassword","cartographer");
        System.setProperty("javax.net.debug","ssl");
        keystoreFound = false;
     }

     try {
	 sslContext = SSLContext.getInstance("SSLv3");
         sslContext.init(null,tm,null);
         sslSocketFactory = sslContext.getSocketFactory();

     } catch (Exception e) {
         sslSocketFactory = SSLSocketFactory.getDefault(); 
     }

     socketFactory = SocketFactory.getDefault();

     return; 
   }

   /* private methods *********************************** */

   /* public methods ************************************ */

   // did we correctly find our keystore and load it up? 
   public boolean getKeystoreFound() { return keystoreFound; }

} /* class SocketOpts */
