/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.graph.immutables;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opennms.integration.api.v1.graph.NodeRef;
import org.opennms.integration.api.v1.graph.Vertex;
import org.opennms.integration.api.v1.graph.immutables.ImmutableElement;
import org.opennms.integration.api.v1.graph.immutables.ImmutableNodeRef;

public final class ImmutableVertex
extends ImmutableElement
implements Vertex {
    private ImmutableVertex(Map<String, Object> properties) {
        super(properties);
        Objects.requireNonNull(this.getId(), "id cannot be null");
        Objects.requireNonNull(this.getNamespace(), "namespace cannot be null");
    }

    public String getNamespace() {
        return (String)this.getProperty("namespace");
    }

    public String getId() {
        return (String)this.getProperty("id");
    }

    public Optional<NodeRef> getNodeRef() {
        String foreignSource = (String)this.getProperty("foreignSource");
        String foreignId = (String)this.getProperty("foreignID");
        if (foreignSource != null && foreignId != null) {
            return Optional.of(ImmutableNodeRef.newBuilder(foreignSource, foreignId).build());
        }
        return Optional.empty();
    }

    @Override
    public String toString() {
        return "ImmutableVertex{properties=" + this.properties + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder newBuilder(String namespace, String id) {
        return new Builder().namespace(namespace).id(id);
    }

    public static Builder newBuilderFrom(Vertex fromVertex) {
        return (Builder)new Builder().properties(fromVertex.getProperties());
    }

    public static Vertex immutableCopy(Vertex vertex) {
        if (vertex == null || vertex instanceof ImmutableVertex) {
            return vertex;
        }
        return ImmutableVertex.newBuilderFrom(vertex).build();
    }

    public static final class Builder
    extends ImmutableElement.AbstractBuilder<Builder> {
        private Builder() {
        }

        public Builder namespace(String namespace) {
            Objects.requireNonNull(namespace, "namespace cannot be null.");
            this.property("namespace", namespace);
            return this;
        }

        public Builder id(String id) {
            this.property("id", id);
            return this;
        }

        public Builder label(String label) {
            this.property("label", label);
            return this;
        }

        public Builder nodeRef(String foreignSource, String foreignId) {
            this.property("foreignSource", foreignSource);
            this.property("foreignID", foreignId);
            return this;
        }

        public Builder iconId(String iconId) {
            this.property("iconKey", iconId);
            return this;
        }

        public ImmutableVertex build() {
            return new ImmutableVertex(this.properties);
        }
    }
}

