/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.graph.immutables;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.integration.api.v1.graph.Edge;
import org.opennms.integration.api.v1.graph.Graph;
import org.opennms.integration.api.v1.graph.GraphInfo;
import org.opennms.integration.api.v1.graph.Vertex;
import org.opennms.integration.api.v1.graph.VertexRef;
import org.opennms.integration.api.v1.graph.immutables.ImmutableEdge;
import org.opennms.integration.api.v1.graph.immutables.ImmutableElement;
import org.opennms.integration.api.v1.graph.immutables.ImmutableVertex;
import org.opennms.integration.api.v1.graph.immutables.ImmutableVertexRef;
import org.opennms.integration.api.v1.util.ImmutableCollections;

public final class ImmutableGraph
extends ImmutableElement
implements Graph {
    private final Map<String, Vertex> vertexToIdMap;
    private final Map<String, Edge> edgeToIdMap;
    private final List<VertexRef> defaultFocus;

    private ImmutableGraph(Builder builder) {
        super(builder.properties);
        this.defaultFocus = ImmutableCollections.with(ImmutableVertexRef::immutableCopy).newList(builder.defaultFocus);
        this.vertexToIdMap = builder.vertexToIdMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ImmutableVertex.immutableCopy((Vertex)entry.getValue())));
        this.edgeToIdMap = builder.edgeToIdMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ImmutableEdge.immutableCopy((Edge)entry.getValue())));
    }

    public String getNamespace() {
        return (String)this.getProperty("namespace");
    }

    public String getLabel() {
        return (String)this.getProperty("label");
    }

    public String getDescription() {
        return (String)this.getProperty("description");
    }

    public List<Vertex> getVertices() {
        return new ArrayList<Vertex>(this.vertexToIdMap.values());
    }

    public List<Edge> getEdges() {
        return new ArrayList<Edge>(this.edgeToIdMap.values());
    }

    public Vertex getVertex(String id) {
        return this.vertexToIdMap.get(id);
    }

    public Edge getEdge(String id) {
        return this.edgeToIdMap.get(id);
    }

    public List<VertexRef> getDefaultFocus() {
        return this.defaultFocus;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImmutableGraph that = (ImmutableGraph)o;
        return Objects.equals(this.vertexToIdMap, that.vertexToIdMap) && Objects.equals(this.edgeToIdMap, that.edgeToIdMap) && Objects.equals(this.defaultFocus, that.defaultFocus);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.vertexToIdMap, this.edgeToIdMap, this.defaultFocus);
    }

    @Override
    public String toString() {
        return "ImmutableGraph{vertexToIdMap=" + this.vertexToIdMap + ", edgeToIdMap=" + this.edgeToIdMap + ", defaultFocus=" + this.defaultFocus + ", properties=" + this.properties + '}';
    }

    public static Builder newBuilder(GraphInfo graphInfo) {
        return new Builder(graphInfo);
    }

    public static Builder newBuilderFrom(Graph graph) {
        Objects.requireNonNull(graph);
        return new Builder().graph(graph);
    }

    public static Graph immutableCopy(Graph graph) {
        if (graph == null || graph instanceof ImmutableGraph) {
            return graph;
        }
        return ImmutableGraph.newBuilderFrom(graph).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends ImmutableElement.AbstractBuilder<Builder> {
        private final Map<String, Vertex> vertexToIdMap = new HashMap<String, Vertex>();
        private final Map<String, Edge> edgeToIdMap = new HashMap<String, Edge>();
        private final List<VertexRef> defaultFocus = new ArrayList<VertexRef>();

        private Builder() {
        }

        private Builder(GraphInfo graphInfo) {
            this.graphInfo(graphInfo);
        }

        public Builder graph(Graph graph) {
            this.properties(graph.getProperties());
            this.addVertices(graph.getVertices());
            this.addEdges(graph.getEdges());
            this.defaultFocus(graph.getDefaultFocus());
            return this;
        }

        public Builder label(String label) {
            this.property("label", label);
            return this;
        }

        public Builder description(String description) {
            this.property("description", description);
            return this;
        }

        public Builder graphInfo(GraphInfo graphInfo) {
            this.namespace(graphInfo.getNamespace());
            this.description(graphInfo.getDescription());
            this.label(graphInfo.getLabel());
            return this;
        }

        public Builder defaultFocus(VertexRef ... vertexRefs) {
            if (vertexRefs != null) {
                for (VertexRef eachVertexRef : vertexRefs) {
                    this.defaultFocus(eachVertexRef);
                }
            }
            return this;
        }

        public Builder defaultFocus(VertexRef vertexRef) {
            if (vertexRef != null && !this.defaultFocus.contains(vertexRef)) {
                this.defaultFocus.add(vertexRef);
            }
            return this;
        }

        public Builder defaultFocus(List<VertexRef> vertexRefList) {
            Objects.requireNonNull(vertexRefList);
            for (VertexRef eachVertexRef : vertexRefList) {
                this.defaultFocus(eachVertexRef);
            }
            return this;
        }

        public Builder addEdges(Collection<Edge> edges) {
            for (Edge eachEdge : edges) {
                this.addEdge(eachEdge);
            }
            return this;
        }

        public Builder addVertices(Collection<Vertex> vertices) {
            for (Vertex eachVertex : vertices) {
                this.addVertex(eachVertex);
            }
            return this;
        }

        public Builder addVertex(Vertex vertex) {
            Objects.requireNonNull(this.getNamespace(), "Please set a namespace before adding elements to this graph.");
            Objects.requireNonNull(vertex, "GenericVertex can not be null");
            if (this.vertexToIdMap.containsKey(vertex.getId())) {
                return this;
            }
            this.vertexToIdMap.put(vertex.getId(), vertex);
            return this;
        }

        public Builder addEdge(Edge edge) {
            Objects.requireNonNull(this.getNamespace(), "Please set a namespace before adding elements to this graph.");
            Objects.requireNonNull(edge, "GenericEdge cannot be null");
            if (this.edgeToIdMap.containsKey(edge.getId())) {
                return this;
            }
            this.edgeToIdMap.put(edge.getId(), edge);
            return this;
        }

        public ImmutableVertex.Builder vertex(String id) {
            return ImmutableVertex.newBuilder(this.getNamespace(), id);
        }

        public ImmutableEdge.Builder edge(String id, VertexRef source, VertexRef target) {
            return ImmutableEdge.newBuilder(this.getNamespace(), id, source, target);
        }

        public void removeEdge(Edge edge) {
            Objects.requireNonNull(edge);
            this.edgeToIdMap.remove(edge.getId());
        }

        public void removeVertex(Vertex vertex) {
            Objects.requireNonNull(vertex);
            this.vertexToIdMap.remove(vertex.getId());
        }

        public String getNamespace() {
            return Objects.requireNonNull((String)this.properties.get("namespace"), "Namespace is not set yet. Please call namespace(...) first.");
        }

        public Vertex getVertex(String id) {
            return this.vertexToIdMap.get(id);
        }

        public Builder namespace(String namespace) {
            this.checkIfNamespaceChangeIsAllowed(namespace);
            return this.property("namespace", namespace);
        }

        @Override
        public Builder property(String name, Object value) {
            if ("namespace".equals(name)) {
                this.checkIfNamespaceChangeIsAllowed((String)value);
            }
            return (Builder)super.property(name, value);
        }

        @Override
        public Builder properties(Map<String, Object> properties) {
            if (properties != null && properties.containsKey("namespace")) {
                this.checkIfNamespaceChangeIsAllowed((String)properties.get("namespace"));
            }
            return (Builder)super.properties(properties);
        }

        private void checkIfNamespaceChangeIsAllowed(String newNamespace) {
            if (!(this.vertexToIdMap.isEmpty() || this.edgeToIdMap.isEmpty() || Objects.equals(this.getNamespace(), newNamespace))) {
                throw new IllegalStateException("Cannot change namespace after adding Elements to Graph.");
            }
        }

        public List<Vertex> getVertices() {
            return Collections.unmodifiableList(new ArrayList<Vertex>(this.vertexToIdMap.values()));
        }

        public ImmutableGraph build() {
            return new ImmutableGraph(this);
        }
    }
}

