/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.graph.status;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.opennms.features.apilayer.utils.InterfaceMapper;
import org.opennms.features.apilayer.utils.ModelMappers;
import org.opennms.features.topology.api.topo.AbstractEdgeRef;
import org.opennms.features.topology.api.topo.BackendGraph;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.DefaultStatus;
import org.opennms.features.topology.api.topo.EdgeRef;
import org.opennms.features.topology.api.topo.EdgeStatusProvider;
import org.opennms.features.topology.api.topo.Status;
import org.opennms.integration.api.v1.graph.Edge;
import org.opennms.integration.api.v1.graph.VertexRef;
import org.opennms.integration.api.v1.graph.immutables.ImmutableEdge;
import org.opennms.integration.api.v1.graph.immutables.ImmutableVertexRef;
import org.opennms.integration.api.v1.graph.status.LegacyStatusProvider;
import org.opennms.integration.api.v1.graph.status.StatusInfo;
import org.opennms.netmgt.graph.provider.topology.LegacyEdge;
import org.opennms.netmgt.model.OnmsSeverity;
import org.osgi.framework.BundleContext;

public class LegacyEdgeStatusProviderManager
extends InterfaceMapper<LegacyStatusProvider, EdgeStatusProvider> {
    public LegacyEdgeStatusProviderManager(BundleContext bundleContext) {
        super(EdgeStatusProvider.class, bundleContext);
    }

    @Override
    public EdgeStatusProvider map(final LegacyStatusProvider extension) {
        return new EdgeStatusProvider(){

            public String getNamespace() {
                return null;
            }

            public boolean contributesTo(String namespace) {
                return extension.canCalculate(namespace);
            }

            public Map<? extends EdgeRef, ? extends Status> getStatusForEdges(BackendGraph graph, Collection<EdgeRef> edges, Criteria[] criteria) {
                HashMap statusMap = new HashMap();
                edges.forEach(edgeRef -> {
                    AbstractEdgeRef actualEdgeRef = new AbstractEdgeRef(edgeRef);
                    org.opennms.features.topology.api.topo.Edge edge = graph.getEdge((EdgeRef)actualEdgeRef);
                    if (edge instanceof LegacyEdge) {
                        LegacyEdge legacyEdge = (LegacyEdge)edge;
                        org.opennms.features.topology.api.topo.VertexRef sourceVertex = legacyEdge.getSource().getVertex();
                        org.opennms.features.topology.api.topo.VertexRef targetVertex = legacyEdge.getTarget().getVertex();
                        ImmutableEdge apiEdge = ((ImmutableEdge.Builder)ImmutableEdge.newBuilder((String)legacyEdge.getNamespace(), (String)legacyEdge.getId(), (VertexRef)ImmutableVertexRef.newBuilder((String)sourceVertex.getNamespace(), (String)sourceVertex.getId()).build(), (VertexRef)ImmutableVertexRef.newBuilder((String)targetVertex.getNamespace(), (String)targetVertex.getId()).build()).properties(legacyEdge.getProperties())).build();
                        StatusInfo apiStatus = extension.calculateStatus((Edge)apiEdge);
                        Status status = LegacyEdgeStatusProviderManager.convert(apiStatus);
                        statusMap.put(edgeRef, status);
                    } else {
                        statusMap.put(edgeRef, new DefaultStatus(OnmsSeverity.INDETERMINATE.getLabel(), 0L));
                    }
                });
                return statusMap;
            }
        };
    }

    public static Status convert(StatusInfo apiStatus) {
        if (apiStatus == null) {
            return new DefaultStatus(OnmsSeverity.NORMAL.getLabel(), 0L);
        }
        OnmsSeverity onmsSeverity = ModelMappers.fromSeverity(apiStatus.getSeverity());
        return new DefaultStatus(onmsSeverity.getLabel(), apiStatus.getCount());
    }
}

