/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.util.Date;
import java.util.HashMap;
import org.opennms.netmgt.config.threshd.ThresholdType;
import org.opennms.netmgt.threshd.AbstractThresholdEvaluatorState;
import org.opennms.netmgt.threshd.BaseThresholdDefConfigWrapper;
import org.opennms.netmgt.threshd.CollectionResourceWrapper;
import org.opennms.netmgt.threshd.ThresholdEvaluator;
import org.opennms.netmgt.threshd.ThresholdEvaluatorState;
import org.opennms.netmgt.threshd.api.ThresholdingSession;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ThresholdEvaluatorRearmingAbsoluteChange
implements ThresholdEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(ThresholdEvaluatorRearmingAbsoluteChange.class);
    private static final ThresholdType TYPE = ThresholdType.REARMING_ABSOLUTE_CHANGE;

    @Override
    public ThresholdEvaluatorState getThresholdEvaluatorState(BaseThresholdDefConfigWrapper threshold, ThresholdingSession thresholdingSession) {
        return new ThresholdEvaluatorStateRearmingAbsoluteChange(threshold, thresholdingSession);
    }

    @Override
    public boolean supportsType(ThresholdType type) {
        return TYPE.equals((Object)type);
    }

    public static class ThresholdEvaluatorStateRearmingAbsoluteChange
    extends AbstractThresholdEvaluatorState<State> {
        private BaseThresholdDefConfigWrapper m_thresholdConfig;

        public ThresholdEvaluatorStateRearmingAbsoluteChange(BaseThresholdDefConfigWrapper threshold, ThresholdingSession thresholdingSession) {
            super(threshold, thresholdingSession, State.class);
            this.setThresholdConfig(threshold);
        }

        @Override
        protected void initializeState() {
            this.state = new State();
        }

        public String getType() {
            return this.getThresholdConfig().getType().toString();
        }

        private void setThresholdConfig(BaseThresholdDefConfigWrapper thresholdConfig) {
            Assert.notNull((Object)thresholdConfig.getType(), (String)"threshold must have a 'type' value set");
            Assert.notNull((Object)thresholdConfig.getDatasourceExpression(), (String)"threshold must have a 'ds-name' value set");
            Assert.notNull((Object)thresholdConfig.getDsType(), (String)"threshold must have a 'ds-type' value set");
            Assert.isTrue((boolean)thresholdConfig.hasValue(), (String)"threshold must have a 'value' value set");
            Assert.isTrue((boolean)thresholdConfig.hasRearm(), (String)"threshold must have a 'rearm' value set");
            Assert.isTrue((boolean)thresholdConfig.hasTrigger(), (String)"threshold must have a 'trigger' value set");
            Assert.isTrue((boolean)TYPE.equals((Object)thresholdConfig.getType()), (String)("threshold for ds-name '" + thresholdConfig.getDatasourceExpression() + "' has type of '" + thresholdConfig.getType() + "', but this evaluator only supports thresholds with a 'type' value of '" + TYPE + "'"));
            Assert.isTrue((!Double.isNaN(thresholdConfig.getValue()) ? 1 : 0) != 0, (String)"threshold must have a 'value' value that is a number");
            Assert.isTrue((thresholdConfig.getValue() != Double.POSITIVE_INFINITY && thresholdConfig.getValue() != Double.NEGATIVE_INFINITY ? 1 : 0) != 0, (String)"threshold must have a 'value' value that is not positive or negative infinity");
            this.m_thresholdConfig = thresholdConfig;
        }

        @Override
        public BaseThresholdDefConfigWrapper getThresholdConfig() {
            return this.m_thresholdConfig;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ThresholdEvaluatorState.Status evaluateAfterFetch(double dsValue) {
            try {
                if (!Double.valueOf(this.getPreviousTriggeringSample()).isNaN()) {
                    this.setTriggerCount(this.getTriggerCount() + 1);
                    if (!this.wasTriggered(dsValue) && this.getTriggerCount() >= this.getThresholdConfig().getTrigger()) {
                        this.setPreviousTriggeringSample(Double.NaN);
                        this.setTriggerCount(0);
                        LOG.debug("{} threshold rearmed, sample value={}", (Object)TYPE, (Object)dsValue);
                        ThresholdEvaluatorState.Status status = ThresholdEvaluatorState.Status.RE_ARMED;
                        return status;
                    }
                } else if (this.wasTriggered(dsValue)) {
                    this.setPreviousTriggeringSample(this.getLastSample());
                    this.setTriggerCount(0);
                    LOG.debug("{} threshold triggered, sample value={}", (Object)TYPE, (Object)dsValue);
                    ThresholdEvaluatorState.Status status = ThresholdEvaluatorState.Status.TRIGGERED;
                    return status;
                }
            }
            finally {
                this.setLastSample(dsValue);
            }
            return ThresholdEvaluatorState.Status.NO_CHANGE;
        }

        private boolean wasTriggered(double dsValue) {
            if (Double.valueOf(dsValue).isNaN()) {
                return false;
            }
            if (this.getLastSample().isNaN()) {
                return false;
            }
            double threshold = Math.abs(this.getLastSample() - dsValue);
            return threshold >= this.getThresholdConfig().getValue();
        }

        private Double getLastSample() {
            return ((State)this.state).m_lastSample;
        }

        private void setLastSample(double lastSample) {
            if (((State)this.state).m_lastSample != lastSample) {
                ((State)this.state).m_lastSample = lastSample;
                this.markDirty();
            }
        }

        @Override
        public Event getEventForState(ThresholdEvaluatorState.Status status, Date date, double dsValue, CollectionResourceWrapper resource) {
            if (status == ThresholdEvaluatorState.Status.TRIGGERED) {
                String uei = this.getThresholdConfig().getTriggeredUEI().orElse("uei.opennms.org/threshold/rearmingAbsoluteChangeExceeded");
                return this.createBasicEvent(uei, date, dsValue, resource);
            }
            if (status == ThresholdEvaluatorState.Status.RE_ARMED) {
                String uei = this.getThresholdConfig().getRearmedUEI().orElse("uei.opennms.org/threshold/rearmingAbsoluteChangeRearmed");
                return this.createBasicEvent(uei, date, dsValue, resource);
            }
            return null;
        }

        private Event createBasicEvent(String uei, Date date, double dsValue, CollectionResourceWrapper resource) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("previousValue", this.formatValue(this.getPreviousTriggeringSample()));
            params.put("threshold", Double.toString(this.getThresholdConfig().getValue()));
            params.put("trigger", Integer.toString(this.getThresholdConfig().getTrigger()));
            return this.createBasicEvent(uei, date, dsValue, resource, params);
        }

        private double getPreviousTriggeringSample() {
            return ((State)this.state).m_previousTriggeringSample;
        }

        private void setPreviousTriggeringSample(double previousTriggeringSample) {
            if (((State)this.state).m_previousTriggeringSample != previousTriggeringSample) {
                ((State)this.state).m_previousTriggeringSample = previousTriggeringSample;
                this.markDirty();
            }
        }

        private int getTriggerCount() {
            return ((State)this.state).m_triggerCount;
        }

        private void setTriggerCount(int triggerCount) {
            if (((State)this.state).m_triggerCount != triggerCount) {
                ((State)this.state).m_triggerCount = triggerCount;
                this.markDirty();
            }
        }

        @Override
        public ThresholdEvaluatorState getCleanClone() {
            return new ThresholdEvaluatorStateRearmingAbsoluteChange(this.m_thresholdConfig, this.getThresholdingSession());
        }

        @Override
        public boolean isTriggered() {
            return this.wasTriggered(((State)this.state).m_previousTriggeringSample);
        }

        @Override
        public void clearStateBeforePersist() {
            this.setLastSample(Double.NaN);
            this.setTriggerCount(0);
            this.setPreviousTriggeringSample(Double.NaN);
        }

        static class State
        extends AbstractThresholdEvaluatorState.AbstractState {
            private static final long serialVersionUID = 1L;
            private double m_lastSample = Double.NaN;
            private double m_previousTriggeringSample = Double.NaN;
            private int m_triggerCount = 0;

            State() {
            }

            @Override
            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("lastSample=").append(this.m_lastSample);
                sb.append("\npreviousTriggeringSample=").append(this.m_previousTriggeringSample);
                sb.append("\ntriggerCount=").append(this.m_triggerCount);
                String superString = super.toString();
                if (superString != null) {
                    sb.append("\n").append(superString);
                }
                return sb.toString();
            }
        }
    }
}

