/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.opennms.core.collections.LazySet;
import org.opennms.core.utils.AlphaNumeric;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.SIUtils;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.dao.support.DomainResourceType;
import org.opennms.netmgt.dao.support.LazyResourceAttributeLoader;
import org.opennms.netmgt.dao.support.NodeResourceType;
import org.opennms.netmgt.model.ExternalValueAttribute;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.OnmsEntity;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.model.ResourceTypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.ObjectRetrievalFailureException;

public class InterfaceSnmpResourceType
implements OnmsResourceType {
    private static final Logger LOG = LoggerFactory.getLogger(InterfaceSnmpResourceType.class);
    private final ResourceStorageDao m_resourceStorageDao;

    public InterfaceSnmpResourceType(ResourceStorageDao resourceStorageDao) {
        this.m_resourceStorageDao = resourceStorageDao;
    }

    public String getName() {
        return "interfaceSnmp";
    }

    public String getLabel() {
        return "SNMP Interface Data";
    }

    public String getLinkForResource(OnmsResource resource) {
        return null;
    }

    public boolean isResourceTypeOnParent(OnmsResource parent) {
        return this.m_resourceStorageDao.exists(parent.getPath(), 1);
    }

    public List<OnmsResource> getResourcesForParent(OnmsResource parent) {
        Set<String> ifaces = this.getQueryableInterfaces(parent);
        if (NodeResourceType.isNode(parent)) {
            OnmsNode node = ResourceTypeUtils.getNodeFromResource((OnmsResource)parent);
            return this.getNodeResources(parent.getPath(), ifaces, node);
        }
        if (DomainResourceType.isDomain(parent)) {
            return this.getDomainResources(parent.getPath(), ifaces);
        }
        return Collections.emptyList();
    }

    public OnmsResource getChildByName(OnmsResource parent, String name) {
        if (DomainResourceType.isDomain(parent)) {
            for (OnmsResource resource : this.getResourcesForParent(parent)) {
                if (!resource.getName().equals(name)) continue;
                return resource;
            }
            throw new ObjectRetrievalFailureException(OnmsResource.class, (Object)("No child with name '" + name + "' found on '" + parent + "'"));
        }
        OnmsNode node = ResourceTypeUtils.getNodeFromResource((OnmsResource)parent);
        ResourcePath resourcePath = new ResourcePath(parent.getPath(), new String[]{name});
        if (!this.m_resourceStorageDao.exists(resourcePath, 0)) {
            throw new ObjectRetrievalFailureException(OnmsResource.class, (Object)("No resource with name '" + name + "' found."));
        }
        List<OnmsResource> resources = this.getNodeResources(parent.getPath(), Sets.newHashSet((Object[])new String[]{name}), node);
        if (resources.size() != 1) {
            throw new ObjectRetrievalFailureException(OnmsResource.class, (Object)("No resource with name '" + name + "' found."));
        }
        OnmsResource resource = resources.get(0);
        resource.setParent(parent);
        return resource;
    }

    protected static String[] getKeysFor(OnmsSnmpInterface snmpInterface) {
        if (snmpInterface.getIfDescr() != null && Pattern.matches(".*-cef.*", snmpInterface.getIfDescr())) {
            return new String[0];
        }
        String replacedIfName = AlphaNumeric.parseAndReplace((String)snmpInterface.getIfName(), (char)'_');
        String replacedIfDescr = AlphaNumeric.parseAndReplace((String)snmpInterface.getIfDescr(), (char)'_');
        return new String[]{replacedIfName, replacedIfDescr, replacedIfName + "-" + snmpInterface.getPhysAddr(), replacedIfDescr + "-" + snmpInterface.getPhysAddr()};
    }

    private static String getKeyFor(String intfName) {
        String desc = intfName;
        String mac = "";
        int dashIndex = intfName.lastIndexOf(45);
        if (dashIndex >= 0) {
            desc = intfName.substring(0, dashIndex);
            mac = intfName.substring(dashIndex + 1, intfName.length());
            return desc + "-" + mac;
        }
        return desc;
    }

    private List<OnmsResource> getNodeResources(ResourcePath parent, Set<String> intfNames, OnmsNode node) {
        ArrayList<OnmsResource> resources = new ArrayList<OnmsResource>();
        Set snmpInterfaces = node.getSnmpInterfaces();
        HashMap<String, OnmsSnmpInterface> intfMap = new HashMap<String, OnmsSnmpInterface>();
        for (OnmsSnmpInterface snmpInterface : snmpInterfaces) {
            for (String key : InterfaceSnmpResourceType.getKeysFor(snmpInterface)) {
                if (intfMap.containsKey(key)) continue;
                intfMap.put(key, snmpInterface);
            }
        }
        for (String intfName : intfNames) {
            String label;
            String key = InterfaceSnmpResourceType.getKeyFor(intfName);
            OnmsSnmpInterface snmpInterface = (OnmsSnmpInterface)intfMap.get(key);
            Long ifSpeed = null;
            String ifSpeedFriendly = null;
            if (snmpInterface == null) {
                label = intfName + " (*)";
            } else {
                StringBuilder descr = new StringBuilder();
                StringBuilder parenString = new StringBuilder();
                if (snmpInterface.getIfAlias() != null) {
                    parenString.append(snmpInterface.getIfAlias());
                }
                for (OnmsIpInterface ipif : snmpInterface.getIpInterfaces()) {
                    String ipaddr = InetAddressUtils.str((InetAddress)ipif.getIpAddress());
                    if ("0.0.0.0".equals(ipaddr)) continue;
                    if (parenString.length() > 0) {
                        parenString.append(", ");
                    }
                    parenString.append(ipaddr);
                }
                if (snmpInterface.getIfSpeed() != null && snmpInterface.getIfSpeed() != 0L) {
                    ifSpeed = snmpInterface.getIfSpeed();
                    ifSpeedFriendly = SIUtils.getHumanReadableIfSpeed((long)ifSpeed);
                    if (parenString.length() > 0) {
                        parenString.append(", ");
                    }
                    parenString.append(ifSpeedFriendly);
                }
                if (snmpInterface.getIfName() != null) {
                    descr.append(snmpInterface.getIfName());
                } else if (snmpInterface.getIfDescr() != null) {
                    descr.append(snmpInterface.getIfDescr());
                } else {
                    descr.append(intfName);
                }
                if (parenString.length() > 0) {
                    descr.append(" (");
                    descr.append((CharSequence)parenString);
                    descr.append(")");
                }
                label = descr.toString();
            }
            OnmsResource resource = this.getResourceByParentPathAndInterface(parent, intfName, label, snmpInterface);
            if (snmpInterface != null) {
                Set ipInterfaces = snmpInterface.getIpInterfaces();
                if (ipInterfaces.size() > 0) {
                    int id = ((OnmsIpInterface)ipInterfaces.iterator().next()).getId();
                    resource.setLink("element/interface.jsp?ipinterfaceid=" + id);
                } else {
                    int ifIndex = snmpInterface.getIfIndex();
                    if (ifIndex > -1) {
                        resource.setLink("element/snmpinterface.jsp?node=" + node.getNodeId() + "&ifindex=" + ifIndex);
                    }
                }
                resource.setEntity((OnmsEntity)snmpInterface);
            } else {
                LOG.debug("populateResourceList: snmpInterface is null");
            }
            LOG.debug("populateResourceList: adding resource toString {}", (Object)resource.toString());
            resources.add(resource);
        }
        return resources;
    }

    private List<OnmsResource> getDomainResources(ResourcePath parent, Set<String> intfNames) {
        LinkedList resources = Lists.newLinkedList();
        for (String intfName : intfNames) {
            OnmsResource resource = this.getResourceByParentPathAndInterface(parent, intfName);
            try {
                resource.setLink("element/nodeList.htm?listInterfaces=true&snmpParm=ifAlias&snmpParmMatchType=contains&snmpParmValue=" + URLEncoder.encode(intfName, StandardCharsets.UTF_8.name()));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("URLEncoder.encode complained about UTF-8. " + e, e);
            }
            resources.add(resource);
        }
        return resources;
    }

    protected Set<String> getQueryableInterfaces(OnmsResource parent) {
        if (!NodeResourceType.isNode(parent) && !DomainResourceType.isDomain(parent)) {
            return Collections.emptySet();
        }
        return this.m_resourceStorageDao.children(parent.getPath(), 1).stream().map(ResourcePath::getName).collect(Collectors.toSet());
    }

    private OnmsResource getResourceByParentPathAndInterface(ResourcePath parent, String intf) {
        ResourcePath path = ResourcePath.get((ResourcePath)parent, (String[])new String[]{intf});
        LazyResourceAttributeLoader loader = new LazyResourceAttributeLoader(this.m_resourceStorageDao, path);
        LazySet set = new LazySet((LazySet.Loader)loader);
        return new OnmsResource(intf, intf, (OnmsResourceType)this, (Set)set, path);
    }

    private OnmsResource getResourceByParentPathAndInterface(ResourcePath parent, String intf, String label, OnmsSnmpInterface snmpInterface) throws DataAccessException {
        ResourcePath path = ResourcePath.get((ResourcePath)parent, (String[])new String[]{intf});
        AttributeLoader loader = new AttributeLoader(this.m_resourceStorageDao, path, snmpInterface);
        LazySet set = new LazySet((LazySet.Loader)loader);
        return new OnmsResource(intf, label, (OnmsResourceType)this, (Set)set, path);
    }

    private static class AttributeLoader
    implements LazySet.Loader<OnmsAttribute> {
        private final ResourceStorageDao m_resourceStorageDao;
        private final ResourcePath m_path;
        private final OnmsSnmpInterface m_snmpInterface;

        public AttributeLoader(ResourceStorageDao resourceStorageDao, ResourcePath path, OnmsSnmpInterface snmpInterface) {
            this.m_resourceStorageDao = resourceStorageDao;
            this.m_path = path;
            this.m_snmpInterface = snmpInterface;
        }

        public Set<OnmsAttribute> load() {
            Set attributes = this.m_resourceStorageDao.getAttributes(this.m_path);
            if (this.m_snmpInterface != null) {
                attributes.add(new ExternalValueAttribute("nodeId", this.m_snmpInterface.getNodeId().toString()));
                attributes.add(new ExternalValueAttribute("ifIndex", this.m_snmpInterface.getIfIndex().toString()));
                attributes.add(new ExternalValueAttribute("hasFlows", String.valueOf(this.m_snmpInterface.getHasFlows())));
                attributes.add(new ExternalValueAttribute("hasIngressFlows", String.valueOf(this.m_snmpInterface.getHasIngressFlows())));
                attributes.add(new ExternalValueAttribute("hasEgressFlows", String.valueOf(this.m_snmpInterface.getHasEgressFlows())));
                if (this.m_snmpInterface.getIfSpeed() != null) {
                    String ifSpeedFriendly = SIUtils.getHumanReadableIfSpeed((long)this.m_snmpInterface.getIfSpeed());
                    attributes.add(new ExternalValueAttribute("ifSpeed", this.m_snmpInterface.getIfSpeed().toString()));
                    attributes.add(new ExternalValueAttribute("ifSpeedFriendly", ifSpeedFriendly));
                }
            }
            return attributes;
        }
    }
}

