/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.concurentlocks;

import com.googlecode.concurentlocks.Locks;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public class CompositeLock
implements Lock {
    final Deque<Lock> locks;

    public CompositeLock(Lock ... locks) {
        this(new LinkedList<Lock>(Arrays.asList(locks)));
    }

    public CompositeLock(Deque<Lock> locks) {
        this.locks = locks;
    }

    @Override
    public void lock() {
        Locks.lockAll(this.locks);
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        Locks.lockInterruptiblyAll(this.locks);
    }

    @Override
    public boolean tryLock() {
        return Locks.tryLockAll(this.locks);
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        return Locks.tryLockAll(time, unit, this.locks);
    }

    @Override
    public void unlock() {
        Locks.unlockAll(new Iterable<Lock>(){

            @Override
            public Iterator<Lock> iterator() {
                return CompositeLock.this.locks.descendingIterator();
            }
        });
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException("This lock does not support conditions");
    }
}

