/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote.metadata;

import java.awt.Color;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.opennms.netmgt.poller.remote.PollerTheme;
import org.opennms.netmgt.poller.remote.metadata.LinkedProperties;
import org.opennms.netmgt.poller.remote.metadata.MetadataField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataFieldReader {
    private static Logger LOG = LoggerFactory.getLogger(MetadataFieldReader.class);
    private File m_propertyFile;
    private static final Pattern HEX_COLOR = Pattern.compile("^\\s*(\\p{XDigit}\\p{XDigit})(\\p{XDigit}\\p{XDigit})(\\p{XDigit}\\p{XDigit})(\\p{XDigit}\\p{XDigit})?\\s*$");

    public MetadataFieldReader() {
        this.m_propertyFile = new File(System.getProperty("opennms.home") + File.separator + "etc" + File.separator + "scan-report-metadata.properties");
    }

    public MetadataFieldReader(File propertyFile) {
        this.m_propertyFile = propertyFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<MetadataField> getMetadataFields() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        LinkedHashSet<MetadataField> fields = new LinkedHashSet<MetadataField>();
        if (this.m_propertyFile.exists() && this.m_propertyFile.canRead()) {
            LinkedProperties props = new LinkedProperties();
            FileReader r = null;
            try {
                r = new FileReader(this.m_propertyFile);
                props.load(r);
                LinkedHashSet<String> names = new LinkedHashSet<String>();
                for (Map.Entry<Object, Object> entry : ((Properties)props).entrySet()) {
                    LOG.debug("{}={}", entry.getKey(), entry.getValue());
                    if (entry.getKey() == null) continue;
                    String key = entry.getKey().toString().trim();
                    if (key.endsWith(".description")) {
                        names.add(key.replaceAll("\\.description$", ""));
                        continue;
                    }
                    if (key.endsWith(".validator")) {
                        names.add(key.replaceAll("\\.validator$", ""));
                        continue;
                    }
                    if (key.endsWith(".required")) {
                        names.add(key.replaceAll("\\.required$", ""));
                        continue;
                    }
                    LOG.debug("Unknown metadata entry: {}", (Object)key);
                }
                for (String name : names) {
                    String description = props.getProperty(name + ".description");
                    String validatorClass = props.getProperty(name + ".validator");
                    String requiredString = props.getProperty(name + ".required");
                    Class<?> validator = validatorClass == null ? null : Class.forName(validatorClass);
                    Boolean required = Boolean.valueOf(requiredString);
                    fields.add(new MetadataField(name, description, validator == null ? null : (MetadataField.Validator)validator.newInstance(), required));
                }
            }
            catch (IOException e) {
                try {
                    LOG.warn("Failed to get metadata fields.", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(r);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)r);
            }
            IOUtils.closeQuietly((Reader)r);
        }
        return fields;
    }

    public String getTitle() {
        String title = this.getProperty("gui.title");
        if (title == null) {
            return "On-Demand Scan Report";
        }
        return title;
    }

    public URL getImage() {
        String image = this.getProperty("gui.image");
        if (image != null && image.startsWith("http")) {
            try {
                return new URL(image);
            }
            catch (MalformedURLException e) {
                LOG.warn("Invalid image URL: {}", (Object)image, (Object)e);
            }
        }
        return null;
    }

    public Color getColor(String key) {
        String color = this.getProperty(key);
        if (color != null) {
            Matcher m = HEX_COLOR.matcher(color);
            if (m.matches()) {
                LOG.debug("{} matches", (Object)color);
                Integer red = Integer.valueOf(m.group(1), 16);
                Integer green = Integer.valueOf(m.group(2), 16);
                Integer blue = Integer.valueOf(m.group(3), 16);
                Integer alpha = null;
                if (m.group(4) != null) {
                    alpha = Integer.valueOf(m.group(4), 16);
                }
                LOG.debug("red={}, green={}, blue={}, alpha={}", new Object[]{red, green, blue, alpha});
                if (alpha != null) {
                    return new Color(red, green, blue, alpha);
                }
                return new Color(red, green, blue);
            }
            LOG.debug("{} does not match", (Object)color);
        }
        return null;
    }

    public PollerTheme getTheme() {
        return new PollerTheme(this.getTitle(), this.getImage(), this.getColor("gui.foreground-color"), this.getColor("gui.background-color"), this.getColor("gui.detail-color"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getProperty(String key) {
        if (this.m_propertyFile.exists() && this.m_propertyFile.canRead()) {
            FileReader r;
            block5: {
                String string;
                Properties p = new Properties();
                r = null;
                try {
                    r = new FileReader(this.m_propertyFile);
                    p.load(r);
                    String value = p.getProperty(key);
                    if (value == null || value.trim().isEmpty()) break block5;
                    string = value;
                }
                catch (IOException e) {
                    try {
                        LOG.warn("Failed to get {} from {}", new Object[]{key, this.m_propertyFile, e});
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(r);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Reader)r);
                }
                IOUtils.closeQuietly((Reader)r);
                return string;
            }
            IOUtils.closeQuietly((Reader)r);
        }
        return null;
    }
}

