/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.translator;

import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import org.opennms.netmgt.config.EventTranslatorConfig;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.events.api.EventListener;
import org.opennms.netmgt.events.api.model.IEvent;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventUtils;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Events;
import org.opennms.netmgt.xml.event.Log;
import org.opennms.netmgt.xml.event.Parm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventTranslator
extends AbstractServiceDaemon
implements EventListener {
    private static final Logger LOG = LoggerFactory.getLogger(EventTranslator.class);
    private static EventTranslator s_instance = new EventTranslator();
    private volatile EventIpcManager m_eventMgr;
    private volatile EventTranslatorConfig m_config;
    private volatile boolean m_initialized = false;
    private DataSource m_dataSource;

    public EventTranslator() {
        super("event-translator");
    }

    public EventTranslator(EventIpcManager eventMgr) {
        this();
        this.setEventManager(eventMgr);
    }

    public static synchronized void setInstance(EventTranslator psk) {
        s_instance = psk;
    }

    public static synchronized EventTranslator getInstance() {
        return s_instance;
    }

    protected void onInit() {
        if (this.m_initialized) {
            return;
        }
        this.checkPreRequisites();
        this.createMessageSelectorAndSubscribe();
        this.m_initialized = true;
    }

    private void checkPreRequisites() {
        if (this.m_config == null) {
            throw new IllegalStateException("config has not been set");
        }
        if (this.m_eventMgr == null) {
            throw new IllegalStateException("eventManager has not been set");
        }
        if (this.m_dataSource == null) {
            throw new IllegalStateException("dataSource has not been set");
        }
    }

    protected void onStop() {
        this.m_initialized = false;
        this.m_eventMgr = null;
        this.m_config = null;
    }

    private void createMessageSelectorAndSubscribe() {
        List ueiList = this.m_config.getUEIList();
        ueiList.add("uei.opennms.org/internal/reloadDaemonConfig");
        this.getEventManager().addEventListener((EventListener)this, (Collection)ueiList);
    }

    public void onEvent(IEvent ie) {
        Event e = Event.copyFrom((IEvent)ie);
        if (this.isReloadConfigEvent(e)) {
            this.handleReloadEvent(e);
            return;
        }
        if (this.getName().equals(e.getSource())) {
            LOG.debug("onEvent: ignoring event with EventTranslator as source");
            return;
        }
        List translated = this.m_config.translateEvent(e);
        if (translated != null) {
            if (translated.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("onEvent: received event that matches no translations: {}", (Object)EventUtils.toString((Event)e));
                }
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("onEvent: received valid register ed translation event: {}", (Object)EventUtils.toString((Event)e));
            }
            Log log = new Log();
            Events events = new Events();
            for (Event event : translated) {
                events.addEvent(event);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("onEvent: sended translated event: {}", (Object)EventUtils.toString((Event)e));
            }
            log.setEvents(events);
            this.getEventManager().sendNow(log);
        }
    }

    protected void handleReloadEvent(Event e) {
        LOG.info("onEvent: reloading configuration....");
        EventBuilder ebldr = null;
        try {
            List previousUeis = this.m_config.getUEIList();
            this.m_config.update();
            this.getEventManager().removeEventListener((EventListener)this, (Collection)previousUeis);
            this.getEventManager().addEventListener((EventListener)this, (Collection)this.m_config.getUEIList());
            LOG.debug("onEvent: configuration reloaded.");
            ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigSuccessful", this.getName());
            ebldr.addParam("daemonName", "Translator");
        }
        catch (Throwable exception) {
            LOG.error("onEvent: reload config failed: {}", (Object)e, (Object)exception);
            ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", this.getName());
            ebldr.addParam("daemonName", "Translator");
            ebldr.addParam("reason", exception.getLocalizedMessage().substring(1, 128));
        }
        if (ebldr != null) {
            this.m_eventMgr.sendNow(ebldr.getEvent());
        }
        LOG.info("onEvent: reload configuration: reload configuration contains {} UEI specs.", (Object)this.m_config.getUEIList().size());
    }

    private boolean isReloadConfigEvent(Event event) {
        boolean isTarget = false;
        if ("uei.opennms.org/internal/reloadDaemonConfig".equals(event.getUei())) {
            List parmCollection = event.getParmCollection();
            for (Parm parm : parmCollection) {
                if (!"daemonName".equals(parm.getParmName()) || !"Translator".equalsIgnoreCase(parm.getValue().getContent())) continue;
                isTarget = true;
                break;
            }
            LOG.debug("isReloadConfigEventTarget: Event Translator was target of reload event: {}", (Object)isTarget);
        }
        return isTarget;
    }

    public EventIpcManager getEventManager() {
        return this.m_eventMgr;
    }

    public void setEventManager(EventIpcManager eventMgr) {
        this.m_eventMgr = eventMgr;
    }

    public EventTranslatorConfig getConfig() {
        return this.m_config;
    }

    public void setConfig(EventTranslatorConfig config) {
        this.m_config = config;
    }

    public DataSource getDataSource() {
        return this.m_dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.m_dataSource = dataSource;
    }
}

