/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmpinterfacepoller.pollable;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmpinterfacepoller.pollable.PollContext;
import org.opennms.netmgt.snmpinterfacepoller.pollable.PollableNetwork;
import org.opennms.netmgt.snmpinterfacepoller.pollable.PollableSnmpInterface;

public class PollableInterface {
    private int m_nodeid;
    private String m_ipaddress;
    private String m_netMask;
    private PollableNetwork m_parent;
    private Map<String, PollableSnmpInterface> m_pollablesnmpinterface;
    private String m_packageName;
    private boolean polling = true;

    protected void initialize() {
        try {
            SnmpPeerFactory.init();
        }
        catch (UnknownHostException ex) {
            throw new UndeclaredThrowableException(ex);
        }
        catch (IOException ex) {
            throw new UndeclaredThrowableException(ex);
        }
    }

    public int getNodeid() {
        return this.m_nodeid;
    }

    public void setNodeid(int nodeid) {
        this.m_nodeid = nodeid;
    }

    public String getIpaddress() {
        return this.m_ipaddress;
    }

    public void setIpaddress(String ipaddress) {
        this.m_ipaddress = ipaddress;
    }

    public String getNetMask() {
        return this.m_netMask;
    }

    public void setNetMask(String netMask) {
        this.m_netMask = netMask;
    }

    public PollableInterface(PollableNetwork parent) {
        this.m_parent = parent;
        this.m_pollablesnmpinterface = new HashMap<String, PollableSnmpInterface>();
    }

    public PollableSnmpInterface createPollableSnmpInterface(String name, String criteria, boolean hasPort, int port, boolean hasTimeout, int timeout, boolean hasRetries, int retries, boolean hasMaxVarsPerPdu, int maxVarsPerPdu) {
        PollableSnmpInterface iface = new PollableSnmpInterface(this);
        iface.setName(name);
        iface.setCriteria(criteria);
        InetAddress ipAddr = null;
        ipAddr = InetAddressUtils.addr((String)this.getIpaddress());
        SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(ipAddr);
        if (hasPort) {
            agentConfig.setPort(port);
        }
        if (hasTimeout) {
            agentConfig.setTimeout(timeout);
        }
        if (hasRetries) {
            agentConfig.setRetries(retries);
        }
        if (hasMaxVarsPerPdu) {
            agentConfig.setMaxVarsPerPdu(maxVarsPerPdu);
        }
        iface.setAgentConfig(agentConfig);
        this.m_pollablesnmpinterface.put(name, iface);
        return iface;
    }

    protected void refresh() {
        for (PollableSnmpInterface pi : this.getSnmpinterfacepollableNodes().values()) {
            pi.setSnmpinterfaces(this.getContext().get(this.getNodeid(), pi.getCriteria()));
        }
    }

    protected void suspend() {
        this.polling = false;
    }

    protected void activate() {
        this.polling = true;
    }

    public Map<String, PollableSnmpInterface> getSnmpinterfacepollableNodes() {
        return Collections.unmodifiableMap(this.m_pollablesnmpinterface);
    }

    public boolean polling() {
        return this.polling;
    }

    protected void delete() {
        for (PollableSnmpInterface node : this.getSnmpinterfacepollableNodes().values()) {
            node.delete();
        }
    }

    public PollableNetwork getParent() {
        return this.m_parent;
    }

    public void setParent(PollableNetwork parent) {
        this.m_parent = parent;
    }

    public PollContext getContext() {
        return this.getParent().getContext();
    }

    public String getPackageName() {
        return this.m_packageName;
    }

    public void setPackageName(String packageName) {
        this.m_packageName = packageName;
    }
}

