/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.pollables;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import org.opennms.core.rpc.api.RpcExceptionHandler;
import org.opennms.core.rpc.api.RpcExceptionUtils;
import org.opennms.netmgt.collection.api.PersisterFactory;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.dao.outages.api.ReadablePollOutagesDao;
import org.opennms.netmgt.config.poller.Downtime;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.Parameter;
import org.opennms.netmgt.config.poller.Service;
import org.opennms.netmgt.poller.LocationAwarePollerClient;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.PollerResponse;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.opennms.netmgt.poller.pollables.InvertedStatusServiceMonitorAdaptor;
import org.opennms.netmgt.poller.pollables.LatencyStoringServiceMonitorAdaptor;
import org.opennms.netmgt.poller.pollables.PollConfig;
import org.opennms.netmgt.poller.pollables.PollableService;
import org.opennms.netmgt.scheduler.ScheduleInterval;
import org.opennms.netmgt.scheduler.Timer;
import org.opennms.netmgt.threshd.api.ThresholdingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollableServiceConfig
implements PollConfig,
ScheduleInterval {
    private static final Logger LOG = LoggerFactory.getLogger(PollableServiceConfig.class);
    private PollerConfig m_pollerConfig;
    private PollableService m_service;
    private Map<String, Object> m_parameters = null;
    private Package m_pkg;
    private Timer m_timer;
    private Service m_configService;
    private ServiceMonitor m_serviceMonitor;
    private Map<String, String> m_patternVariables = Collections.emptyMap();
    private final LocationAwarePollerClient m_locationAwarePollerClient;
    private final LatencyStoringServiceMonitorAdaptor m_latencyStoringServiceMonitorAdaptor;
    private final InvertedStatusServiceMonitorAdaptor m_invertedStatusServiceMonitorAdaptor = new InvertedStatusServiceMonitorAdaptor();
    private final ReadablePollOutagesDao m_pollOutagesDao;

    public PollableServiceConfig(PollableService svc, PollerConfig pollerConfig, Package pkg, Timer timer, PersisterFactory persisterFactory, ThresholdingService thresholdingService, LocationAwarePollerClient locationAwarePollerClient, ReadablePollOutagesDao pollOutagesDao) {
        this.m_service = svc;
        this.m_pollerConfig = pollerConfig;
        this.m_pkg = pkg;
        this.m_timer = timer;
        this.m_locationAwarePollerClient = Objects.requireNonNull(locationAwarePollerClient);
        this.m_latencyStoringServiceMonitorAdaptor = new LatencyStoringServiceMonitorAdaptor(pollerConfig, pkg, persisterFactory, thresholdingService);
        this.m_pollOutagesDao = Objects.requireNonNull(pollOutagesDao);
        this.findService();
    }

    private synchronized void findService() {
        Package.ServiceMatch service = (Package.ServiceMatch)this.m_pkg.findService(this.m_service.getSvcName()).orElseThrow(() -> new RuntimeException("Service name not part of package!"));
        this.m_configService = service.service;
        this.m_patternVariables = service.patternVariables;
        this.m_serviceMonitor = this.m_pollerConfig.getServiceMonitor(this.m_configService.getName());
    }

    @Override
    public PollStatus poll() {
        try {
            String packageName = this.getPackageName();
            Long ttlInMs = this.m_configService.getInterval();
            LOG.debug("Polling {} with TTL {} using pkg {}", new Object[]{this.m_service, ttlInMs, packageName});
            CompletableFuture<PollerResponse> future = this.m_locationAwarePollerClient.poll().withService(this.m_service).withMonitor(this.m_serviceMonitor).withTimeToLive(ttlInMs).withAttributes(this.getParameters()).withAdaptor(this.m_latencyStoringServiceMonitorAdaptor).withAdaptor(this.m_invertedStatusServiceMonitorAdaptor).withPatternVariables(this.m_patternVariables).execute();
            PollerResponse response = future.get();
            PollStatus result = response.getPollStatus();
            LOG.debug("Finish polling {} using pkg {} result = {}", new Object[]{this.m_service, packageName, result});
            this.m_service.getContext().trackPoll(this.m_service, result);
            return result;
        }
        catch (Throwable e) {
            return (PollStatus)RpcExceptionUtils.handleException((Throwable)e, (RpcExceptionHandler)new RpcExceptionHandler<PollStatus>(){

                public PollStatus onInterrupted(Throwable cause) {
                    LOG.warn("Interrupted while invoking the poll for {}. Marking the service as UNKNOWN.", (Object)PollableServiceConfig.this.m_service);
                    return PollStatus.unknown("Interrupted while invoking the poll for" + PollableServiceConfig.this.m_service + ". " + e);
                }

                public PollStatus onTimedOut(Throwable cause) {
                    LOG.warn("No response was received when remotely invoking the poll for {}. Marking the service as UNKNOWN.", (Object)PollableServiceConfig.this.m_service);
                    return PollStatus.unknown(String.format("No response received for %s. %s", PollableServiceConfig.this.m_service, cause));
                }

                public PollStatus onRejected(Throwable cause) {
                    LOG.warn("The request to remotely invoke the poll for {} was rejected. Marking the service as UNKNOWN.", (Object)PollableServiceConfig.this.m_service);
                    return PollStatus.unknown(String.format("Remote poll request rejected for %s. %s", PollableServiceConfig.this.m_service, cause));
                }

                public PollStatus onUnknown(Throwable cause) {
                    LOG.error("Unexpected exception while polling {}. Marking service as DOWN", (Object)PollableServiceConfig.this.m_service, (Object)e);
                    return PollStatus.down("Unexpected exception while polling " + PollableServiceConfig.this.m_service + ". " + e);
                }
            });
        }
    }

    @Override
    public synchronized void refresh() {
        Package newPkg = this.m_pollerConfig.getPackage(this.m_pkg.getName());
        if (newPkg == null) {
            LOG.warn("Package named {} no longer exists.", (Object)this.m_pkg.getName());
        }
        this.m_pkg = newPkg;
        this.findService();
    }

    private synchronized Map<String, Object> getParameters() {
        if (this.m_parameters == null) {
            this.m_parameters = this.createParameterMap(this.m_configService);
        }
        return this.m_parameters;
    }

    private Map<String, Object> createParameterMap(Service svc) {
        ConcurrentSkipListMap<String, Object> m = new ConcurrentSkipListMap<String, Object>();
        for (Parameter p : svc.getParameters()) {
            Object val = p.getValue();
            if (val == null) {
                val = p.getAnyObject() == null ? "" : p.getAnyObject();
            }
            m.put(p.getKey(), val);
        }
        return m;
    }

    @Override
    public long getCurrentTime() {
        return this.m_timer.getCurrentTime();
    }

    public synchronized long getInterval() {
        if (this.m_service.isDeleted()) {
            LOG.debug("getInterval(): {} is deleted", (Object)this.m_service);
            return -1L;
        }
        long when = this.m_configService.getInterval();
        boolean ignoreUnmanaged = false;
        if (this.m_service.getStatus().isDown()) {
            long downFor = this.m_timer.getCurrentTime() - this.m_service.getStatusChangeTime();
            LOG.debug("getInterval(): Service {} has been down for {} seconds, checking downtime model.", (Object)this.m_service, (Object)TimeUnit.SECONDS.convert(downFor, TimeUnit.MILLISECONDS));
            boolean matched = false;
            for (Downtime dt : this.m_pkg.getDowntimes()) {
                LOG.debug("getInterval(): Checking downtime: {}", (Object)dt);
                if (dt.getBegin() > downFor) continue;
                LOG.debug("getInterval(): begin ({}) <= {}", (Object)dt.getBegin(), (Object)downFor);
                String delete = dt.getDelete();
                if ("always".equals(delete)) {
                    when = -1L;
                    ignoreUnmanaged = true;
                    matched = true;
                    continue;
                }
                if ("managed".equals(delete)) {
                    when = -1L;
                    matched = true;
                    continue;
                }
                if (dt.getEnd() != null && dt.getEnd() > downFor) {
                    when = dt.getInterval();
                    matched = true;
                    continue;
                }
                when = dt.getInterval();
                matched = true;
            }
            LOG.debug("getInterval(): when={}, matched={}, ignoreUnmanaged={}", new Object[]{when, matched, ignoreUnmanaged});
            if (!matched) {
                LOG.error("Downtime model is invalid on package {}, cannot schedule service {}", (Object)this.m_pkg.getName(), (Object)this.m_service);
                return -1L;
            }
        }
        if (when < 0L) {
            this.m_service.sendDeleteEvent(ignoreUnmanaged);
        }
        return when;
    }

    public synchronized boolean scheduledSuspension() {
        long nodeId = this.m_service.getNodeId();
        for (String outageName : this.m_pkg.getOutageCalendars()) {
            if (!this.m_pollOutagesDao.isTimeInOutage(this.m_timer.getCurrentTime(), outageName) || !this.m_pollOutagesDao.isNodeIdInOutage(nodeId, outageName) && !this.m_pollOutagesDao.isInterfaceInOutage(this.m_service.getIpAddr(), outageName) && !this.m_pollOutagesDao.isInterfaceInOutage("match-any", outageName)) continue;
            LOG.debug("scheduledOutage: configured outage '{}' applies, {} will not be polled.", (Object)outageName, (Object)this.m_configService);
            return true;
        }
        return false;
    }

    public synchronized String getPackageName() {
        return this.m_pkg.getName();
    }

    public int getNodeId() {
        return this.m_service.getNodeId();
    }
}

