/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.pollables;

import java.net.InetAddress;
import java.util.Date;
import java.util.Map;
import org.opennms.core.logging.Logging;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.pollables.LockUnavailable;
import org.opennms.netmgt.poller.pollables.PollConfig;
import org.opennms.netmgt.poller.pollables.PollContext;
import org.opennms.netmgt.poller.pollables.PollEvent;
import org.opennms.netmgt.poller.pollables.PollableElement;
import org.opennms.netmgt.poller.pollables.PollableInterface;
import org.opennms.netmgt.poller.pollables.PollableNetwork;
import org.opennms.netmgt.poller.pollables.PollableNode;
import org.opennms.netmgt.poller.pollables.PollableServiceConfig;
import org.opennms.netmgt.poller.pollables.PollableVisitor;
import org.opennms.netmgt.poller.pollables.Scope;
import org.opennms.netmgt.scheduler.PostponeNecessary;
import org.opennms.netmgt.scheduler.ReadyRunnable;
import org.opennms.netmgt.scheduler.Schedule;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollableService
extends PollableElement
implements ReadyRunnable,
MonitoredService {
    private static final Logger LOG = LoggerFactory.getLogger(PollableService.class);
    private final String m_svcName;
    private volatile PollConfig m_pollConfig;
    private volatile PollStatus m_oldStatus;
    private volatile Schedule m_schedule;
    private volatile long m_statusChangeTime = 0L;

    public PollableService(PollableInterface iface, String svcName) {
        super(iface, Scope.SERVICE);
        this.m_svcName = svcName;
    }

    public PollableInterface getInterface() {
        return (PollableInterface)this.getParent();
    }

    public PollableNode getNode() {
        return this.getInterface().getNode();
    }

    public PollableNetwork getNetwork() {
        return this.getInterface().getNetwork();
    }

    @Override
    public PollContext getContext() {
        return this.getInterface().getContext();
    }

    @Override
    public String getSvcName() {
        return this.m_svcName;
    }

    @Override
    public String getIpAddr() {
        return this.getInterface().getIpAddr();
    }

    @Override
    public int getNodeId() {
        return this.getInterface().getNodeId();
    }

    @Override
    public String getNodeLabel() {
        return this.getInterface().getNodeLabel();
    }

    @Override
    public String getNodeLocation() {
        return this.getInterface().getNodeLocation();
    }

    @Override
    protected void visitThis(PollableVisitor v) {
        super.visitThis(v);
        v.visitService(this);
    }

    public void setPollConfig(PollableServiceConfig pollConfig) {
        this.m_pollConfig = pollConfig;
    }

    @Override
    public PollStatus poll() {
        PollStatus newStatus = this.m_pollConfig.poll();
        if (!newStatus.isUnknown()) {
            this.updateStatus(newStatus);
        }
        return this.getStatus();
    }

    @Override
    public InetAddress getAddress() {
        return this.getInterface().getAddress();
    }

    public PollStatus doPoll() {
        if (this.getContext().isNodeProcessingEnabled()) {
            return this.getParent().doPoll(this);
        }
        this.resetStatusChanged();
        return this.poll();
    }

    @Override
    public Event createDownEvent(Date date) {
        return this.getContext().createEvent("uei.opennms.org/nodes/nodeLostService", this.getNodeId(), this.getAddress(), this.getSvcName(), date, this.getStatus().getReason());
    }

    @Override
    public Event createUpEvent(Date date) {
        return this.getContext().createEvent("uei.opennms.org/nodes/nodeRegainedService", this.getNodeId(), this.getAddress(), this.getSvcName(), date, this.getStatus().getReason());
    }

    public Event createUnresponsiveEvent(Date date) {
        return this.getContext().createEvent("uei.opennms.org/nodes/serviceUnresponsive", this.getNodeId(), this.getAddress(), this.getSvcName(), date, this.getStatus().getReason());
    }

    public Event createResponsiveEvent(Date date) {
        return this.getContext().createEvent("uei.opennms.org/nodes/serviceResponsive", this.getNodeId(), this.getAddress(), this.getSvcName(), date, this.getStatus().getReason());
    }

    @Override
    public void createOutage(PollEvent cause) {
        super.createOutage(cause);
        this.getContext().openOutage(this, cause);
    }

    @Override
    protected void resolveOutage(PollEvent resolution) {
        super.resolveOutage(resolution);
        this.getContext().resolveOutage(this, resolution);
    }

    public String toString() {
        return String.format("PollableService[location=%s, interface=%s, svcName=%s]", this.getNodeLocation(), this.getInterface(), this.getSvcName());
    }

    @Override
    public void processStatusChange(Date date) {
        if (this.getContext().isServiceUnresponsiveEnabled()) {
            if (this.isStatusChanged() && this.getStatus().equals(PollStatus.unresponsive())) {
                this.getContext().sendEvent(this.createUnresponsiveEvent(date));
                if (this.m_oldStatus.equals(PollStatus.up())) {
                    this.resetStatusChanged();
                }
            } else if (this.isStatusChanged() && this.m_oldStatus.equals(PollStatus.unresponsive())) {
                this.getContext().sendEvent(this.createResponsiveEvent(date));
                if (this.getStatus().equals(PollStatus.up())) {
                    this.resetStatusChanged();
                }
            }
        }
        super.processStatusChange(date);
    }

    @Override
    public void updateStatus(PollStatus newStatus) {
        PollStatus currentStatus;
        if (!this.getContext().isServiceUnresponsiveEnabled() && newStatus.equals(PollStatus.unresponsive())) {
            newStatus = PollStatus.down();
        }
        if (!(currentStatus = this.getStatus()).equals(newStatus)) {
            this.m_oldStatus = this.getStatus();
            this.setStatusChangeTime(this.m_pollConfig.getCurrentTime());
        }
        super.updateStatus(newStatus);
        if (!currentStatus.equals(newStatus)) {
            this.getSchedule().adjustSchedule();
        }
    }

    public synchronized void setSchedule(Schedule schedule) {
        this.m_schedule = schedule;
    }

    public synchronized Schedule getSchedule() {
        return this.m_schedule;
    }

    public long getStatusChangeTime() {
        return this.m_statusChangeTime;
    }

    private void setStatusChangeTime(long statusChangeTime) {
        this.m_statusChangeTime = statusChangeTime;
    }

    public boolean isReady() {
        return true;
    }

    public void run() {
        this.doRun(500);
    }

    public PollStatus doRun() {
        return this.doRun(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PollStatus doRun(int timeout) {
        Map mdc = Logging.getCopyOfContextMap();
        try {
            PollStatus status;
            Logging.putThreadContext((String)"service", (String)this.m_svcName);
            Logging.putThreadContext((String)"ipAddress", (String)this.getIpAddr());
            Logging.putThreadContext((String)"nodeId", (String)Integer.toString(this.getNodeId()));
            Logging.putThreadContext((String)"nodeLabel", (String)this.getNodeLabel());
            long startDate = System.currentTimeMillis();
            LOG.debug("Start Scheduled Poll of service {}", (Object)this);
            if (this.getContext().isNodeProcessingEnabled()) {
                PollRunner r = new PollRunner();
                try {
                    this.withTreeLock(r, (long)timeout);
                }
                catch (LockUnavailable e) {
                    LOG.info("Postponing poll for {}. Another service is currently holding the lock.", (Object)this);
                    throw new PostponeNecessary("LockUnavailable postpone poll");
                }
                status = r.getPollStatus();
            } else {
                this.doPoll();
                this.processStatusChange(new Date());
                status = this.getStatus();
            }
            LOG.debug("Finish Scheduled Poll of service {}, started at {}", (Object)this, (Object)new Date(startDate));
            PollStatus pollStatus = status;
            return pollStatus;
        }
        finally {
            Logging.setContextMap((Map)mdc);
        }
    }

    @Override
    public void delete() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                PollableService.super.delete();
                PollableService.this.m_schedule.unschedule();
            }
        };
        this.withTreeLock(r);
    }

    public void schedule() {
        if (this.m_schedule == null) {
            throw new IllegalStateException("Cannot schedule a service whose schedule is set to null");
        }
        this.m_schedule.schedule();
    }

    public void sendDeleteEvent(boolean ignoreUnmanaged) {
        Event event = this.getContext().createEvent("uei.opennms.org/nodes/deleteService", this.getNodeId(), this.getAddress(), this.getSvcName(), new Date(), this.getStatus().getReason());
        if (ignoreUnmanaged) {
            Parm parm = new Parm();
            parm.setParmName("ignoreUnmanaged");
            parm.setValue(null);
            event.addParm(new Parm("ignoreUnmanaged", "true"));
        }
        this.getContext().sendEvent(event);
    }

    public void refreshConfig() {
        this.m_pollConfig.refresh();
    }

    private final class PollRunner
    implements Runnable {
        private volatile PollStatus m_pollStatus;

        private PollRunner() {
        }

        @Override
        public void run() {
            PollableService.this.doPoll();
            PollableService.this.getNode().processStatusChange(new Date());
            this.m_pollStatus = PollableService.this.getStatus();
        }

        public PollStatus getPollStatus() {
            return this.m_pollStatus;
        }
    }
}

